/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.blocks.soul_weaver;

import com.glisco.conjuring.Conjuring;
import com.glisco.conjuring.blocks.BlackstonePedestalBlockEntity;
import com.glisco.conjuring.blocks.ConjuringBlocks;
import com.glisco.conjuring.blocks.RitualCore;
import com.glisco.conjuring.blocks.soul_weaver.SoulWeaverRecipe;
import com.glisco.conjuring.util.ConjuringParticleEvents;
import io.wispforest.owo.blockentity.LinearProcess;
import io.wispforest.owo.blockentity.LinearProcessExecutor;
import io.wispforest.owo.ops.ItemOps;
import io.wispforest.owo.ops.WorldOps;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.ServerParticles;
import io.wispforest.owo.util.VectorRandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulWeaverBlockEntity
extends class_2586
implements RitualCore {
    public static final class_5558<SoulWeaverBlockEntity> TICKER = (world1, pos1, state, blockEntity) -> blockEntity.ritualExecutor.tick();
    private static final LinearProcess<SoulWeaverBlockEntity> PROCESS = new LinearProcess(165);
    private final List<class_2338> pedestals = new ArrayList<class_2338>();
    @NotNull
    private class_1799 item = class_1799.field_8037;
    private boolean lit = false;
    private final LinearProcessExecutor<SoulWeaverBlockEntity> ritualExecutor = PROCESS.createExecutor((Object)this);
    private SoulWeaverRecipe cachedRecipe = null;

    public SoulWeaverBlockEntity(class_2338 pos, class_2680 state) {
        super(ConjuringBlocks.Entities.SOUL_WEAVER, pos, state);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        PROCESS.configureExecutor(this.ritualExecutor, world.field_9236);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.loadPedestals(tag, this.pedestals);
        this.ritualExecutor.readState(tag);
        this.item = ItemOps.get((class_2487)tag, (String)"Item");
        if (tag.method_10573("CachedRecipe", 8) && this.field_11863 != null) {
            this.cachedRecipe = this.field_11863.method_8433().method_8130(new class_2960(tag.method_10558("CachedRecipe"))).orElse(null);
        }
        this.lit = tag.method_10577("Lit");
    }

    public void method_11007(class_2487 tag) {
        this.savePedestals(tag, this.pedestals);
        this.ritualExecutor.writeState(tag);
        ItemOps.store((class_1799)this.item, (class_2487)tag, (String)"Item");
        if (this.cachedRecipe != null) {
            tag.method_10582("CachedRecipe", this.cachedRecipe.method_8114().toString());
        }
        tag.method_10556("Lit", this.lit);
    }

    @Override
    public boolean linkPedestal(class_2338 pedestal) {
        if (this.pedestals.size() >= 4) {
            return false;
        }
        if (!this.pedestals.contains(pedestal)) {
            this.pedestals.add(pedestal);
        }
        if (this.field_11863.field_9236) {
            ClientParticles.setParticleCount((int)25);
            ClientParticles.spawnLine((class_2394)class_2398.field_11249, (class_1937)this.field_11863, (class_243)class_243.method_24954((class_2382)this.field_11867).method_1031(0.5, 0.4, 0.5), (class_243)class_243.method_24954((class_2382)pedestal).method_1031(0.5, 0.75, 0.5), (float)0.0f);
        }
        this.method_5431();
        return true;
    }

    @Override
    public boolean removePedestal(class_2338 pedestal, boolean pedestalActive) {
        boolean returnValue = this.pedestals.remove(pedestal);
        this.method_5431();
        if (!this.field_11863.method_8608()) {
            ServerParticles.issueEvent((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24954((class_2382)this.field_11867), (class_2960)ConjuringParticleEvents.UNLINK_WEAVER, buffer -> buffer.method_10807(pedestal));
        }
        this.ritualExecutor.cancel();
        return returnValue;
    }

    @NotNull
    public class_1799 getItem() {
        return this.item;
    }

    public void setItem(@NotNull class_1799 stack) {
        this.item = stack;
        this.method_5431();
    }

    @Override
    public List<class_2338> getPedestalPositions() {
        return this.pedestals;
    }

    @Override
    public boolean tryStartRitual(class_1657 player) {
        if (!this.verifyRecipe() || !this.isLit()) {
            return false;
        }
        if (this.field_11863.field_9229.nextDouble() < 0.014) {
            this.field_11863.method_8396(null, this.field_11867, Conjuring.WEEE, class_3419.field_15245, 1.0f, 1.0f);
        } else {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14858, class_3419.field_15245, 1.0f, 0.0f);
        }
        this.ritualExecutor.begin();
        this.method_5431();
        return true;
    }

    public boolean verifyRecipe() {
        if (this.item.method_7960()) {
            return false;
        }
        class_1277 testInventory = new class_1277(5);
        testInventory.method_5447(0, this.item);
        int index = 1;
        for (class_2338 pedestal : this.pedestals) {
            BlackstonePedestalBlockEntity entity = (BlackstonePedestalBlockEntity)this.field_11863.method_8321(pedestal);
            if (entity.getItem().method_7960()) {
                return false;
            }
            testInventory.method_5447(index, entity.getItem());
            ++index;
        }
        Optional recipeOptional = this.field_11863.method_8433().method_8132((class_3956)SoulWeaverRecipe.Type.INSTANCE, (class_1263)testInventory, this.field_11863);
        if (recipeOptional.isEmpty()) {
            this.cachedRecipe = null;
            return false;
        }
        this.cachedRecipe = (SoulWeaverRecipe)recipeOptional.get();
        return true;
    }

    public void onBroken() {
        if (!this.item.method_7960()) {
            class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)((double)this.field_11867.method_10264() + 1.25), (double)this.field_11867.method_10260(), (class_1799)this.item);
        }
        this.ritualExecutor.cancel();
    }

    public double getShakeScaleFactor() {
        return this.ritualExecutor.getProcessTick() > 40 ? (double)this.ritualExecutor.getProcessTick() * 0.001 : 0.0;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
        this.method_5431();
    }

    public boolean isRunning() {
        return this.ritualExecutor.running();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    public void method_5431() {
        super.method_5431();
        WorldOps.updateIfOnServer((class_1937)this.field_11863, (class_2338)this.method_11016());
    }

    static {
        PROCESS.addClientStep(0, 5, (executor, weaver) -> {
            for (class_2338 pos : weaver.pedestals) {
                if (!(weaver.field_11863.method_8321(pos) instanceof BlackstonePedestalBlockEntity)) continue;
                class_2338 pVector = pos.method_10059((class_2382)weaver.field_11867);
                ClientParticles.setVelocity((class_243)new class_243((double)pVector.method_10263() * 0.115, 0.0, (double)pVector.method_10260() * 0.115));
                ClientParticles.spawnWithMaxAge((class_2394)class_2398.field_22246, (class_243)class_243.method_24954((class_2382)weaver.field_11867).method_1031(0.5, 0.4, 0.5), (int)10);
            }
        });
        PROCESS.addClientEvent(10, (executor, weaver) -> {
            ClientParticles.setParticleCount((int)16);
            ClientParticles.persist();
            for (class_2338 pedestal : weaver.pedestals) {
                ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_11239, (class_1937)weaver.field_11863, (class_2338)pedestal, (class_243)new class_243(0.5, 1.25, 0.5), (double)0.1);
            }
            ClientParticles.reset();
        });
        PROCESS.addClientStep(10, 155, (executor, weaver) -> {
            class_1937 world = weaver.field_11863;
            class_2338 pos = weaver.field_11867;
            if (executor.getProcessTick() % 2 == 0) {
                if (executor.getProcessTick() < 140) {
                    for (class_2338 pedestalPos : weaver.pedestals) {
                        if (!(world.method_8321(pedestalPos) instanceof BlackstonePedestalBlockEntity) || !((BlackstonePedestalBlockEntity)world.method_8321(pedestalPos)).isActive()) continue;
                        class_2338 p = pedestalPos.method_10069(0, 1, 0);
                        class_2338 pVector = pedestalPos.method_10059((class_2382)weaver.field_11867);
                        class_243 particleOrigin = VectorRandomUtils.getRandomOffset((class_1937)world, (class_243)new class_243(0.5, 0.3, 0.5).method_1019(class_243.method_24954((class_2382)p)), (double)0.1);
                        ClientParticles.setVelocity((class_243)new class_243((double)((float)pVector.method_10263() * -0.055f), (double)-0.05f, (double)((float)pVector.method_10260() * -0.05f)));
                        ClientParticles.spawnWithMaxAge((class_2394)class_2398.field_23114, (class_243)particleOrigin, (int)30);
                    }
                }
                if (executor.getProcessTick() > 33) {
                    ClientParticles.setParticleCount((int)2);
                    ClientParticles.spawnCenteredOnBlock((class_2394)class_2398.field_22246, (class_1937)world, (class_2338)pos.method_10069(0, 1, 0), (double)0.45f);
                    ClientParticles.setVelocity((class_243)new class_243(0.05, 0.03, 0.0));
                    ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_22246, (class_1937)world, (class_2338)pos, (class_243)new class_243(0.5, 0.3, 0.5), (double)0.1);
                    ClientParticles.setVelocity((class_243)new class_243(-0.05, 0.03, 0.0));
                    ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_22246, (class_1937)world, (class_2338)pos, (class_243)new class_243(0.5, 0.3, 0.5), (double)0.1);
                    ClientParticles.setVelocity((class_243)new class_243(0.0, 0.03, 0.05));
                    ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_22246, (class_1937)world, (class_2338)pos, (class_243)new class_243(0.5, 0.3, 0.5), (double)0.1);
                    ClientParticles.setVelocity((class_243)new class_243(0.0, 0.03, -0.05));
                    ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_22246, (class_1937)world, (class_2338)pos, (class_243)new class_243(0.5, 0.3, 0.5), (double)0.1);
                }
            }
        });
        PROCESS.whenFinishedClient((executor, weaver) -> {
            try {
                class_310.method_1551().method_1483().method_4875(new class_2960("minecraft", "block.beacon.ambient"), class_3419.field_15245);
            }
            catch (Exception exception) {
                // empty catch block
            }
            class_2388 particle = new class_2388(class_2398.field_11217, class_2246.field_23880.method_9564());
            ClientParticles.setParticleCount((int)30);
            ClientParticles.spawnWithOffsetFromBlock((class_2394)particle, (class_1937)weaver.field_11863, (class_2338)weaver.field_11867, (class_243)new class_243(0.5, 1.3, 0.5), (double)0.2);
            ClientParticles.setParticleCount((int)40);
            ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_11239, (class_1937)weaver.field_11863, (class_2338)weaver.field_11867, (class_243)new class_243(0.5, 1.25, 0.5), (double)0.15);
        });
        PROCESS.addServerEvent(10, (executor, weaver) -> {
            for (class_2338 pedestal : weaver.pedestals) {
                ((BlackstonePedestalBlockEntity)weaver.field_11863.method_8321(pedestal)).setActive(true);
                ((BlackstonePedestalBlockEntity)weaver.field_11863.method_8321(pedestal)).setItem(class_1799.field_8037);
            }
        });
        PROCESS.addServerEvent(15, (executor, weaver) -> weaver.field_11863.method_8396(null, weaver.field_11867, class_3417.field_15045, class_3419.field_15245, 1.5f, 0.7f));
        PROCESS.addServerEvent(127, (executor, weaver) -> weaver.field_11863.method_8396(null, weaver.field_11867, class_3417.field_14669, class_3419.field_15245, 0.15f, 2.0f));
        PROCESS.whenFinishedServer((executor, weaver) -> {
            SoulWeaverRecipe cachedRecipe = weaver.cachedRecipe;
            weaver.field_11863.method_8396(null, weaver.field_11867, class_3417.field_14956, class_3419.field_15245, 1.0f, 0.0f);
            for (class_2338 pedestal : weaver.pedestals) {
                ((BlackstonePedestalBlockEntity)weaver.field_11863.method_8321(pedestal)).setActive(false);
            }
            if (cachedRecipe != null) {
                if (cachedRecipe.transferTag) {
                    class_1799 output = cachedRecipe.method_8110();
                    output.method_7980(weaver.getItem().method_7948());
                    weaver.setItem(output);
                } else {
                    weaver.setItem(cachedRecipe.method_8110());
                }
            }
            weaver.setLit(false);
            weaver.cachedRecipe = null;
        });
        PROCESS.onCancelledServer((executor, weaver) -> {
            class_1937 world = weaver.field_11863;
            class_2338 pos = weaver.field_11867;
            for (class_2338 pedestal : weaver.pedestals) {
                ((BlackstonePedestalBlockEntity)world.method_8321(pedestal)).setActive(false);
            }
            ((class_3218)world).method_8503().method_3760().method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 25.0, world.method_27983(), (class_2596)new class_2675((class_2394)class_2398.field_11237, false, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.15, (double)pos.method_10260() + 0.5, 0.15f, 0.15f, 0.15f, 0.05f, 15));
            ((class_3218)world).method_8503().method_3760().method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 25.0, world.method_27983(), (class_2596)new class_2770(new class_2960("minecraft", "block.beacon.ambient"), class_3419.field_15245));
            world.method_8396(null, pos, class_3417.field_14688, class_3419.field_15245, 1.0f, 0.0f);
            weaver.cachedRecipe = null;
            weaver.setLit(false);
            weaver.setItem(class_1799.field_8037);
        });
        PROCESS.finish();
    }
}

