/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.blocks.gem_tinkerer;

import com.glisco.conjuring.Conjuring;
import com.glisco.conjuring.blocks.ConjuringBlocks;
import com.glisco.conjuring.blocks.gem_tinkerer.GemTinkererRecipe;
import com.glisco.conjuring.items.GemItem;
import com.glisco.conjuring.items.soul_alloy_tools.SoulAlloyTool;
import io.wispforest.owo.blockentity.LinearProcess;
import io.wispforest.owo.blockentity.LinearProcessExecutor;
import io.wispforest.owo.ops.WorldOps;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class GemTinkererBlockEntity
extends class_2586 {
    public static final class_5558<GemTinkererBlockEntity> TICKER = (world1, pos1, state, blockEntity) -> blockEntity.executor.tick();
    private static final LinearProcess<GemTinkererBlockEntity> PROCESS = new LinearProcess(200);
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private final LinearProcessExecutor<GemTinkererBlockEntity> executor = PROCESS.createExecutor((Object)this);
    private GemTinkererRecipe cachedRecipe;
    private boolean particlesShown = false;

    public GemTinkererBlockEntity(class_2338 pos, class_2680 state) {
        super(ConjuringBlocks.Entities.GEM_TINKERER, pos, state);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        PROCESS.configureExecutor(this.executor, world.field_9236);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.inventory.clear();
        class_1262.method_5429((class_2487)tag, this.inventory);
        this.executor.readState(tag);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    public void method_11007(class_2487 tag) {
        class_1262.method_5426((class_2487)tag, this.inventory);
        this.executor.writeState(tag);
    }

    public void method_5431() {
        super.method_5431();
        WorldOps.updateIfOnServer((class_1937)this.field_11863, (class_2338)this.method_11016());
    }

    public boolean verifyRecipe() {
        class_1277 testInventory = new class_1277(5);
        for (int i = 0; i < this.inventory.size(); ++i) {
            testInventory.method_5447(i, (class_1799)this.inventory.get(i));
        }
        Optional recipeOptional = this.field_11863.method_8433().method_8132((class_3956)GemTinkererRecipe.Type.INSTANCE, (class_1263)testInventory, this.field_11863);
        if (recipeOptional.isEmpty()) {
            return false;
        }
        this.cachedRecipe = (GemTinkererRecipe)recipeOptional.get();
        return true;
    }

    public class_1269 onUse(class_1657 player) {
        if (this.verifyRecipe()) {
            if (this.field_11863.method_8608()) {
                return class_1269.field_5812;
            }
            this.executor.begin();
            this.method_5431();
            return class_1269.field_5812;
        }
        if (!(((class_1799)this.inventory.get(0)).method_7909() instanceof SoulAlloyTool)) {
            return class_1269.field_5811;
        }
        ArrayList<SoulAlloyTool.SoulAlloyModifier> presentModifiers = new ArrayList<SoulAlloyTool.SoulAlloyModifier>();
        for (int i = 1; i < this.inventory.size(); ++i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            if (!(((class_1799)this.inventory.get(i)).method_7909() instanceof GemItem)) {
                return class_1269.field_5811;
            }
            SoulAlloyTool.SoulAlloyModifier modifier = ((GemItem)((class_1799)this.inventory.get(i)).method_7909()).getModifier();
            presentModifiers.add(modifier);
        }
        if (presentModifiers.size() < 1) {
            return class_1269.field_5811;
        }
        if (!SoulAlloyTool.canAddModifiers((class_1799)this.inventory.get(0), presentModifiers)) {
            return class_1269.field_5811;
        }
        if (!this.field_11863.method_8608()) {
            this.executor.begin();
            this.method_5431();
            Conjuring.GEM_TINKERING_CRITERION.trigger((class_3222)player);
        }
        return class_1269.field_5812;
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public boolean isRunning() {
        return this.executor.running();
    }

    public double getScalar() {
        return this.executor.getProcessTick() < 100 ? 1.0 + (double)this.executor.getProcessTick() / 4.0 : 1.0 + (double)(200 - this.executor.getProcessTick()) / 4.0;
    }

    public boolean particles() {
        if (!this.particlesShown && this.executor.getProcessTick() == 100) {
            this.particlesShown = true;
            return true;
        }
        return false;
    }

    public boolean isCraftingComplete() {
        return this.executor.getProcessTick() > 100;
    }

    static {
        PROCESS.whenFinishedClient((executor, tinkerer) -> {
            ((GemTinkererBlockEntity)((Object)((Object)executor.getTarget()))).particlesShown = false;
        });
        PROCESS.addServerEvent(1, (executor, tinkerer) -> tinkerer.field_11863.method_8396(null, tinkerer.field_11867, class_3417.field_14908, class_3419.field_15245, 0.25f, 0.0f));
        PROCESS.addServerEvent(100, (executor, tinkerer) -> {
            class_2371<class_1799> inventory = tinkerer.getInventory();
            tinkerer.field_11863.method_8396(null, tinkerer.field_11867, class_3417.field_14703, class_3419.field_15245, 1.0f, 0.0f);
            tinkerer.verifyRecipe();
            if (tinkerer.cachedRecipe == null) {
                for (int i = 1; i < inventory.size(); ++i) {
                    class_1792 patt6192$temp = ((class_1799)inventory.get(i)).method_7909();
                    if (!(patt6192$temp instanceof GemItem)) continue;
                    GemItem gem = (GemItem)patt6192$temp;
                    if (!SoulAlloyTool.canAddModifier((class_1799)inventory.get(0), gem.getModifier())) continue;
                    SoulAlloyTool.addModifier((class_1799)inventory.get(0), ((GemItem)((class_1799)inventory.get(i)).method_7909()).getModifier());
                    inventory.set(i, (Object)class_1799.field_8037);
                }
            } else {
                inventory.clear();
                inventory.set(0, (Object)tinkerer.cachedRecipe.method_8110());
            }
            tinkerer.cachedRecipe = null;
            tinkerer.method_5431();
        });
        PROCESS.finish();
    }
}

