/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.blocks.conjurer;

import com.glisco.conjuring.util.ConjuringParticleEvents;
import com.mojang.serialization.DynamicOps;
import io.wispforest.owo.particles.ServerParticles;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1317;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_6005;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class ConjurerLogic {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int field_30951 = 1;
    private int spawnDelay = 20;
    private class_6005<class_1952> spawnPotentials = class_6005.method_38062();
    private class_1952 spawnEntry = new class_1952();
    private double field_9161;
    private double field_9159;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private class_1297 renderedEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;
    private final Random random = new Random();
    private boolean requiresPlayer = true;
    private boolean active = false;

    public void setEntityId(class_1299<?> type) {
        this.spawnEntry.method_38093().method_10582("id", class_2378.field_11145.method_10221(type).toString());
    }

    public boolean isPlayerInRange(class_1937 world, class_2338 pos) {
        return world.method_8482(pos) == 0 && (!this.requiresPlayer || world.method_18458((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)this.requiredPlayerRange));
    }

    public void clientTick(class_1937 world, class_2338 pos) {
        if (!this.isPlayerInRange(world, pos) || !this.active) {
            this.field_9159 = this.field_9161;
        } else {
            double $$2 = (double)pos.method_10263() + world.field_9229.nextDouble();
            double $$3 = (double)pos.method_10264() + world.field_9229.nextDouble();
            double $$4 = (double)pos.method_10260() + world.field_9229.nextDouble();
            world.method_8406((class_2394)class_2398.field_11208, $$2, $$3, $$4, 0.0, 1.0, 0.0);
            world.method_8406((class_2394)class_2398.field_22246, $$2, $$3, $$4, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.field_9159 = this.field_9161;
            this.field_9161 = (this.field_9161 + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(class_3218 world, class_2338 pos) {
        if (this.isPlayerInRange((class_1937)world, pos) && this.active) {
            if (this.spawnDelay == -1) {
                this.updateSpawns((class_1937)world, pos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean $$2 = false;
                for (int $$3 = 0; $$3 < this.spawnCount; ++$$3) {
                    class_1952.class_6542 $$12;
                    double $$10;
                    class_2487 $$4 = this.spawnEntry.method_38093();
                    Optional $$5 = class_1299.method_17684((class_2487)$$4);
                    if ($$5.isEmpty()) {
                        this.updateSpawns((class_1937)world, pos);
                        return;
                    }
                    class_2499 $$6 = $$4.method_10554("Pos", 6);
                    int $$7 = $$6.size();
                    double $$8 = $$7 >= 1 ? $$6.method_10611(0) : (double)pos.method_10263() + (world.field_9229.nextDouble() - world.field_9229.nextDouble()) * (double)this.spawnRange + 0.5;
                    double $$9 = $$7 >= 2 ? $$6.method_10611(1) : (double)(pos.method_10264() + world.field_9229.nextInt(3) - 1);
                    double d = $$10 = $$7 >= 3 ? $$6.method_10611(2) : (double)pos.method_10260() + (world.field_9229.nextDouble() - world.field_9229.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (!world.method_18026(((class_1299)$$5.get()).method_17683($$8, $$9, $$10))) continue;
                    class_2338 $$11 = new class_2338($$8, $$9, $$10);
                    if (!this.spawnEntry.method_38097().isPresent() ? !class_1317.method_20638((class_1299)((class_1299)$$5.get()), (class_5425)world, (class_3730)class_3730.field_16469, (class_2338)$$11, (Random)world.method_8409()) : !((class_1299)$$5.get()).method_5891().method_6136() && world.method_8407() == class_1267.field_5801 || !($$12 = (class_1952.class_6542)this.spawnEntry.method_38097().get()).comp_66().method_37955((Comparable)Integer.valueOf(world.method_8314(class_1944.field_9282, $$11))) || !$$12.comp_67().method_37955((Comparable)Integer.valueOf(world.method_8314(class_1944.field_9284, $$11)))) continue;
                    class_1297 $$13 = class_1299.method_17842((class_2487)$$4, (class_1937)world, $$3x -> {
                        $$3x.method_5808($$8, $$9, $$10, $$3x.method_36454(), $$3x.method_36455());
                        return $$3x;
                    });
                    if ($$13 == null) {
                        this.updateSpawns((class_1937)world, pos);
                        return;
                    }
                    int $$14 = world.method_18467($$13.getClass(), new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1)).method_1014((double)this.spawnRange)).size();
                    if ($$14 >= this.maxNearbyEntities) {
                        this.updateSpawns((class_1937)world, pos);
                        return;
                    }
                    $$13.method_5808($$13.method_23317(), $$13.method_23318(), $$13.method_23321(), world.field_9229.nextFloat() * 360.0f, 0.0f);
                    if ($$13 instanceof class_1308) {
                        class_1308 $$15 = (class_1308)$$13;
                        if (this.spawnEntry.method_38097().isEmpty() && !$$15.method_5979((class_1936)world, class_3730.field_16469) || !$$15.method_5957((class_4538)world)) continue;
                        if (this.spawnEntry.method_38093().method_10546() == 1 && this.spawnEntry.method_38093().method_10573("id", 8)) {
                            ((class_1308)$$13).method_5943((class_5425)world, world.method_8404($$13.method_24515()), class_3730.field_16469, (class_1315)null, (class_2487)null);
                        }
                    }
                    if (!world.method_30736($$13)) {
                        this.updateSpawns((class_1937)world, pos);
                        return;
                    }
                    ServerParticles.issueEvent((class_3218)world, (class_243)class_243.method_24954((class_2382)pos), (class_2960)ConjuringParticleEvents.CONJURER_SUMMON);
                    if ($$13 instanceof class_1308) {
                        ((class_1308)$$13).method_5990();
                    }
                    $$2 = true;
                }
                if ($$2) {
                    this.updateSpawns((class_1937)world, pos);
                }
            }
        }
    }

    public void updateSpawns(class_1937 world, class_2338 pos) {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.method_34992(this.random).ifPresent($$2 -> this.setSpawnEntry(world, pos, (class_1952)$$2.method_34983()));
        this.sendStatus(world, pos, 1);
    }

    public void readNbt(@Nullable class_1937 world, class_2338 pos, class_2487 nbt) {
        this.spawnDelay = nbt.method_10568("Delay");
        boolean $$3 = nbt.method_10573("SpawnPotentials", 9);
        boolean $$4 = nbt.method_10573("SpawnData", 10);
        if (!$$3) {
            class_1952 $$5 = $$4 ? class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("SpawnData")).resultOrPartial($$0 -> LOGGER.warn("Invalid SpawnData: {}", $$0)).orElseGet(class_1952::new) : new class_1952();
            this.spawnPotentials = class_6005.method_38061((Object)$$5);
            this.setSpawnEntry(world, pos, $$5);
        } else {
            class_2499 $$7 = nbt.method_10554("SpawnPotentials", 10);
            this.spawnPotentials = class_1952.field_34461.parse((DynamicOps)class_2509.field_11560, (Object)$$7).resultOrPartial($$0 -> LOGGER.warn("Invalid SpawnPotentials list: {}", $$0)).orElseGet(() -> class_6005.method_38062());
            if ($$4) {
                class_1952 $$8 = class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("SpawnData")).resultOrPartial($$0 -> LOGGER.warn("Invalid SpawnData: {}", $$0)).orElseGet(class_1952::new);
                this.setSpawnEntry(world, pos, $$8);
            } else {
                this.spawnPotentials.method_34992(this.random).ifPresent($$2 -> this.setSpawnEntry(world, pos, (class_1952)$$2.method_34983()));
            }
        }
        if (nbt.method_10573("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.method_10568("MinSpawnDelay");
            this.maxSpawnDelay = nbt.method_10568("MaxSpawnDelay");
            this.spawnCount = nbt.method_10568("SpawnCount");
        }
        if (nbt.method_10573("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.method_10568("MaxNearbyEntities");
            this.requiredPlayerRange = nbt.method_10568("RequiredPlayerRange");
        }
        if (nbt.method_10573("SpawnRange", 99)) {
            this.spawnRange = nbt.method_10568("SpawnRange");
        }
        if (nbt.method_10545("RequiresPlayer")) {
            this.requiresPlayer = nbt.method_10577("RequiresPlayer");
        }
        if (nbt.method_10545("Active")) {
            this.active = nbt.method_10577("Active");
        }
        this.renderedEntity = null;
    }

    public class_2487 writeNbt(class_2487 $$0) {
        $$0.method_10575("Delay", (short)this.spawnDelay);
        $$0.method_10575("MinSpawnDelay", (short)this.minSpawnDelay);
        $$0.method_10575("MaxSpawnDelay", (short)this.maxSpawnDelay);
        $$0.method_10575("SpawnCount", (short)this.spawnCount);
        $$0.method_10575("MaxNearbyEntities", (short)this.maxNearbyEntities);
        $$0.method_10575("RequiredPlayerRange", (short)this.requiredPlayerRange);
        $$0.method_10575("SpawnRange", (short)this.spawnRange);
        $$0.method_10566("SpawnData", (class_2520)class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.spawnEntry).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        $$0.method_10566("SpawnPotentials", (class_2520)class_1952.field_34461.encodeStart((DynamicOps)class_2509.field_11560, this.spawnPotentials).result().orElseThrow());
        $$0.method_10556("RequiresPlayer", this.requiresPlayer);
        $$0.method_10556("Active", this.active);
        return $$0;
    }

    @Nullable
    public class_1297 getRenderedEntity(class_1937 world) {
        if (this.renderedEntity == null) {
            this.renderedEntity = class_1299.method_17842((class_2487)this.spawnEntry.method_38093(), (class_1937)world, Function.identity());
            if (this.spawnEntry.method_38093().method_10546() != 1 || !this.spawnEntry.method_38093().method_10573("id", 8) || this.renderedEntity instanceof class_1308) {
                // empty if block
            }
        }
        return this.renderedEntity;
    }

    public boolean method_8275(class_1937 $$0, int $$1) {
        if ($$1 == 1) {
            if ($$0.field_9236) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public void setSpawnEntry(@Nullable class_1937 world, class_2338 pos, class_1952 spawnEntry) {
        this.spawnEntry = spawnEntry;
    }

    public abstract void sendStatus(class_1937 var1, class_2338 var2, int var3);

    public double method_8278() {
        return this.field_9161;
    }

    public double method_8279() {
        return this.field_9159;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public void setMinSpawnDelay(int minSpawnDelay) {
        this.minSpawnDelay = minSpawnDelay;
    }

    public void setMaxSpawnDelay(int maxSpawnDelay) {
        this.maxSpawnDelay = maxSpawnDelay;
    }

    public void setSpawnCount(int spawnCount) {
        this.spawnCount = spawnCount;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    public void setEnty(class_1952 entry) {
        this.spawnPotentials = class_6005.method_38061((Object)entry);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setRequiresPlayer(boolean requiresPlayer) {
        this.requiresPlayer = requiresPlayer;
    }

    public boolean isActive() {
        return this.active;
    }
}

