/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.blocks.conjurer;

import com.glisco.conjuring.Conjuring;
import com.glisco.conjuring.blocks.conjurer.ConjurerBlockEntity;
import com.glisco.conjuring.items.ConjuringFocus;
import com.glisco.conjuring.items.ConjuringItems;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1952;

public class ConjurerHelper {
    public static void updateConjurerProperties(ConjurerBlockEntity conjurer) {
        int requiredPlayerRange = 16;
        int spawnCount = 4;
        int maxSpawnDelay = 800;
        int maxNearbyEntities = 6;
        class_1799 focus = conjurer.method_5438(0);
        class_1799 hasteCharms = conjurer.method_5438(1);
        class_1799 abundanceCharms = conjurer.method_5438(2);
        class_1799 scopeCharms = conjurer.method_5438(3);
        class_1799 ignoranceCharms = conjurer.method_5438(4);
        if (!(focus.method_7909() instanceof ConjuringFocus)) {
            conjurer.setActive(false);
            conjurer.setRequiresPlayer(true);
            return;
        }
        class_1952 entry = new class_1952(focus.method_7969().method_10562("Entity"), Optional.empty());
        conjurer.getLogic().setEnty(entry);
        conjurer.getLogic().setSpawnEntry(conjurer.method_10997(), conjurer.method_11016(), entry);
        conjurer.setActive(true);
        conjurer.setRequiresPlayer(focus.method_7909() != ConjuringItems.STABILIZED_CONJURING_FOCUS);
        if (hasteCharms.method_7909() == ConjuringItems.HASTE_CHARM) {
            maxSpawnDelay = Math.max(10, Math.round(800.0f - (float)hasteCharms.method_7947() * Conjuring.CONFIG.conjurer_config.haste_multiplier));
        }
        if (abundanceCharms.method_7909() == ConjuringItems.ABUNDANCE_CHARM) {
            spawnCount = 4 + abundanceCharms.method_7947() * Conjuring.CONFIG.conjurer_config.abundance_multiplier;
        }
        if (scopeCharms.method_7909() == ConjuringItems.SCOPE_CHARM) {
            requiredPlayerRange = 16 + scopeCharms.method_7947() * Conjuring.CONFIG.conjurer_config.scope_multiplier;
        }
        if (ignoranceCharms.method_7909() == ConjuringItems.IGNORANCE_CHARM) {
            maxNearbyEntities = 6 + ignoranceCharms.method_7947() * Conjuring.CONFIG.conjurer_config.ignorance_multiplier;
        }
        conjurer.getLogic().setRequiredPlayerRange(requiredPlayerRange);
        conjurer.getLogic().setMaxNearbyEntities(maxNearbyEntities);
        conjurer.getLogic().setMaxSpawnDelay(maxSpawnDelay);
        conjurer.getLogic().setMinSpawnDelay(maxSpawnDelay / 4);
        conjurer.getLogic().setSpawnCount(spawnCount);
        conjurer.getLogic().updateSpawns(conjurer.method_10997(), conjurer.method_11016());
    }
}

