/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.blocks;

import com.glisco.conjuring.Conjuring;
import com.glisco.conjuring.blocks.BlackstonePedestalBlockEntity;
import com.glisco.conjuring.blocks.ConjuringBlocks;
import com.glisco.conjuring.blocks.RitualCore;
import com.glisco.conjuring.blocks.SoulFunnelBlock;
import com.glisco.conjuring.items.ConjuringFocus;
import com.glisco.conjuring.items.ConjuringItems;
import com.glisco.conjuring.util.ConjuringParticleEvents;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.wispforest.owo.Owo;
import io.wispforest.owo.blockentity.LinearProcess;
import io.wispforest.owo.blockentity.LinearProcessExecutor;
import io.wispforest.owo.ops.WorldOps;
import io.wispforest.owo.particles.ClientParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulFunnelBlockEntity
extends class_2586
implements RitualCore {
    public static final class_5558<SoulFunnelBlockEntity> SERVER_TICKER = (world1, pos1, state, blockEntity) -> blockEntity.tickServer();
    public static final class_5558<SoulFunnelBlockEntity> CLIENT_TICKER = (world1, pos1, state, blockEntity) -> blockEntity.tickClient();
    public static final LinearProcess<SoulFunnelBlockEntity> PROCESS = new LinearProcess(80);
    public static final Gson GSON = class_5270.method_27862().create();
    @NotNull
    private class_1799 item = class_1799.field_8037;
    private float itemHeight = 0.0f;
    private int slownessCooldown = 0;
    private UUID ritualEntity = null;
    private float particleOffset = 0.0f;
    private float ritualStability = 0.1f;
    private final List<class_2338> pedestalPositions = new ArrayList<class_2338>();
    private final LinearProcessExecutor<SoulFunnelBlockEntity> ritualExecutor = PROCESS.createExecutor((Object)this);

    public SoulFunnelBlockEntity(class_2338 pos, class_2680 state) {
        super(ConjuringBlocks.Entities.SOUL_FUNNEL, pos, state);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        PROCESS.configureExecutor(this.ritualExecutor, world.field_9236);
    }

    public void method_5431() {
        super.method_5431();
        WorldOps.updateIfOnServer((class_1937)this.field_11863, (class_2338)this.method_11016());
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2487 item = new class_2487();
        if (!this.item.method_7960()) {
            this.item.method_7953(item);
        }
        tag.method_10566("Item", (class_2520)item);
        tag.method_10569("Cooldown", this.slownessCooldown);
        if (this.ritualExecutor.running()) {
            class_2487 ritual = new class_2487();
            ritual.method_25927("Entity", this.ritualEntity);
            ritual.method_10548("ParticleOffset", this.particleOffset);
            ritual.method_10548("Stability", this.ritualStability);
            this.ritualExecutor.writeState(ritual);
            tag.method_10566("Ritual", (class_2520)ritual);
        }
        this.savePedestals(tag, this.pedestalPositions);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2487 item = tag.method_10562("Item");
        this.item = class_1799.field_8037;
        if (!item.method_33133()) {
            this.item = class_1799.method_7915((class_2487)tag.method_10562("Item"));
        }
        this.loadPedestals(tag, this.pedestalPositions);
        this.slownessCooldown = tag.method_10550("Cooldown");
        if (tag.method_10545("Ritual")) {
            class_2487 ritual = tag.method_10562("Ritual");
            this.ritualEntity = ritual.method_25926("Entity");
            this.particleOffset = ritual.method_10583("ParticleOffset");
            this.ritualStability = ritual.method_10583("Stability");
            this.ritualExecutor.readState(ritual);
        } else {
            this.ritualEntity = null;
            this.particleOffset = 0.0f;
            this.ritualStability = 0.1f;
            this.ritualExecutor.readState(new class_2487());
        }
    }

    public void tickClient() {
        float f = this.itemHeight = this.itemHeight >= 100.0f ? 0.0f : this.itemHeight + 1.0f;
        if (this.slownessCooldown > 0) {
            --this.slownessCooldown;
        }
        this.ritualExecutor.tick();
    }

    public void tickServer() {
        if (this.slownessCooldown > 0) {
            --this.slownessCooldown;
        }
        if (this.slownessCooldown == 0 && this.getItem() != null) {
            if (this.field_11863.method_8335(null, new class_238(this.field_11867)).isEmpty()) {
                return;
            }
            class_1297 e = (class_1297)this.field_11863.method_8335(null, new class_238(this.field_11867)).get(0);
            if (e instanceof class_1657 || e instanceof class_1510 || e instanceof class_1528 || !(e instanceof class_1309) || e.method_5752().contains("affected")) {
                return;
            }
            ((class_1309)e).method_6092(new class_1293(class_1294.field_5909, 300, 20));
            this.slownessCooldown = 600;
            this.method_5431();
        }
        this.ritualExecutor.tick();
    }

    public void setItem(@NotNull class_1799 item) {
        this.item = item.method_7972();
        this.method_5431();
    }

    @NotNull
    public class_1799 getItem() {
        return this.item.method_7972();
    }

    @Override
    public boolean tryStartRitual(class_1657 player) {
        class_1542 item;
        if (this.item.method_7960()) {
            return false;
        }
        if (this.field_11863.method_8335((class_1297)player, new class_238(this.field_11867, this.field_11867.method_10069(1, 3, 1))).isEmpty()) {
            return false;
        }
        class_1297 e = (class_1297)this.field_11863.method_8335((class_1297)player, new class_238(this.field_11867, this.field_11867.method_10069(1, 3, 1))).get(0);
        if (e instanceof class_1542 && (item = (class_1542)e).method_6983().method_31574(ConjuringItems.DISTILLED_SPIRIT) && this.item != null) {
            if (this.field_11863.field_9236) {
                return true;
            }
            class_1308 newEntity = (class_1308)class_1299.method_17842((class_2487)this.item.method_7969().method_10562("Entity"), (class_1937)this.field_11863, Function.identity());
            if (newEntity == null) {
                return false;
            }
            class_1324 health = newEntity.method_5996(class_5134.field_23716);
            health.method_6192(health.method_6201() * 1.5);
            newEntity.method_6033(newEntity.method_6063());
            class_1324 attackDamage = newEntity.method_5996(class_5134.field_23721);
            if (attackDamage != null) {
                attackDamage.method_6192(attackDamage.method_6201() * 1.5);
            }
            newEntity.method_30634((double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260());
            this.field_11863.method_8649((class_1297)newEntity);
            ConjuringParticleEvents.Server.sendRitualFinished(this.field_11863, this.field_11867.method_10069(0, 1, 0), false);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14688, class_3419.field_15245, 1.0f, 0.0f);
            class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)((double)this.field_11867.method_10264() + 0.75), (double)this.field_11867.method_10260(), (class_1799)new class_1799((class_1935)this.item.method_7909()));
            this.item = class_1799.field_8037;
            item.method_31472();
            this.method_5431();
            return true;
        }
        if (!(e instanceof class_1308) || Conjuring.CONFIG.conjurer_config.conjurer_blacklist.contains(class_2378.field_11145.method_10221((Object)e.method_5864()).toString())) {
            return false;
        }
        if (this.item.method_7948().method_10545("Entity")) {
            return false;
        }
        if (!this.field_11863.method_8608()) {
            this.ritualExecutor.begin();
            this.ritualEntity = e.method_5667();
            this.method_5431();
            Conjuring.EXTRACTION_RITUAL_CRITERION.trigger((class_3222)player);
        }
        return true;
    }

    public boolean isRitualRunning() {
        return this.ritualExecutor.running();
    }

    public float getItemHeight() {
        return (float)Math.sin(Math.PI * 2 * (double)this.itemHeight / 100.0) / 25.0f;
    }

    public boolean onCooldown() {
        return this.slownessCooldown > 0;
    }

    private void disablePedestals() {
        for (class_2338 pos : this.pedestalPositions) {
            class_2586 blockEntity = this.field_11863.method_8321(pos);
            if (!(blockEntity instanceof BlackstonePedestalBlockEntity)) continue;
            ((BlackstonePedestalBlockEntity)blockEntity).setActive(false);
            ((BlackstonePedestalBlockEntity)blockEntity).setItem(class_1799.field_8037);
        }
    }

    @Override
    public boolean linkPedestal(class_2338 pedestal) {
        if (this.pedestalPositions.size() >= 4) {
            return false;
        }
        if (!this.pedestalPositions.contains(pedestal)) {
            this.pedestalPositions.add(pedestal);
        }
        if (!this.field_11863.field_9236) {
            ConjuringParticleEvents.Server.sendFunnelLinked(this.field_11863, this.field_11867, pedestal.method_10059((class_2382)this.field_11867));
        }
        this.method_5431();
        return true;
    }

    @Override
    public boolean removePedestal(class_2338 pedestal, boolean pedestalActive) {
        boolean returnValue = this.pedestalPositions.remove(pedestal);
        this.method_5431();
        class_2338 offset = new class_2338(class_243.method_24954((class_2382)pedestal.method_10059((class_2382)this.field_11867)).method_1029());
        ConjuringParticleEvents.Server.sendPedestalRemoved(this.field_11863, this.field_11867, class_2350.method_35832((class_2338)offset));
        if (pedestalActive) {
            this.ritualExecutor.cancel();
            this.method_5431();
        }
        return returnValue;
    }

    @Override
    public List<class_2338> getPedestalPositions() {
        return this.pedestalPositions;
    }

    public void calculateStability() {
        if (this.field_11863.method_8503().method_30611().method_30530(class_2378.field_25114).method_29113((Object)this.field_11863.method_23753(this.field_11867)).orElse(null) == class_1972.field_22076) {
            this.ritualStability += 0.1f;
        }
        List<class_1792> drops = SoulFunnelBlockEntity.extractDrops(this.field_11863.method_8503().method_3857().method_367(((class_1308)((class_3218)this.field_11863).method_14190(this.ritualEntity)).method_5989()));
        for (class_2338 pedestalPos : this.pedestalPositions) {
            BlackstonePedestalBlockEntity pedestal;
            class_2586 class_25862 = this.field_11863.method_8321(pedestalPos);
            if (!(class_25862 instanceof BlackstonePedestalBlockEntity) || (pedestal = (BlackstonePedestalBlockEntity)class_25862).getItem().method_7960() || !drops.contains(pedestal.getItem().method_7909())) continue;
            this.ritualStability += 0.2f;
            pedestal.setActive(true);
        }
        this.method_5431();
    }

    public void onBroken() {
        if (!this.item.method_7960()) {
            class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)((double)this.field_11867.method_10264() + 1.25), (double)this.field_11867.method_10260(), (class_1799)this.item);
        }
        for (class_2338 pos : this.pedestalPositions) {
            if (!(this.field_11863.method_8321(pos) instanceof BlackstonePedestalBlockEntity)) continue;
            ((BlackstonePedestalBlockEntity)this.field_11863.method_8321(pos)).setLinkedFunnel(null);
        }
        this.ritualExecutor.cancel();
    }

    private static List<class_1792> extractDrops(class_52 table) {
        JsonObject tableObject = GSON.toJsonTree((Object)table).getAsJsonObject();
        ArrayList<class_1792> extractedDrops = new ArrayList<class_1792>();
        try {
            for (JsonElement poolElement : tableObject.get("pools").getAsJsonArray()) {
                JsonArray entries = poolElement.getAsJsonObject().get("entries").getAsJsonArray();
                for (JsonElement entryElement : entries) {
                    JsonObject entryObject = entryElement.getAsJsonObject();
                    if (!"minecraft:item".equals(class_3518.method_15265((JsonObject)entryObject, (String)"type"))) continue;
                    extractedDrops.add((class_1792)class_2378.field_11142.method_10223(new class_2960(class_3518.method_15265((JsonObject)entryObject, (String)"name"))));
                }
            }
            return extractedDrops;
        }
        catch (Exception e) {
            if (!Owo.DEBUG) {
                return new ArrayList<class_1792>();
            }
            throw new RuntimeException("Unable to parse loot table", e);
        }
    }

    private boolean verifyTargetedEntity() {
        if (this.field_11863.field_9236) {
            return true;
        }
        class_1308 targetEntity = (class_1308)((class_3218)this.field_11863).method_14190(this.ritualEntity);
        return targetEntity != null && !targetEntity.method_29504();
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    static {
        PROCESS.runConditionally(executor -> ((SoulFunnelBlockEntity)executor.getTarget()).verifyTargetedEntity());
        PROCESS.addClientEvent(1, (executor, funnel) -> funnel.field_11863.method_8486((double)funnel.method_11016().method_10263(), (double)funnel.method_11016().method_10264(), (double)funnel.method_11016().method_10260(), class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f, false));
        PROCESS.addClientStep(20, 60, (executor, funnel) -> {
            class_1937 world = funnel.method_10997();
            for (class_2338 pos : funnel.pedestalPositions) {
                BlackstonePedestalBlockEntity pedestal;
                class_2586 patt14074$temp = world.method_8321(pos);
                if (!(patt14074$temp instanceof BlackstonePedestalBlockEntity) || !(pedestal = (BlackstonePedestalBlockEntity)patt14074$temp).isActive()) continue;
                class_2338 particleOrigin = pos.method_10069(0, 1, 0);
                class_2338 particleVelocity = pos.method_10059((class_2382)funnel.field_11867);
                class_2388 particle = new class_2388(class_2398.field_11217, world.method_8320(pos));
                ClientParticles.setParticleCount((int)4);
                ClientParticles.spawnWithOffsetFromBlock((class_2394)particle, (class_1937)world, (class_2338)particleOrigin, (class_243)new class_243(0.5, 0.25, 0.5), (double)0.1);
                ClientParticles.setVelocity((class_243)new class_243((double)particleVelocity.method_10263() * -0.05, (double)funnel.particleOffset * 0.075, (double)particleVelocity.method_10260() * -0.05));
                ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_23114, (class_1937)world, (class_2338)particleOrigin, (class_243)new class_243(0.5, 0.3, 0.5), (double)0.1);
            }
            ClientParticles.setParticleCount((int)5);
            ClientParticles.setVelocity((class_243)new class_243(0.0, -0.5, 0.0));
            ClientParticles.spawnWithOffsetFromBlock((class_2394)class_2398.field_22246, (class_1937)world, (class_2338)funnel.field_11867, (class_243)new class_243(0.5, 1.75 + (double)funnel.particleOffset, 0.5), (double)0.1);
        });
        PROCESS.addServerEvent(1, (executor, funnel) -> {
            class_1308 targetEntity = (class_1308)((class_3218)funnel.field_11863).method_14190(funnel.ritualEntity);
            funnel.particleOffset = targetEntity.method_17682() / 2.0f;
            funnel.method_5431();
            targetEntity.method_20620((double)((float)funnel.field_11867.method_10263() + 0.5f), targetEntity.method_23318(), (double)((float)funnel.field_11867.method_10260() + 0.5f));
            targetEntity.method_18800(0.0, (double)0.075f, 0.0);
            targetEntity.method_5875(true);
            funnel.calculateStability();
        });
        PROCESS.addServerEvent(20, (executor, funnel) -> {
            class_1308 targetEntity = (class_1308)((class_3218)funnel.field_11863).method_14190(funnel.ritualEntity);
            targetEntity.method_18800(0.0, 0.0, 0.0);
            targetEntity.method_5977(true);
            class_243 entityTargetPos = class_243.method_24954((class_2382)funnel.field_11867).method_1031(0.5, 1.85, 0.5);
            targetEntity.method_23327(entityTargetPos.field_1352, entityTargetPos.field_1351, entityTargetPos.field_1350);
        });
        PROCESS.addServerStep(20, 60, (executor, funnel) -> {
            if (executor.getProcessTick() % 10 != 0) {
                return;
            }
            ((class_3218)funnel.field_11863).method_14190(funnel.ritualEntity).method_5643(class_1282.field_5849, 0.01f);
        });
        PROCESS.whenFinishedServer((executor, funnel) -> {
            class_1937 world = funnel.field_11863;
            class_2338 pos = funnel.field_11867;
            class_1308 targetEntity = (class_1308)((class_3218)world).method_14190(funnel.ritualEntity);
            boolean success = targetEntity.field_6002.field_9229.nextDouble() < (double)funnel.ritualStability;
            ConjuringParticleEvents.Server.sendRitualFinished(world, pos.method_10069(0, 2, 0), success);
            world.method_8396(null, pos, success ? class_3417.field_14931 : class_3417.field_14688, class_3419.field_15245, 1.0f, 0.0f);
            world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)SoulFunnelBlock.FILLED, (Comparable)Boolean.valueOf(false)));
            class_1799 drop = success ? ConjuringFocus.writeData(funnel.item, targetEntity.method_5864()) : funnel.item;
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)((double)pos.method_10264() + 1.25), (double)pos.method_10260(), (class_1799)drop);
            funnel.disablePedestals();
            targetEntity.method_5768();
            funnel.item = class_1799.field_8037;
            funnel.ritualEntity = null;
            funnel.ritualStability = 0.1f;
            funnel.method_5431();
        });
        PROCESS.onCancelledServer((executor, funnel) -> {
            class_1937 world = funnel.field_11863;
            class_2338 funnelPos = funnel.field_11867;
            ConjuringParticleEvents.Server.sendRitualFinished(world, funnelPos.method_10069(0, 2, 0), false);
            world.method_8396(null, funnelPos, class_3417.field_14688, class_3419.field_15245, 1.0f, 0.0f);
            funnel.disablePedestals();
            class_1308 targetEntity = (class_1308)((class_3218)world).method_14190(funnel.ritualEntity);
            if (targetEntity != null) {
                targetEntity.method_5768();
            }
            funnel.ritualEntity = null;
            funnel.method_5431();
        });
        PROCESS.finish();
    }
}

