/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5414;

public class ChiselGroupLookup {
    private static final Map<String, ChiselGroup> CHISEL_GROUPS = new HashMap<String, ChiselGroup>();

    private ChiselGroupLookup() {
    }

    public static Iterator<String> getGroupNameIterator() {
        return CHISEL_GROUPS.keySet().iterator();
    }

    public static void addGroup(String name) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            CHISEL_GROUPS.put(name, new ChiselGroup());
        }
    }

    public static void addItemToGroup(String name, class_2960 id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        CHISEL_GROUPS.get(name).addItem(id);
    }

    public static void addItemToGroup(String name, List<class_2960> id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        for (int i = 0; i < id.size(); ++i) {
            CHISEL_GROUPS.get(name).addItem(id.get(i));
        }
    }

    public static void addTagToGroup(String name, class_2960 id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        CHISEL_GROUPS.get(name).addTag(id);
    }

    public static void addTagToGroup(String name, List<class_2960> id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        for (int i = 0; i < id.size(); ++i) {
            CHISEL_GROUPS.get(name).addTag(id.get(i));
        }
    }

    public static ChiselGroup getGroup(class_1792 item, class_5414<class_1792> itemTags) {
        Iterator<ChiselGroup> chiselGroupIterator = CHISEL_GROUPS.values().iterator();
        class_2960 itemId = class_2378.field_11142.method_10221((Object)item);
        while (chiselGroupIterator.hasNext()) {
            ChiselGroup group = chiselGroupIterator.next();
            if (!group.containsItem(itemId, itemTags)) continue;
            return group;
        }
        return null;
    }

    public static List<class_1792> getBlocksInGroup(String name, class_5414<class_1792> itemTags) {
        ChiselGroup group = CHISEL_GROUPS.get(name);
        if (group != null) {
            return ChiselGroupLookup.getBlocksInGroup(group, itemTags);
        }
        return new ArrayList<class_1792>();
    }

    public static List<class_1792> getBlocksInGroup(class_1792 item, class_5414<class_1792> itemTags) {
        ChiselGroup group = ChiselGroupLookup.getGroup(item, itemTags);
        if (group != null) {
            return ChiselGroupLookup.getBlocksInGroup(group, itemTags);
        }
        return new ArrayList<class_1792>();
    }

    public static List<class_1792> getBlocksInGroup(ChiselGroup group, class_5414<class_1792> itemTags) {
        ArrayList<class_1792> groupItems = new ArrayList<class_1792>();
        groupItems.addAll(group.getItems(itemTags));
        return groupItems;
    }

    public static List<class_2960> getTagsFor(class_1792 item, class_5414<class_1792> tagGroup) {
        ArrayList<class_2960> tags = new ArrayList<class_2960>();
        for (Map.Entry entry : tagGroup.method_30204().entrySet()) {
            if (!((class_3494)entry.getValue()).method_15141((Object)item)) continue;
            tags.add((class_2960)entry.getKey());
        }
        return tags;
    }

    public static class ChiselGroup {
        private final List<class_2960> items = new ArrayList<class_2960>();
        private final List<class_2960> tags = new ArrayList<class_2960>();

        public void addItem(class_2960 item) {
            this.items.add(item);
        }

        public void addTag(class_2960 tag) {
            this.tags.add(tag);
        }

        public boolean containsItem(class_2960 item, class_5414<class_1792> itemTags) {
            return this.inItems(item) || this.inTags(item, itemTags);
        }

        public boolean inItems(class_2960 item) {
            return this.items.contains(item);
        }

        public boolean inTags(class_2960 id, class_5414<class_1792> itemTags) {
            class_1792 item = (class_1792)class_2378.field_11142.method_10223(id);
            Iterator<class_2960> tagsForItem = ChiselGroupLookup.getTagsFor(item, itemTags).iterator();
            while (tagsForItem.hasNext()) {
                if (!this.tags.contains(tagsForItem.next())) continue;
                return true;
            }
            return false;
        }

        public List<class_1792> getItems(class_5414<class_1792> itemTags) {
            int i;
            ArrayList<class_1792> itemsInGroup = new ArrayList<class_1792>();
            for (i = 0; i < this.items.size(); ++i) {
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(this.items.get(i));
                if (item.equals(class_1802.field_8162)) continue;
                itemsInGroup.add(item);
            }
            for (i = 0; i < this.tags.size(); ++i) {
                class_3494 itemTag = itemTags.method_30210(this.tags.get(i));
                if (itemTag == null) continue;
                List tagItems = itemTag.method_15138();
                itemsInGroup.addAll(tagItems);
            }
            ArrayList<class_1792> itemsInGroupNoDupes = new ArrayList<class_1792>();
            for (int i2 = 0; i2 < itemsInGroup.size(); ++i2) {
                class_1792 item = (class_1792)itemsInGroup.get(i2);
                if (itemsInGroupNoDupes.contains(item)) continue;
                itemsInGroupNoDupes.add(item);
            }
            return itemsInGroupNoDupes;
        }
    }
}

