/*
 * Decompiled with CFR 0.152.
 */
package easton.opitems;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Scanner;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class OpItems
implements ClientModInitializer {
    public static final class_1761 OP_GROUP = FabricItemGroupBuilder.create((class_2960)new class_2960("opitems", "optab")).icon(() -> new class_1799((class_1935)class_2246.field_10525)).appendItems(stacks -> {
        try {
            Scanner config = OpItems.getOrCreateConfig();
            config.nextLine();
            config.nextLine();
            while (config.hasNextLine()) {
                stacks.add(class_1799.method_7915((class_2487)class_2522.method_10718((String)config.nextLine())));
            }
        }
        catch (CommandSyntaxException | IOException e) {
            System.out.println("Op Items Tab failed to read from config");
            e.printStackTrace();
        }
    }).build();

    public void onInitializeClient() {
    }

    private static Scanner getOrCreateConfig() throws IOException {
        Path configPath = FabricLoader.getInstance().getConfigDir();
        File configFile = new File(configPath.toString(), "opitems_config.txt");
        if (!configFile.exists()) {
            configFile.createNewFile();
            OpItems.writeDefaultConfig(new PrintStream(configFile));
        }
        return new Scanner(configFile);
    }

    private static void writeDefaultConfig(PrintStream stream) {
        stream.println("Default items are below, add your own via NBT, here's an example:");
        stream.println("{id:\"minecraft:elytra\", Count:1, tag:{ Enchantments:[{id:\"minecraft:unbreaking\",lvl:10}], display: {Name:'{\"text\":\"General Kenobi\"}'} }}");
        stream.println("{id:\"minecraft:command_block\", Count:1}");
        stream.println("{id:\"minecraft:chain_command_block\", Count:1}");
        stream.println("{id:\"minecraft:repeating_command_block\", Count:1}");
        stream.println("{id:\"minecraft:spawner\", Count:1}");
        stream.println("{id:\"minecraft:jigsaw\", Count:1}");
        stream.println("{id:\"minecraft:structure_block\", Count:1}");
        stream.println("{id:\"minecraft:structure_void\", Count:1}");
        stream.println("{id:\"minecraft:barrier\", Count:1}");
        stream.println("{id:\"minecraft:dragon_egg\", Count:1}");
        stream.println("{id:\"minecraft:debug_stick\", Count:1}");
        stream.println("{id:\"minecraft:knowledge_book\", Count:1}");
        stream.println("{id:\"minecraft:command_block_minecart\", Count:1}");
        stream.println("{id:\"minecraft:light\", Count:1}");
        stream.println("{id:\"minecraft:bundle\", Count:1}");
        stream.println("{id:\"minecraft:sculk_sensor\", Count:1}");
    }
}

