/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.slightguimodifications.config;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.slightguimodifications.SlightGuiModifications;
import me.shedaniel.slightguimodifications.gui.cts.elements.WidgetElement;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

@Config(name="slightguimodifications")
public class SlightGuiModificationsConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="config")
    @ConfigEntry.Gui.TransitiveObject
    public Gui gui = new Gui();

    @Config(name="config")
    public static class Gui
    implements ConfigData {
        public boolean fluidAdvancements = false;
        public boolean fluidStatusEffects = false;
        @Comment(value="Whether we should unlimit the hard 60 fps limit placed on the title screen.")
        @ConfigEntry.Gui.Tooltip
        public boolean unlimitTitleScreenFps = false;
        @ConfigEntry.Gui.CollapsibleObject
        public OpeningAnimation openingAnimation = new OpeningAnimation();
        @ConfigEntry.Gui.CollapsibleObject
        public TextFieldModifications textFieldModifications = new TextFieldModifications();
        @ConfigEntry.Gui.CollapsibleObject
        public SliderModifications sliderModifications = new SliderModifications();
        @ConfigEntry.Gui.CollapsibleObject
        public DebugInformation debugInformation = new DebugInformation();
        @ConfigEntry.Gui.CollapsibleObject
        public CustomScaling customScaling = new CustomScaling();
        @ConfigEntry.Gui.CollapsibleObject
        public SlotHighlight slotHighlight = new SlotHighlight();
        @ConfigEntry.Gui.CollapsibleObject
        public TooltipModifications tooltipModifications = new TooltipModifications();
        @Comment(value="Whether GUI should allow right click actions.")
        @ConfigEntry.Gui.Tooltip
        public boolean rightClickActions = false;
        public boolean satisfyingScreenshots = false;

        public static class OpeningAnimation {
            public boolean fluidChatOpening = false;
            public boolean fluidOpenSlideFromBottom = false;
            public boolean fluidOpenFade = false;
            @ConfigEntry.BoundedDiscrete(min=10L, max=5000L)
            public int fluidAnimationDuration = 400;
            public boolean affectsGameMenus = true;
            public boolean affectsInventories = true;
            public boolean ignoreSlideWhenRedirected = true;
            public boolean ignoreFadeWhenRedirected = false;
        }

        public static class TextFieldModifications {
            @Comment(value="Whether this module is enabled.")
            public boolean enabled = false;
            @Comment(value="Set to Color to use the Border and Background Color.\nSet to Texture to use resource pack:\n/assets/minecraft/textures/gui/text_field.png\n\nMore documentations on website.")
            @ConfigEntry.Gui.Tooltip(count=6)
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public BackgroundMode backgroundMode = BackgroundMode.COLOR;
            @ConfigEntry.ColorPicker
            public int borderColor = 0xA0A0A0;
            @ConfigEntry.ColorPicker
            public int backgroundColor = 0;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public SelectionMode selectionMode = SelectionMode.INVERT;
            @Comment(value="Whether Text Fields should allow right click actions.")
            @ConfigEntry.Gui.Tooltip
            public boolean rightClickActions = false;

            public static enum BackgroundMode implements SelectionListEntry.Translatable
            {
                COLOR,
                TEXTURE;


                @NotNull
                public String getKey() {
                    return "text.autoconfig.slightguimodifications.option.gui.textFieldModifications.backgroundMode." + this.name().toLowerCase(Locale.ROOT);
                }
            }

            public static enum SelectionMode implements SelectionListEntry.Translatable
            {
                INVERT,
                HIGHLIGHT;


                @NotNull
                public String getKey() {
                    return "text.autoconfig.slightguimodifications.option.gui.textFieldModifications.selectionMode." + this.name().toLowerCase(Locale.ROOT);
                }
            }
        }

        public static class SliderModifications {
            @Comment(value="Whether this module is enabled.")
            public boolean enabled = false;
            public int grabberWidth = 8;
            @Comment(value="Whether to use custom texture:\n/assets/slightguimodifications/textures/gui/slider(_hovered).png\nor\n/config/slightguimodifications/slider(_hovered).png")
            @ConfigEntry.Gui.Tooltip(count=4)
            public boolean customBackgroundTexture = false;
        }

        public static class DebugInformation {
            public boolean showFps = false;
        }

        public static class CustomScaling {
            public boolean vanillaScaleSlider = false;
            @ScaleSlider
            public double scale = 1.0;
        }

        public static class SlotHighlight {
            @Comment(value="Whether this module is enabled.")
            public boolean enabled = false;
            @ConfigEntry.ColorPicker(allowAlpha=true)
            public int color = -2130706433;
        }

        public static class TooltipModifications {
            @Comment(value="Whether this module is enabled.")
            public boolean enabled = false;
            @ConfigEntry.ColorPicker(allowAlpha=true)
            public int backgroundColor = -267386864;
            @ConfigEntry.ColorPicker(allowAlpha=true)
            public int outlineGradientTopColor = 0x505000FF;
            @ConfigEntry.ColorPicker(allowAlpha=true)
            public int outlineGradientBottomColor = 1344798847;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        public static @interface ScaleSlider {
        }
    }

    public static class Cts {
        @Comment(value="Whether this category is enabled.")
        public boolean enabled = false;
        @ConfigEntry.Gui.CollapsibleObject
        public SplashText splashText = new SplashText();
        public boolean removeMinecraftEditionTexture = false;
        public boolean removeMinecraftLogoTexture = false;
        public boolean clearAllButtons = false;
        public boolean clearAllLabels = false;
        public List<WidgetElement> widgetElements = new ArrayList<WidgetElement>();
        public List<BackgroundInfo> backgroundInfos = new ArrayList<DefaultBackgroundInfo>(Collections.singletonList(new DefaultBackgroundInfo()));
        public long backgroundStayLength = 10000L;
        public long backgroundFadeLength = 1000L;
        public boolean renderGradientShade = true;

        public static class SplashText {
            @Comment(value="Whether this module is enabled.")
            public boolean enabled = false;
            public boolean removeSplashes = false;
            public boolean customSplashesEnabled = false;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public CustomSplashesApplyMode customSplashesApplyMode = CustomSplashesApplyMode.OVERRIDE;
            public List<String> customSplashes = Lists.newArrayList();

            public static enum CustomSplashesApplyMode implements SelectionListEntry.Translatable
            {
                APPEND,
                OVERRIDE;


                @NotNull
                public String getKey() {
                    return "text.autoconfig.slightguimodifications.option.cts.splashText.customSplashesApplyMode." + this.name().toLowerCase(Locale.ROOT);
                }
            }
        }

        public static class DefaultBackgroundInfo
        extends BackgroundInfo {
            @Override
            public void render(class_4587 matrices, class_442 screen, float delta, float alpha) {
                RenderSystem.setShaderTexture((int)0, (class_2960)class_442.field_17775);
                screen.field_2585.method_3317(delta, class_3532.method_15363((float)(alpha * this.getAlpha()), (float)0.0f, (float)1.0f));
            }
        }

        public static interface TextureProvider {
            public class_2960 provide();
        }

        public static class TextureProvidedBackgroundInfo
        extends BackgroundInfo {
            private final Supplier<class_2960> provider = Suppliers.memoize(provider::provide);

            public TextureProvidedBackgroundInfo(TextureProvider provider) {
            }

            @Override
            public void render(class_4587 matrices, class_442 screen, float delta, float alpha) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.provider.get());
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
                class_332.method_25293((class_4587)matrices, (int)0, (int)0, (int)screen.field_22789, (int)screen.field_22790, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            }
        }

        public static abstract class BackgroundInfo {
            public final int index() {
                return SlightGuiModifications.getCtsConfig().backgroundInfos.indexOf(this);
            }

            public final float getAlpha() {
                Cts ctsConfig = SlightGuiModifications.getCtsConfig();
                if (ctsConfig.backgroundInfos.size() == 1) {
                    return 1.0f;
                }
                int index = this.index();
                long fullIterationLength = ctsConfig.backgroundStayLength * (long)ctsConfig.backgroundInfos.size();
                long timePast = (class_156.method_658() - SlightGuiModifications.backgroundTime) % fullIterationLength;
                if (timePast >= (long)index * ctsConfig.backgroundStayLength && timePast < (long)(index + 1) * ctsConfig.backgroundStayLength) {
                    return 1.0f;
                }
                if (timePast >= (long)(index + 1) * ctsConfig.backgroundStayLength && timePast < (long)(index + 1) * ctsConfig.backgroundStayLength + ctsConfig.backgroundFadeLength) {
                    return class_3532.method_15363((float)((float)((long)(index + 1) * ctsConfig.backgroundStayLength + ctsConfig.backgroundFadeLength - timePast) / (float)ctsConfig.backgroundFadeLength), (float)0.0f, (float)1.0f);
                }
                if (index == ctsConfig.backgroundInfos.size() - 1 && timePast <= ctsConfig.backgroundFadeLength) {
                    return class_3532.method_15363((float)((float)(ctsConfig.backgroundFadeLength - timePast) / (float)ctsConfig.backgroundFadeLength), (float)0.0f, (float)1.0f);
                }
                return 0.0f;
            }

            public abstract void render(class_4587 var1, class_442 var2, float var3, float var4);
        }
    }
}

