/*
 * Decompiled with CFR 0.152.
 */
package techreborn.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_437;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;

public class ToolTipAssistUtils {
    private static final class_124 instructColour = class_124.field_1078;
    private static final class_124 infoColour = class_124.field_1065;
    private static final class_124 statColour = class_124.field_1065;
    private static final class_124 posColour = class_124.field_1060;
    private static final class_124 negColour = class_124.field_1061;

    public static List<class_2561> getUpgradeStats(TRContent.Upgrades upgradeType, int count, boolean shiftHeld) {
        ArrayList<class_2561> tips = new ArrayList<class_2561>();
        boolean shouldStackCalculate = count > 1;
        switch (upgradeType) {
            case OVERCLOCKER: {
                tips.add(ToolTipAssistUtils.getPositive(class_1074.method_4662((String)"techreborn.tooltip.upgrade.speed_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateValue(TechRebornConfig.overclockerSpeed * 100.0, count, shiftHeld), "%"));
                tips.add(ToolTipAssistUtils.getNegative(class_1074.method_4662((String)"techreborn.tooltip.upgrade.energy_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateValue(TechRebornConfig.overclockerPower * 100.0, count, shiftHeld), "%"));
                break;
            }
            case TRANSFORMER: {
                shouldStackCalculate = false;
                break;
            }
            case ENERGY_STORAGE: {
                tips.add(ToolTipAssistUtils.getPositive(class_1074.method_4662((String)"techreborn.tooltip.upgrade.storage_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateValue(TechRebornConfig.energyStoragePower, count, shiftHeld), " E"));
                break;
            }
            case SUPERCONDUCTOR: {
                tips.add(ToolTipAssistUtils.getPositive(class_1074.method_4662((String)"techreborn.tooltip.upgrade.flow_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateValue(Math.pow(2.0, TechRebornConfig.superConductorCount + 2.0) * 100.0, count, shiftHeld), "%"));
            }
        }
        if (shouldStackCalculate && !shiftHeld) {
            tips.add((class_2561)new class_2585(instructColour + class_1074.method_4662((String)"techreborn.tooltip.stack_info", (Object[])new Object[0])));
        }
        return tips;
    }

    public static void addInfo(String inKey, List<class_2561> list) {
        ToolTipAssistUtils.addInfo(inKey, list, true);
    }

    public static void addInfo(String inKey, List<class_2561> list, boolean hidden) {
        String key = "techreborn.message.info." + inKey;
        if (class_1074.method_4663((String)key)) {
            if (!hidden || class_437.method_25442()) {
                String[] infoLines;
                String info = class_1074.method_4662((String)key, (Object[])new Object[0]);
                for (String infoLine : infoLines = info.split("\\r?\\n")) {
                    list.add(1, (class_2561)new class_2585(infoColour + infoLine));
                }
            } else {
                list.add((class_2561)new class_2585(instructColour + class_1074.method_4662((String)"techreborn.tooltip.more_info", (Object[])new Object[0])));
            }
        }
    }

    private static int calculateValue(double value, int count, boolean shiftHeld) {
        int calculatedVal = shiftHeld ? (int)value * count : (int)value;
        return calculatedVal;
    }

    private static class_2561 getPositive(String text, int value, String unit) {
        return new class_2585(posColour + ToolTipAssistUtils.getStatStringUnit(text, value, unit));
    }

    private static class_2561 getNegative(String text, int value, String unit) {
        return new class_2585(negColour + ToolTipAssistUtils.getStatStringUnit(text, value, unit));
    }

    private static String getStatStringUnit(String text, int value, String unit) {
        return text + ": " + statColour + value + unit;
    }
}

