/*
 * Decompiled with CFR 0.152.
 */
package techreborn.events;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import reborncore.common.BaseBlockEntityProvider;
import techreborn.events.OreDepthSyncHandler;
import techreborn.init.TRContent;
import techreborn.items.DynamicCellItem;
import techreborn.items.UpgradeItem;
import techreborn.utils.ToolTipAssistUtils;
import techreborn.world.OreDepth;
import techreborn.world.TargetDimension;

public class StackToolTipHandler
implements ItemTooltipCallback {
    public static final Map<class_1792, Boolean> ITEM_ID = Maps.newHashMap();
    private static final List<class_2248> UNOBTAINABLE_ORES = Lists.newLinkedList();

    public static void setup() {
        ItemTooltipCallback.EVENT.register((Object)new StackToolTipHandler());
        for (TRContent.Ores ore : TRContent.Ores.values()) {
            if (!ore.isDeepslate()) continue;
            TRContent.Ores normal = ore.getUnDeepslate();
            if (normal.distribution == null || normal.distribution.dimension == TargetDimension.OVERWORLD) continue;
            UNOBTAINABLE_ORES.add(ore.block);
        }
    }

    public void getTooltip(class_1799 stack, class_1836 tooltipContext, List<class_2561> tooltipLines) {
        DynamicCellItem cell;
        class_3611 fluid;
        class_1792 item = stack.method_7909();
        if (!class_310.method_1551().method_18854()) {
            return;
        }
        if (!ITEM_ID.computeIfAbsent(item, StackToolTipHandler::isTRItem).booleanValue()) {
            return;
        }
        class_2248 block = class_2248.method_9503((class_1792)item);
        if (block instanceof BaseBlockEntityProvider) {
            ToolTipAssistUtils.addInfo(item.method_7876(), tooltipLines);
        }
        if (item instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)item;
            ToolTipAssistUtils.addInfo(item.method_7876(), tooltipLines, false);
            tooltipLines.addAll(ToolTipAssistUtils.getUpgradeStats(TRContent.Upgrades.valueOf(upgrade.name.toUpperCase()), stack.method_7947(), class_437.method_25442()));
        }
        if (item instanceof DynamicCellItem && !((fluid = (cell = (DynamicCellItem)item).getFluid(stack)) instanceof class_3609) && fluid != class_3612.field_15906) {
            ToolTipAssistUtils.addInfo("unplaceable_fluid", tooltipLines, false);
        }
        if (UNOBTAINABLE_ORES.contains(block)) {
            tooltipLines.add((class_2561)new class_2588("techreborn.tooltip.unobtainable").method_27692(class_124.field_1075));
        } else if (OreDepthSyncHandler.getOreDepthMap().containsKey(block)) {
            OreDepth oreDepth = OreDepthSyncHandler.getOreDepthMap().get(block);
            class_2588 text = StackToolTipHandler.getOreDepthText(oreDepth);
            tooltipLines.add((class_2561)text.method_27662().method_27692(class_124.field_1075));
        }
    }

    private static boolean isTRItem(class_1792 item) {
        return class_2378.field_11142.method_10221((Object)item).method_12836().equals("techreborn");
    }

    private static class_2588 getOreDepthText(OreDepth depth) {
        return new class_2588("techreborn.tooltip.ores.%s".formatted(depth.dimension().name().toLowerCase(Locale.ROOT)), new Object[]{new class_2585(String.valueOf(depth.minY())).method_27692(class_124.field_1054), new class_2585(String.valueOf(depth.maxY())).method_27692(class_124.field_1054)});
    }
}

