/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.generator;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class LightningRodBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop {
    private int onStatusHoldTicks = -1;

    public LightningRodBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.LIGHTNING_ROD, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        float lightStrikeChance;
        float totalChance;
        float weatherStrength;
        class_2248 BEBlock;
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (this.onStatusHoldTicks > 0) {
            --this.onStatusHoldTicks;
        }
        if (!((BEBlock = this.method_11010().method_26204()) instanceof BlockMachineBase)) {
            return;
        }
        BlockMachineBase machineBaseBlock = (BlockMachineBase)BEBlock;
        if (this.onStatusHoldTicks == 0 || this.getEnergy() <= 0L) {
            machineBaseBlock.setActive(Boolean.valueOf(false), world, pos);
            this.onStatusHoldTicks = -1;
        }
        if ((weatherStrength = world.method_8478(1.0f)) > 0.2f && world.field_9229.nextInt((int)Math.floor(totalChance = (lightStrikeChance = (100.0f - (float)TechRebornConfig.lightningRodChanceOfStrike) * 20.0f) * this.getLightningStrikeMultiplier() * (1.1f - weatherStrength))) == 0) {
            if (!this.isValidIronFence(pos.method_10084().method_10264())) {
                this.onStatusHoldTicks = 400;
                return;
            }
            class_1538 lightningBolt = (class_1538)class_1299.field_6112.method_5883(world);
            lightningBolt.method_29495(class_243.method_24955((class_2382)world.method_8598(class_2902.class_2903.field_13197, this.method_11016())));
            world.method_8649((class_1297)lightningBolt);
            this.addEnergy((long)((float)TechRebornConfig.lightningRodBaseEnergyStrike * (0.3f + weatherStrength)));
            machineBaseBlock.setActive(Boolean.valueOf(true), world, pos);
            this.onStatusHoldTicks = 400;
        }
    }

    public float getLightningStrikeMultiplier() {
        float actualHeight = 256.0f;
        float groundLevel = this.field_11863.method_8598(class_2902.class_2903.field_13197, this.method_11016()).method_10264();
        int i = this.field_11867.method_10264() + 1;
        while ((float)i < 256.0f) {
            if (!this.isValidIronFence(i)) {
                if (groundLevel >= (float)i) {
                    return 4.3f;
                }
                float max = 256.0f - groundLevel;
                float got = (float)i - groundLevel;
                return 1.2f - got / max;
            }
            ++i;
        }
        return 4.0f;
    }

    public boolean isValidIronFence(int y) {
        if (this.field_11863 == null) {
            return false;
        }
        class_2248 block = this.field_11863.method_8320(new class_2338(this.field_11867.method_10263(), y, this.field_11867.method_10260())).method_26204();
        return block == TRContent.REFINED_IRON_FENCE;
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.lightningRodMaxEnergy;
    }

    public boolean canAcceptEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return TechRebornConfig.lightningRodMaxOutput;
    }

    public long getBaseMaxInput() {
        return 0L;
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return TRContent.Machine.LIGHTNING_ROD.getStack();
    }
}

