/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.block.BlockModificationEventJS;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.item.ItemModificationEventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.text.TextString;
import dev.latvian.mods.kubejs.text.TextTranslate;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_40;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6334;
import net.minecraft.class_6728;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class UtilsJS {
    public static final Random RANDOM = new Random();
    public static final Pattern REGEX_PATTERN = Pattern.compile("\\/(.*)\\/([a-z]*)");
    public static final class_2960 AIR_LOCATION = new class_2960("minecraft:air");
    public static final Pattern SNAKE_CASE_SPLIT = Pattern.compile("[_/]");
    public static final Set<String> ALWAYS_LOWER_CASE = new HashSet<String>(Arrays.asList("a", "an", "the", "of", "on", "in"));
    private static Collection<class_2680> ALL_STATE_CACHE = null;

    public static void init() {
    }

    public static void tryIO(TryIO tryIO) {
        try {
            tryIO.run();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    @Nullable
    public static Pattern parseRegex(Object o) {
        if (o instanceof CharSequence || o instanceof NativeRegExp) {
            return UtilsJS.regex(o.toString());
        }
        if (o instanceof Pattern) {
            Pattern pattern = (Pattern)o;
            return pattern;
        }
        return null;
    }

    @Nullable
    public static Pattern regex(String string) {
        if (string.length() < 3) {
            return null;
        }
        Matcher matcher = REGEX_PATTERN.matcher(string);
        if (matcher.matches()) {
            int flags = 0;
            String f = matcher.group(2);
            block9: for (int i = 0; i < f.length(); ++i) {
                switch (f.charAt(i)) {
                    case 'd': {
                        flags |= 1;
                        continue block9;
                    }
                    case 'i': {
                        flags |= 2;
                        continue block9;
                    }
                    case 'x': {
                        flags |= 4;
                        continue block9;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block9;
                    }
                    case 's': {
                        flags |= 0x20;
                        continue block9;
                    }
                    case 'u': {
                        flags |= 0x40;
                        continue block9;
                    }
                    case 'U': {
                        flags |= 0x100;
                    }
                }
            }
            return Pattern.compile(matcher.group(1), flags);
        }
        return null;
    }

    public static String toRegexString(Pattern pattern) {
        StringBuilder sb = new StringBuilder("/");
        sb.append(pattern.pattern());
        sb.append('/');
        int flags = pattern.flags();
        if ((flags & 1) != 0) {
            sb.append('d');
        }
        if ((flags & 2) != 0) {
            sb.append('i');
        }
        if ((flags & 4) != 0) {
            sb.append('x');
        }
        if ((flags & 8) != 0) {
            sb.append('m');
        }
        if ((flags & 0x20) != 0) {
            sb.append('s');
        }
        if ((flags & 0x40) != 0) {
            sb.append('u');
        }
        if ((flags & 0x100) != 0) {
            sb.append('U');
        }
        return sb.toString();
    }

    public static void queueIO(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    public static Path getPath(Object o) {
        try {
            if (o instanceof Path) {
                return KubeJS.verifyFilePath((Path)o);
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJS.verifyFilePath(KubeJS.getGameDirectory().resolve(o.toString()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static File getFileFromPath(Object o) {
        try {
            if (o instanceof File) {
                return KubeJS.verifyFilePath(((File)o).toPath()).toFile();
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJS.verifyFilePath(KubeJS.getGameDirectory().resolve(o.toString())).toFile();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static Object copy(@Nullable Object o) {
        if (o instanceof Copyable) {
            Copyable copyable = (Copyable)o;
            return copyable.copy();
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return JsonIO.copy(json);
        }
        if (o instanceof class_2520) {
            class_2520 tag = (class_2520)o;
            return tag.method_10707();
        }
        return o;
    }

    @Nullable
    public static Object wrap(@Nullable Object o, JSObjectType type) {
        if (o == null || o instanceof WrappedJS || o instanceof class_2520 || o instanceof Number || o instanceof Character || o instanceof String || o instanceof Enum || o.getClass().isPrimitive() && !o.getClass().isArray()) {
            return o;
        }
        if (o instanceof CharSequence || o instanceof class_2960) {
            return o.toString();
        }
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            return UtilsJS.wrap(w.unwrap(), type);
        }
        if (o instanceof class_2561) {
            class_2561 component = (class_2561)o;
            TextString t = new TextString("");
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add(component);
            list.addAll(component.method_10855());
            for (class_2561 c : list) {
                class_2568 he;
                Text t1;
                if (c instanceof class_2588) {
                    class_2588 tlc = (class_2588)c;
                    t1 = new TextTranslate(tlc.method_11022(), tlc.method_11023());
                } else {
                    t1 = new TextString(c.method_10851());
                }
                t1.bold(c.method_10866().method_10984());
                t1.italic(c.method_10866().method_10966());
                t1.underlined(c.method_10866().method_10965());
                t1.strikethrough(c.method_10866().method_10986());
                t1.obfuscated(c.method_10866().method_10987());
                t1.insertion(c.method_10866().method_10955());
                class_2558 ce = c.method_10866().method_10970();
                if (ce != null) {
                    if (ce.method_10845() == class_2558.class_2559.field_11750) {
                        t1.click("command:" + ce.method_10844());
                    } else if (ce.method_10845() == class_2558.class_2559.field_11745) {
                        t1.click("suggest_command:" + ce.method_10844());
                    } else if (ce.method_10845() == class_2558.class_2559.field_21462) {
                        t1.click("copy:" + ce.method_10844());
                    } else if (ce.method_10845() == class_2558.class_2559.field_11749) {
                        t1.click(ce.method_10844());
                    }
                }
                if ((he = c.method_10866().method_10969()) != null && he.method_10892() == class_2568.class_5247.field_24342) {
                    t1.hover(Text.of(he.method_10891(class_2568.class_5247.field_24342)));
                }
                t.append(t1);
            }
            return t;
        }
        if (o instanceof Map) {
            if (!type.checkMap()) {
                return null;
            }
            MapJS map = new MapJS(((Map)o).size());
            map.putAll((Map)o);
            return map;
        }
        if (o instanceof Iterable) {
            if (!type.checkList()) {
                return null;
            }
            ListJS list = new ListJS();
            for (Object o1 : (Iterable)o) {
                list.add(o1);
            }
            return list;
        }
        if (o.getClass().isArray()) {
            if (type.checkList()) {
                return ListJS.ofArray(o);
            }
            return null;
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)o;
            return JsonIO.toPrimitive((JsonElement)json);
        }
        if (o instanceof JsonObject) {
            JsonObject json = (JsonObject)o;
            if (!type.checkMap()) {
                return null;
            }
            MapJS map = new MapJS(json.size());
            for (Map.Entry entry : json.entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
            return map;
        }
        if (o instanceof JsonNull || o instanceof class_2491) {
            return null;
        }
        if (o instanceof class_2487) {
            class_2487 tag = (class_2487)o;
            if (!type.checkMap()) {
                return null;
            }
            MapJS map = new MapJS(tag.method_10546());
            for (String s : tag.method_10541()) {
                map.put(s, (Object)tag.method_10580(s));
            }
            return map;
        }
        if (o instanceof class_2514) {
            class_2514 tag = (class_2514)o;
            return tag.method_10702();
        }
        if (o instanceof class_2519) {
            class_2519 tag = (class_2519)o;
            return tag.method_10714();
        }
        return o;
    }

    public static int parseInt(@Nullable Object object, int def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.intValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long parseLong(@Nullable Object object, long def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.longValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static double parseDouble(@Nullable Object object, double def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.doubleValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Double.parseDouble(String.valueOf(object));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static LevelJS getLevel(class_1937 level) {
        if (level.method_8608()) {
            return UtilsJS.getClientLevel();
        }
        return ServerJS.instance.getLevel(level);
    }

    public static LevelJS getClientLevel() {
        return KubeJS.PROXY.getClientLevel();
    }

    public static String getID(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft:air";
        }
        if (s.indexOf(58) == -1) {
            return "minecraft:" + s;
        }
        return s;
    }

    public static class_2960 getMCID(@Nullable Object o) {
        if (o == null) {
            return AIR_LOCATION;
        }
        if (o instanceof class_2960) {
            class_2960 id = (class_2960)o;
            return id;
        }
        String s = o.toString();
        if (s == null || s.isEmpty()) {
            return AIR_LOCATION;
        }
        return new class_2960(s);
    }

    public static String getNamespace(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft";
        }
        int i = s.indexOf(58);
        return i == -1 ? "minecraft" : s.substring(0, i);
    }

    public static String getPath(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "air";
        }
        int i = s.indexOf(58);
        return i == -1 ? s : s.substring(i + 1);
    }

    public static class_2680 parseBlockState(String string) {
        if (string.isEmpty()) {
            return class_2246.field_10124.method_9564();
        }
        int i = string.indexOf(91);
        boolean hasProperties = i >= 0 && string.indexOf(93) == string.length() - 1;
        class_2680 state = ((class_2248)KubeJSRegistries.blocks().get(new class_2960(hasProperties ? string.substring(0, i) : string))).method_9564();
        if (hasProperties) {
            for (String s : string.substring(i + 1, string.length() - 1).split(",")) {
                Optional o;
                class_2769 p;
                String[] s1 = s.split("=", 2);
                if (s1.length != 2 || s1[0].isEmpty() || s1[1].isEmpty() || (p = state.method_26204().method_9595().method_11663(s1[0])) == null || !(o = p.method_11900(s1[1])).isPresent()) continue;
                state = (class_2680)state.method_11657(p, (Comparable)UtilsJS.cast(o.get()));
            }
        }
        return state;
    }

    public static <T> Predicate<T> onMatchDo(Predicate<T> predicate, Consumer<T> onMatch) {
        return t -> {
            boolean match = predicate.test(t);
            if (match) {
                onMatch.accept(t);
            }
            return match;
        };
    }

    public static ListJS rollChestLoot(class_2960 id, @Nullable EntityJS entity) {
        ListJS list = new ListJS();
        if (ServerJS.instance != null) {
            class_47.class_48 builder;
            MinecraftServer server = ServerJS.instance.getMinecraftServer();
            class_60 tables = ServerJS.instance.getMinecraftServer().method_3857();
            class_52 table = tables.method_367(id);
            if (entity != null) {
                class_1297 mcEntity = entity.minecraftEntity;
                builder = new class_47.class_48((class_3218)mcEntity.field_6002).method_306(class_181.field_1226, (Object)mcEntity).method_312(class_181.field_24424, (Object)mcEntity.method_19538());
            } else {
                builder = new class_47.class_48(server.method_30002()).method_306(class_181.field_1226, null).method_312(class_181.field_24424, (Object)class_243.field_1353);
            }
            table.method_320(builder.method_309(class_173.field_1179), stack -> list.add(ItemStackJS.of(stack)));
        }
        return list;
    }

    public static void postModificationEvents() {
        new BlockModificationEventJS().post(ScriptType.STARTUP, "block.modification");
        new ItemModificationEventJS().post(ScriptType.STARTUP, "item.modification");
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            return clz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            .Gson.Preconditions.checkArgument((boolean)(rawType instanceof Class));
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrType = (GenericArrayType)type;
            Type componentType = arrType.getGenericComponentType();
            return Array.newInstance(UtilsJS.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return UtilsJS.getRawType(wildcard.getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static String convertSnakeCaseToCamelCase(String string) {
        String[] s = SNAKE_CASE_SPLIT.split(string, 0);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String value : s) {
            if (value.isEmpty()) continue;
            if (first) {
                first = false;
                sb.append(value);
                continue;
            }
            sb.append(Character.toUpperCase(value.charAt(0)));
            sb.append(value, 1, value.length());
        }
        return sb.toString();
    }

    public static class_6017 intProviderOf(Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            return class_6016.method_34998((int)n.intValue());
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return class_6019.method_35017((int)min.intValue(), (int)max.intValue());
        }
        if (o instanceof Map) {
            Optional decoded;
            Map m = (Map)o;
            class_6019 intBounds = UtilsJS.parseIntBounds(m);
            if (intBounds != null) {
                return intBounds;
            }
            if (m.containsKey("clamped")) {
                class_6017 source = UtilsJS.intProviderOf(m.get("clamped"));
                class_6019 clampTo = UtilsJS.parseIntBounds(m);
                if (clampTo != null) {
                    return class_6334.method_36255((class_6017)source, (int)clampTo.method_35009(), (int)clampTo.method_35011());
                }
            } else if (m.containsKey("clamped_normal")) {
                class_6019 clampTo = UtilsJS.parseIntBounds(m);
                int mean = ((Number)m.get("mean")).intValue();
                int deviation = ((Number)m.get("deviation")).intValue();
                if (clampTo != null) {
                    return class_6728.method_39156((float)mean, (float)deviation, (int)clampTo.method_35009(), (int)clampTo.method_35011());
                }
            }
            if ((decoded = class_6017.field_29946.parse((DynamicOps)class_2509.field_11560, (Object)MapJS.nbt(m)).result()).isPresent()) {
                return (class_6017)decoded.get();
            }
        }
        return class_6016.method_34998((int)0);
    }

    private static class_6019 parseIntBounds(Map<String, Object> m) {
        Object object = m.get("bounds");
        if (object instanceof List) {
            List bounds = (List)object;
            return class_6019.method_35017((int)UtilsJS.parseInt(bounds.get(0), 0), (int)UtilsJS.parseInt(bounds.get(1), 0));
        }
        if (m.containsKey("min") && m.containsKey("max")) {
            return class_6019.method_35017((int)((Number)m.get("min")).intValue(), (int)((Number)m.get("max")).intValue());
        }
        if (m.containsKey("min_inclusive") && m.containsKey("max_inclusive")) {
            return class_6019.method_35017((int)((Number)m.get("min_inclusive")).intValue(), (int)((Number)m.get("max_inclusive")).intValue());
        }
        if (m.containsKey("value")) {
            int f = ((Number)m.get("value")).intValue();
            return class_6019.method_35017((int)f, (int)f);
        }
        return null;
    }

    public static class_5658 numberProviderOf(Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            float f = n.floatValue();
            return class_5662.method_32462((float)f, (float)f);
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return class_5662.method_32462((float)min.floatValue(), (float)max.floatValue());
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.containsKey("min") && m.containsKey("max")) {
                return class_5662.method_32462((float)((Number)m.get("min")).intValue(), (float)((Number)m.get("max")).floatValue());
            }
            if (m.containsKey("n") && m.containsKey("p")) {
                return class_40.method_273((int)((Number)m.get("n")).intValue(), (float)((Number)m.get("p")).floatValue());
            }
            if (m.containsKey("value")) {
                float f = ((Number)m.get("value")).floatValue();
                return class_5662.method_32462((float)f, (float)f);
            }
        }
        return class_44.method_32448((float)0.0f);
    }

    public static JsonElement numberProviderJson(class_5658 gen) {
        return class_5270.method_27860().create().toJsonTree((Object)gen);
    }

    public static Collection<class_2680> getAllBlockStates() {
        if (ALL_STATE_CACHE != null) {
            return ALL_STATE_CACHE;
        }
        HashSet states = new HashSet();
        for (class_2248 block : KubeJSRegistries.blocks()) {
            states.addAll(block.method_9595().method_11662());
        }
        ALL_STATE_CACHE = Collections.unmodifiableCollection(states);
        return ALL_STATE_CACHE;
    }

    public static String toTitleCase(String s) {
        if (s.isEmpty()) {
            return "";
        }
        if (ALWAYS_LOWER_CASE.contains(s)) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static interface TryIO {
        public void run() throws IOException;
    }
}

