/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.latvian.mods.kubejs.text.TextString;
import dev.latvian.mods.kubejs.text.TextTranslate;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2519;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class Text
implements Iterable<Text>,
Comparable<Text>,
JsonSerializable,
WrappedJS {
    private int color = -1;
    private Boolean bold;
    private Boolean italic;
    private Boolean underlined;
    private Boolean strikethrough;
    private Boolean obfuscated;
    private String insertion;
    private class_2960 font;
    private String click;
    private Text hover;
    private List<Text> siblings;

    public static class_2561 componentOf(@Nullable Object o) {
        if (o == null) {
            return new class_2585("null");
        }
        if (o instanceof class_2561) {
            class_2561 component = (class_2561)o;
            return component;
        }
        if (o instanceof CharSequence) {
            return new class_2585(o.toString());
        }
        if (o instanceof class_2519) {
            class_2519 tag = (class_2519)o;
            String s = tag.method_10714();
            if (s.startsWith("{") && s.endsWith("}")) {
                try {
                    return class_2561.class_2562.method_10877((String)s);
                }
                catch (JsonParseException ex) {
                    return new class_2585("Error: " + ex);
                }
            }
            return new class_2585(s);
        }
        return Text.of(o).component();
    }

    public static Text of(@Nullable Object o) {
        return Text.ofWrapped(UtilsJS.wrap(o, JSObjectType.ANY));
    }

    private static Text ofWrapped(@Nullable Object o) {
        MapJS map;
        if (o == null) {
            return new TextString("null");
        }
        if (o instanceof CharSequence || o instanceof Number || o instanceof Character) {
            return new TextString(o.toString());
        }
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            return new TextString(e.name());
        }
        if (o instanceof Text) {
            Text t = (Text)o;
            return t;
        }
        if (o instanceof ListJS) {
            ListJS list = (ListJS)o;
            TextString text = new TextString("");
            for (Object e1 : list) {
                text.append(Text.ofWrapped(e1));
            }
            return text;
        }
        if (o instanceof MapJS && ((map = (MapJS)o).containsKey("text") || map.containsKey("translate"))) {
            Text text;
            if (map.containsKey("text")) {
                text = new TextString(map.get("text").toString());
            } else {
                Object[] with;
                if (map.containsKey("with")) {
                    ListJS a = map.getOrNewList("with");
                    with = new Object[a.size()];
                    int i = 0;
                    for (Object e1 : a) {
                        with[i] = e1;
                        if (with[i] instanceof MapJS || with[i] instanceof ListJS) {
                            with[i] = Text.ofWrapped(e1);
                        }
                        ++i;
                    }
                } else {
                    with = new Object[]{};
                }
                text = new TextTranslate(map.get("translate").toString(), with);
            }
            if (map.containsKey("color")) {
                text.color = ColorWrapper.of(map.get("color")).getRgbKJS();
            }
            text.bold = map.getOrDefault("bold", null);
            text.italic = map.getOrDefault("italic", null);
            text.underlined = map.getOrDefault("underlined", null);
            text.strikethrough = map.getOrDefault("strikethrough", null);
            text.obfuscated = map.getOrDefault("obfuscated", null);
            text.insertion = map.getOrDefault("insertion", null);
            text.font = map.containsKey("font") ? new class_2960(map.get("font").toString()) : null;
            text.click = map.containsKey("click") ? map.get("click").toString() : null;
            text.hover = map.containsKey("hover") ? Text.ofWrapped(map.get("hover")) : null;
            text.siblings = null;
            if (map.containsKey("extra")) {
                for (Object e : map.getOrNewList("extra")) {
                    text.append(Text.ofWrapped(e));
                }
            }
            return text;
        }
        return new TextString(o.toString());
    }

    public static Text join(Text separator, Iterable<Text> texts) {
        TextString text = new TextString("");
        boolean first = true;
        for (Text t : texts) {
            if (first) {
                first = false;
            } else {
                text.append(separator);
            }
            text.append(t);
        }
        return text;
    }

    public static Text read(class_2540 buffer) {
        return Text.of(buffer.method_10808());
    }

    public abstract class_5250 rawComponent();

    public abstract Text rawCopy();

    public abstract JsonElement toJson();

    public final class_2561 component() {
        class_5250 component = this.rawComponent();
        if (this.hasStyle()) {
            component.method_10862(this.createStyle());
        }
        for (Text text : this.getSiblings()) {
            component.method_10852(text.component());
        }
        return component;
    }

    public final String getString() {
        return this.component().getString();
    }

    public final Text copy() {
        Text t = this.rawCopy();
        t.color = this.color;
        t.bold = this.bold;
        t.italic = this.italic;
        t.underlined = this.underlined;
        t.strikethrough = this.strikethrough;
        t.obfuscated = this.obfuscated;
        t.insertion = this.insertion;
        t.font = this.font;
        t.click = this.click;
        t.hover = this.hover == null ? null : this.hover.copy();
        for (Text child : this.getSiblings()) {
            t.append(child.copy());
        }
        return t;
    }

    public final JsonObject createStyleJson() {
        JsonObject json = new JsonObject();
        if (this.color != -1) {
            json.addProperty("color", String.format("#%06X", this.color));
        }
        if (this.bold != null) {
            json.addProperty("bold", this.bold);
        }
        if (this.italic != null) {
            json.addProperty("italic", this.italic);
        }
        if (this.underlined != null) {
            json.addProperty("underlined", this.underlined);
        }
        if (this.strikethrough != null) {
            json.addProperty("strikethrough", this.strikethrough);
        }
        if (this.obfuscated != null) {
            json.addProperty("obfuscated", this.obfuscated);
        }
        if (this.insertion != null) {
            json.addProperty("insertion", this.insertion);
        }
        if (this.font != null) {
            json.addProperty("font", this.font.toString());
        }
        if (this.click != null) {
            JsonObject o = new JsonObject();
            if (this.click.startsWith("command:")) {
                o.addProperty("action", "run_command");
                o.addProperty("value", this.click.substring(8));
            } else if (this.click.startsWith("suggest_command:")) {
                o.addProperty("action", "suggest_command");
                o.addProperty("value", this.click.substring(16));
            } else if (this.click.startsWith("copy:")) {
                o.addProperty("action", "copy_to_clipboard");
                o.addProperty("value", this.click.substring(5));
            } else if (this.click.startsWith("file:")) {
                o.addProperty("action", "open_file");
                o.addProperty("value", this.click.substring(5));
            } else {
                o.addProperty("action", "open_url");
                o.addProperty("value", this.click);
            }
            json.add("clickEvent", (JsonElement)o);
        }
        if (this.hover != null) {
            json.add("hoverEvent", (JsonElement)new class_2568(class_2568.class_5247.field_24342, (Object)this.hover.component()).method_27665());
        }
        return json;
    }

    public boolean hasStyle() {
        return this.color != -1 || this.bold != null || this.italic != null || this.underlined != null || this.strikethrough != null || this.obfuscated != null || this.insertion != null || this.font != null || this.click != null || this.hover != null;
    }

    public class_2583 createStyle() {
        return new class_2583.class_2584().method_10991((JsonElement)this.createStyleJson(), class_2583.class, null);
    }

    public JsonObject getStyleAndSiblingJson() {
        JsonObject json = this.createStyleJson();
        if (!this.getSiblings().isEmpty()) {
            JsonArray array = new JsonArray();
            for (Text child : this.getSiblings()) {
                array.add(child.toJson());
            }
            json.add("extra", (JsonElement)array);
        }
        return json;
    }

    @Override
    public final Iterator<Text> iterator() {
        if (this.getSiblings().isEmpty()) {
            return Collections.singleton(this).iterator();
        }
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(this);
        for (Text child : this.getSiblings()) {
            for (Text part : child) {
                list.add(part);
            }
        }
        return list.iterator();
    }

    public final Text color(Color c) {
        this.color = c.getRgbKJS() & 0xFFFFFF;
        return this;
    }

    public final Text black() {
        return this.color(ColorWrapper.BLACK);
    }

    public final Text darkBlue() {
        return this.color(ColorWrapper.DARK_BLUE);
    }

    public final Text darkGreen() {
        return this.color(ColorWrapper.DARK_GREEN);
    }

    public final Text darkAqua() {
        return this.color(ColorWrapper.DARK_AQUA);
    }

    public final Text darkRed() {
        return this.color(ColorWrapper.DARK_RED);
    }

    public final Text darkPurple() {
        return this.color(ColorWrapper.DARK_PURPLE);
    }

    public final Text gold() {
        return this.color(ColorWrapper.GOLD);
    }

    public final Text gray() {
        return this.color(ColorWrapper.GRAY);
    }

    public final Text darkGray() {
        return this.color(ColorWrapper.DARK_GRAY);
    }

    public final Text blue() {
        return this.color(ColorWrapper.BLUE);
    }

    public final Text green() {
        return this.color(ColorWrapper.GREEN);
    }

    public final Text aqua() {
        return this.color(ColorWrapper.AQUA);
    }

    public final Text red() {
        return this.color(ColorWrapper.RED);
    }

    public final Text lightPurple() {
        return this.color(ColorWrapper.LIGHT_PURPLE);
    }

    public final Text yellow() {
        return this.color(ColorWrapper.YELLOW);
    }

    public final Text white() {
        return this.color(ColorWrapper.WHITE);
    }

    public final Text noColor() {
        this.color = -1;
        return this;
    }

    public final Text bold(@Nullable Boolean value) {
        this.bold = value;
        return this;
    }

    public final Text bold() {
        return this.bold(true);
    }

    public final Text italic(@Nullable Boolean value) {
        this.italic = value;
        return this;
    }

    public final Text italic() {
        return this.italic(true);
    }

    public final Text underlined(@Nullable Boolean value) {
        this.underlined = value;
        return this;
    }

    public final Text underlined() {
        return this.underlined(true);
    }

    public final Text strikethrough(@Nullable Boolean value) {
        this.strikethrough = value;
        return this;
    }

    public final Text strikethrough() {
        return this.strikethrough(true);
    }

    public final Text obfuscated(@Nullable Boolean value) {
        this.obfuscated = value;
        return this;
    }

    public final Text obfuscated() {
        return this.obfuscated(true);
    }

    public final Text insertion(@Nullable String value) {
        this.insertion = value;
        return this;
    }

    public final Text font(@Nullable String value) {
        this.font = value == null || value.isEmpty() ? null : new class_2960(value);
        return this;
    }

    public final Text click(@Nullable String value) {
        this.click = value;
        return this;
    }

    public final Text hover(Object text) {
        this.hover = Text.of(text);
        return this;
    }

    public final Text append(Object sibling) {
        if (this.siblings == null) {
            this.siblings = new LinkedList<Text>();
        }
        this.siblings.add(Text.of(sibling));
        return this;
    }

    public final List<Text> getSiblings() {
        return this.siblings == null ? Collections.emptyList() : this.siblings;
    }

    public final boolean hasSiblings() {
        return this.siblings != null && !this.siblings.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Text) {
            Text t = (Text)obj;
            if (this.color == t.color && this.bold == t.bold && this.italic == t.italic && this.underlined == t.underlined && this.strikethrough == t.strikethrough && this.obfuscated == t.obfuscated) {
                return Objects.equals(this.insertion, t.insertion) && Objects.equals(this.font, t.font) && Objects.equals(this.click, t.click) && Objects.equals(this.hover, t.hover) && Objects.equals(this.siblings, t.siblings);
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.insertion, this.font, this.click, this.hover, this.siblings);
    }

    public String toString() {
        return this.component().getString();
    }

    @Override
    public int compareTo(Text other) {
        return this.toString().compareTo(other.toString());
    }

    public void write(class_2540 buffer) {
        buffer.method_10805(this.component());
    }
}

