/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.stages;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.core.PlayerKJS;
import dev.latvian.mods.kubejs.net.AddStageMessage;
import dev.latvian.mods.kubejs.net.RemoveStageMessage;
import dev.latvian.mods.kubejs.net.SyncStagesMessage;
import dev.latvian.mods.kubejs.stages.NoStages;
import dev.latvian.mods.kubejs.stages.StageChangeEvent;
import dev.latvian.mods.kubejs.stages.StageCreationEvent;
import dev.latvian.mods.kubejs.stages.TagWrapperStages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class Stages {
    private static final Event<Consumer<StageCreationEvent>> OVERRIDE_CREATION = EventFactory.createConsumerLoop((Object[])new StageCreationEvent[0]);
    private static final Event<Consumer<StageChangeEvent>> ADDED = EventFactory.createConsumerLoop((Object[])new StageChangeEvent[0]);
    private static final Event<Consumer<StageChangeEvent>> REMOVED = EventFactory.createConsumerLoop((Object[])new StageChangeEvent[0]);
    public final class_1657 player;

    private static Stages createEntityStages(class_1657 player) {
        if (PlayerHooks.isFake((class_1657)player) || KubeJS.PROXY.isClientButNotSelf(player)) {
            return NoStages.NULL_INSTANCE;
        }
        StageCreationEvent event = new StageCreationEvent(player);
        ((Consumer)OVERRIDE_CREATION.invoker()).accept(event);
        if (event.getPlayerStages() != null) {
            return event.getPlayerStages();
        }
        return new TagWrapperStages(player);
    }

    public static void overrideCreation(Consumer<StageCreationEvent> event) {
        OVERRIDE_CREATION.register(event);
    }

    public static void added(Consumer<StageChangeEvent> event) {
        ADDED.register(event);
    }

    public static void invokeAdded(Stages stages, String stage) {
        ((Consumer)ADDED.invoker()).accept(new StageChangeEvent(stages, stage));
    }

    public static void removed(Consumer<StageChangeEvent> event) {
        REMOVED.register(event);
    }

    public static void invokeRemoved(Stages stages, String stage) {
        ((Consumer)REMOVED.invoker()).accept(new StageChangeEvent(stages, stage));
    }

    public static Stages get(@Nullable class_1657 player) {
        if (player == null) {
            return NoStages.NULL_INSTANCE;
        }
        PlayerKJS playerKJS = (PlayerKJS)player;
        Stages stages = playerKJS.getStagesRawKJS();
        if (stages == null) {
            stages = Stages.createEntityStages(player);
            playerKJS.setStagesKJS(stages);
        }
        return stages;
    }

    public Stages(class_1657 p) {
        this.player = p;
    }

    public abstract boolean addNoUpdate(String var1);

    public abstract boolean removeNoUpdate(String var1);

    public abstract Collection<String> getAll();

    public boolean has(String stage) {
        return this.getAll().contains(stage);
    }

    public boolean add(String stage) {
        if (this.addNoUpdate(stage)) {
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                new AddStageMessage(this.player.method_5667(), stage).sendToAll(serverPlayer.field_13995);
            }
            Stages.invokeAdded(this, stage);
            return true;
        }
        return false;
    }

    public boolean remove(String stage) {
        if (this.removeNoUpdate(stage)) {
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                new RemoveStageMessage(this.player.method_5667(), stage).sendToAll(serverPlayer.field_13995);
            }
            Stages.invokeRemoved(this, stage);
            return true;
        }
        return false;
    }

    public final boolean set(String stage, boolean enabled) {
        return enabled ? this.add(stage) : this.remove(stage);
    }

    public final boolean toggle(String stage) {
        return this.set(stage, !this.has(stage));
    }

    public boolean clear() {
        Collection<String> all = this.getAll();
        if (all.isEmpty()) {
            return false;
        }
        for (String s : new ArrayList<String>(all)) {
            this.remove(s);
        }
        return true;
    }

    public void sync() {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            new SyncStagesMessage(this.player.method_5667(), this.getAll()).sendToAll(serverPlayer.field_13995);
        }
    }

    public void replace(Collection<String> stages) {
        Collection<String> all = this.getAll();
        for (String s : new ArrayList<String>(all)) {
            this.removeNoUpdate(s);
        }
        for (String s : stages) {
            this.addNoUpdate(s);
        }
    }
}

