/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.net.SendDataFromServerMessage;
import dev.latvian.mods.kubejs.player.AdvancementJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.server.IScheduledEventCallback;
import dev.latvian.mods.kubejs.server.ScheduledEvent;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.util.AttachedData;
import dev.latvian.mods.kubejs.util.MessageSender;
import dev.latvian.mods.kubejs.util.WithAttachedData;
import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ServerJS
implements MessageSender,
WithAttachedData {
    public static ServerJS instance;
    private MinecraftServer minecraftServer;
    public final transient ServerScriptManager serverScriptManager;
    public final transient List<ScheduledEvent> scheduledEvents;
    public final transient List<ScheduledEvent> scheduledTickEvents;
    public final transient Map<String, ServerLevelJS> levelMap;
    public final transient Map<UUID, ServerPlayerDataJS> playerMap;
    public final transient Map<UUID, FakeServerPlayerDataJS> fakePlayerMap;
    public final transient List<ServerLevelJS> allLevels;
    public final class_2487 persistentData;
    public ServerLevelJS overworld;
    private AttachedData data;

    public ServerJS(MinecraftServer ms, ServerScriptManager m) {
        this.minecraftServer = ms;
        this.serverScriptManager = m;
        this.scheduledEvents = new LinkedList<ScheduledEvent>();
        this.scheduledTickEvents = new LinkedList<ScheduledEvent>();
        this.levelMap = new HashMap<String, ServerLevelJS>();
        this.playerMap = new HashMap<UUID, ServerPlayerDataJS>();
        this.fakePlayerMap = new HashMap<UUID, FakeServerPlayerDataJS>();
        this.allLevels = new ArrayList<ServerLevelJS>();
        this.persistentData = new class_2487();
    }

    public void release() {
        this.minecraftServer = null;
        this.scheduledEvents.clear();
        this.scheduledTickEvents.clear();
        this.playerMap.clear();
        this.fakePlayerMap.clear();
        this.overworld = null;
        this.levelMap.clear();
        this.allLevels.clear();
        this.data = null;
    }

    public void updateWorldList() {
        this.allLevels.clear();
        this.allLevels.addAll(this.levelMap.values());
    }

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public List<ServerLevelJS> getAllLevels() {
        return this.allLevels;
    }

    public ServerLevelJS getOverworld() {
        return this.overworld;
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public boolean isRunning() {
        return this.getMinecraftServer().method_3806();
    }

    public boolean getHardcore() {
        return this.getMinecraftServer().method_3754();
    }

    public boolean isSinglePlayer() {
        return this.getMinecraftServer().method_3724();
    }

    public boolean isDedicated() {
        return this.getMinecraftServer().method_3816();
    }

    public String getMotd() {
        return this.getMinecraftServer().method_3818();
    }

    public void setMotd(class_2561 text) {
        this.getMinecraftServer().method_3834(text.getString());
    }

    public void stop() {
        this.getMinecraftServer().close();
    }

    @Override
    public Text getName() {
        return Text.of(this.getMinecraftServer().method_16898());
    }

    @Override
    public Text getDisplayName() {
        return Text.of(this.getMinecraftServer().method_3739().method_9223());
    }

    @Override
    public void tell(class_2561 message) {
        this.getMinecraftServer().method_9203(message, class_156.field_25140);
        for (class_3222 player : this.getMinecraftServer().method_3760().method_14571()) {
            player.method_9203(message, class_156.field_25140);
        }
    }

    @Override
    public void setStatusMessage(class_2561 message) {
        for (class_3222 player : this.getMinecraftServer().method_3760().method_14571()) {
            player.method_7353(message, true);
        }
    }

    @Override
    public int runCommand(String command) {
        return this.getMinecraftServer().method_3734().method_9249(this.getMinecraftServer().method_3739(), command);
    }

    @Override
    public int runCommandSilent(String command) {
        return this.getMinecraftServer().method_3734().method_9249(this.getMinecraftServer().method_3739().method_9217(), command);
    }

    public LevelJS getLevel(String dimension) {
        ServerLevelJS level = this.levelMap.get(dimension);
        if (level == null) {
            level = new ServerLevelJS(this, this.getMinecraftServer().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(dimension))));
            this.levelMap.put(dimension, level);
            this.updateWorldList();
            AttachDataEvent.forLevel(level).invoke();
        }
        return level;
    }

    public LevelJS getLevel(class_1937 minecraftLevel) {
        ServerLevelJS level = this.levelMap.get(minecraftLevel.method_27983().method_29177().toString());
        if (level == null) {
            level = new ServerLevelJS(this, (class_3218)minecraftLevel);
            this.levelMap.put(minecraftLevel.method_27983().method_29177().toString(), level);
            this.updateWorldList();
            AttachDataEvent.forLevel(level).invoke();
        }
        return level;
    }

    @Nullable
    public ServerPlayerJS getPlayer(UUID uuid) {
        ServerPlayerDataJS p = this.playerMap.get(uuid);
        if (p == null) {
            return null;
        }
        return p.getPlayer();
    }

    @Nullable
    public ServerPlayerJS getPlayer(String name) {
        if ((name = name.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        UUID uuid = UUIDWrapper.fromString((Object)name);
        if (uuid != null) {
            return this.getPlayer(uuid);
        }
        for (ServerPlayerDataJS p : this.playerMap.values()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p.getPlayer();
        }
        for (ServerPlayerDataJS p : this.playerMap.values()) {
            if (!p.getName().toLowerCase().contains(name)) continue;
            return p.getPlayer();
        }
        return null;
    }

    @Nullable
    public ServerPlayerJS getPlayer(class_1657 minecraftPlayer) {
        return this.getPlayer(minecraftPlayer.method_5667());
    }

    public EntityArrayList getPlayers() {
        return new EntityArrayList((LevelJS)this.overworld, this.getMinecraftServer().method_3760().method_14571());
    }

    public EntityArrayList getEntities() {
        EntityArrayList list = new EntityArrayList((LevelJS)this.overworld, 10);
        for (ServerLevelJS level : this.allLevels) {
            list.addAll(level.getEntities());
        }
        return list;
    }

    public EntityArrayList getEntities(String filter) {
        EntityArrayList list = new EntityArrayList((LevelJS)this.overworld, 10);
        for (ServerLevelJS level : this.allLevels) {
            list.addAll(level.getEntities(filter));
        }
        return list;
    }

    public ScheduledEvent schedule(long timer, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, false, timer, System.currentTimeMillis() + timer, data, event);
        this.scheduledEvents.add(e);
        return e;
    }

    public ScheduledEvent schedule(long timer, IScheduledEventCallback event) {
        return this.schedule(timer, null, event);
    }

    public ScheduledEvent scheduleInTicks(long ticks, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, true, ticks, this.overworld.getTime() + ticks, data, event);
        this.scheduledTickEvents.add(e);
        return e;
    }

    public ScheduledEvent scheduleInTicks(long ticks, IScheduledEventCallback event) {
        return this.scheduleInTicks(ticks, null, event);
    }

    public String toString() {
        return "Server";
    }

    @Nullable
    public AdvancementJS getAdvancement(class_2960 id) {
        class_161 a = this.getMinecraftServer().method_3851().method_12896(id);
        return a == null ? null : new AdvancementJS(a);
    }

    public void sendDataToAll(String channel, @Nullable class_2487 data) {
        new SendDataFromServerMessage(channel, data).sendToAll(this.getMinecraftServer());
    }
}

