/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandPerformEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.command.KubeJSCommands;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.level.SimpleLevelEventJS;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.player.SimplePlayerEventJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.CommandEventJS;
import dev.latvian.mods.kubejs.server.ScheduledEvent;
import dev.latvian.mods.kubejs.server.ServerEventJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.RhinoException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class KubeJSServerEventHandler {
    private static final class_5218 PERSISTENT_DATA = new class_5218("kubejs_persistent_data.nbt");

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(KubeJSServerEventHandler::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(KubeJSServerEventHandler::registerCommands);
        LifecycleEvent.SERVER_STARTED.register(KubeJSServerEventHandler::serverStarted);
        LifecycleEvent.SERVER_STOPPING.register(KubeJSServerEventHandler::serverStopping);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(KubeJSServerEventHandler::serverWorldSave);
        TickEvent.SERVER_POST.register(KubeJSServerEventHandler::serverTick);
        CommandPerformEvent.EVENT.register(KubeJSServerEventHandler::command);
    }

    public static void serverAboutToStart(MinecraftServer server) {
        if (ServerJS.instance != null) {
            KubeJSServerEventHandler.destroyServer();
        }
        ServerJS.instance = new ServerJS(server, ServerScriptManager.instance);
        Path p = server.method_27050(PERSISTENT_DATA);
        if (Files.exists(p, new LinkOption[0])) {
            try {
                class_2487 tag = class_2507.method_30613((File)p.toFile());
                if (tag != null) {
                    ServerJS.instance.persistentData.method_10543(tag);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 selection) {
        KubeJSCommands.register(dispatcher);
    }

    public static void serverStarted(MinecraftServer server) {
        ServerJS.instance.overworld = new ServerLevelJS(ServerJS.instance, server.method_3847(class_1937.field_25179));
        ServerJS.instance.levelMap.put("minecraft:overworld", ServerJS.instance.overworld);
        ServerJS.instance.allLevels.add(ServerJS.instance.overworld);
        for (class_3218 class_32182 : server.method_3738()) {
            if (class_32182 == ServerJS.instance.overworld.minecraftLevel) continue;
            ServerLevelJS l = new ServerLevelJS(ServerJS.instance, class_32182);
            ServerJS.instance.levelMap.put(class_32182.method_27983().method_29177().toString(), l);
        }
        ServerJS.instance.updateWorldList();
        AttachDataEvent.forServer(ServerJS.instance).invoke();
        new ServerEventJS().post(ScriptType.SERVER, "server.load");
        for (ServerLevelJS serverLevelJS : ServerJS.instance.allLevels) {
            AttachDataEvent.forLevel(serverLevelJS).invoke();
            new SimpleLevelEventJS(serverLevelJS).post("level.load");
        }
    }

    public static void serverStopping(MinecraftServer server) {
        KubeJSServerEventHandler.destroyServer();
    }

    public static void destroyServer() {
        ServerJS s = ServerJS.instance;
        for (PlayerDataJS playerDataJS : s.playerMap.values()) {
            new SimplePlayerEventJS((class_1657)playerDataJS.getMinecraftPlayer()).post("player.logged_out");
        }
        for (ServerLevelJS serverLevelJS : s.levelMap.values()) {
            new SimpleLevelEventJS(serverLevelJS).post("level.unload");
        }
        new ServerEventJS().post(ScriptType.SERVER, "server.unload");
        s.release();
        ServerJS.instance = null;
    }

    private static void serverWorldSave(class_3218 level) {
        ServerJS s = ServerJS.instance;
        Path p = level.method_8503().method_27050(PERSISTENT_DATA);
        if (s != null && level.method_27983() == class_1937.field_25179) {
            class_156.method_27958().execute(() -> {
                try {
                    class_2507.method_30614((class_2487)s.persistentData, (File)p.toFile());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    public static void serverTick(MinecraftServer server) {
        Object e;
        ArrayList<Object> list;
        Iterator<ScheduledEvent> eventIterator;
        long now;
        ServerJS s = ServerJS.instance;
        if (!s.scheduledEvents.isEmpty()) {
            now = System.currentTimeMillis();
            eventIterator = s.scheduledEvents.iterator();
            list = new ArrayList<Object>();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (RhinoException ex) {
                    ConsoleJS.SERVER.error("Error occurred while handling scheduled event callback: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!s.scheduledTickEvents.isEmpty()) {
            now = s.getOverworld().getTime();
            eventIterator = s.scheduledTickEvents.iterator();
            list = new ArrayList();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (RhinoException ex) {
                    ConsoleJS.SERVER.error("Error occurred while handling scheduled event callback: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        new ServerEventJS().post(ScriptType.SERVER, "server.tick");
    }

    public static EventResult command(CommandPerformEvent event) {
        if (new CommandEventJS(event).post(ScriptType.SERVER, "command.run")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

