/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.util.BuilderBase;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3266;
import net.minecraft.class_3270;
import org.jetbrains.annotations.Nullable;

public abstract class KubeJSResourcePack
implements class_3262 {
    private final class_3264 packType;
    private Map<class_2960, JsonElement> cachedResources;

    public KubeJSResourcePack(class_3264 t) {
        this.packType = t;
    }

    private static String getFullPath(class_3264 type, class_2960 location) {
        return String.format("%s/%s/%s", type.method_14413(), location.method_12836(), location.method_12832());
    }

    public InputStream method_14410(String fileName) throws IOException {
        if (fileName.equals("pack.png")) {
            return KubeJSResourcePack.class.getResourceAsStream("/kubejs_logo.png");
        }
        throw new class_3266(KubeJSPaths.DIRECTORY.toFile(), fileName);
    }

    public InputStream method_14405(class_3264 type, class_2960 location) throws IOException {
        JsonElement json;
        String resourcePath = KubeJSResourcePack.getFullPath(type, location);
        if (type != this.packType) {
            throw new IllegalStateException(this.packType.method_14413() + " KubeJS pack can't load " + resourcePath + "!");
        }
        Path file = KubeJSPaths.DIRECTORY.resolve(resourcePath);
        if (Files.exists(file, new LinkOption[0])) {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        if (location.method_12832().endsWith(".json") && (json = this.getCachedResources().get(location)) != null) {
            return new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8));
        }
        throw new class_3266(KubeJSPaths.DIRECTORY.toFile(), resourcePath);
    }

    public boolean method_14411(class_3264 type, class_2960 location) {
        JsonElement json;
        if (location.method_12832().endsWith(".json") && (json = this.getCachedResources().get(location)) != null) {
            return true;
        }
        return type == this.packType && Files.exists(KubeJSPaths.DIRECTORY.resolve(KubeJSResourcePack.getFullPath(type, location)), new LinkOption[0]);
    }

    public Map<class_2960, JsonElement> getCachedResources() {
        if (this.cachedResources == null) {
            HashMap<class_2960, JsonElement> map = new HashMap<class_2960, JsonElement>();
            this.generateJsonFiles(map);
            this.cachedResources = new HashMap<class_2960, JsonElement>();
            for (Map.Entry entry : map.entrySet()) {
                this.cachedResources.put(new class_2960(((class_2960)entry.getKey()).method_12836(), ((class_2960)entry.getKey()).method_12832() + ".json"), (JsonElement)entry.getValue());
            }
        }
        return this.cachedResources;
    }

    public void generateJsonFiles(Map<class_2960, JsonElement> map) {
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        if (type != this.packType) {
            return Collections.emptySet();
        }
        ArrayList list = Lists.newArrayList();
        if (type == class_3264.field_14188) {
            if (path.equals("lang")) {
                list.add(new class_2960("kubejs", "lang/en_us.json"));
            }
        } else if (path.equals("loot_tables")) {
            for (class_2960 id : KubeJSObjects.BLOCKS.keySet()) {
                list.add(new class_2960(id.method_12836(), "loot_tables/blocks/" + id.method_12832() + ".json"));
            }
        }
        UtilsJS.tryIO(() -> {
            Path root = KubeJSPaths.get(type).toAbsolutePath();
            if (Files.exists(root, new LinkOption[0]) && Files.isDirectory(root, new LinkOption[0])) {
                Path inputPath = root.getFileSystem().getPath(path, new String[0]);
                Files.walk(root, new FileVisitOption[0]).map(p -> root.relativize(p.toAbsolutePath())).filter(p -> p.getNameCount() > 1 && p.getNameCount() - 1 <= maxDepth).filter(p -> !p.toString().endsWith(".mcmeta")).filter(p -> p.subpath(1, p.getNameCount()).startsWith(inputPath)).filter(p -> filter.test(p.getFileName().toString())).map(p -> new class_2960(p.getName(0).toString(), Joiner.on((char)'/').join((Iterable)p.subpath(1, Math.min(maxDepth, p.getNameCount()))))).forEach(list::add);
            }
        });
        return list;
    }

    public Set<String> method_14406(class_3264 type) {
        if (type != this.packType) {
            return Collections.emptySet();
        }
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add("kubejs_generated");
        namespaces.add("kubejs");
        for (BuilderBase builder : KubeJSObjects.ALL) {
            namespaces.add(builder.id.method_12836());
        }
        UtilsJS.tryIO(() -> {
            Path root = KubeJSPaths.get(type).toAbsolutePath();
            if (Files.exists(root, new LinkOption[0]) && Files.isDirectory(root, new LinkOption[0])) {
                Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).forEach(namespaces::add);
            }
        });
        return namespaces;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> serializer) {
        return null;
    }

    public String method_14409() {
        return "KubeJS Resource Pack [" + this.packType.method_14413() + "]";
    }

    public void close() {
        this.cachedResources = null;
    }
}

