/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.architectury.core.AbstractRecipeSerializer;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ShapedKubeJSRecipe
extends class_1869 {
    private String group;
    private int width;
    private int height;
    private class_2371<class_1856> ingredients;
    private class_1799 result;
    private boolean mirror;
    private boolean shrink;
    private List<IngredientAction> ingredientActions;

    public ShapedKubeJSRecipe(class_2960 _id) {
        super(_id, "", 0, 0, class_2371.method_10213((int)0, (Object)class_1856.field_9017), class_1799.field_8037);
    }

    public class_1865<?> method_8119() {
        return KubeJSRecipeEventHandler.SHAPED.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110() {
        return this.result;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean method_8113(int w, int h) {
        return w >= this.width && h >= this.height;
    }

    public boolean method_17728(class_1715 craftingContainer, class_1937 level) {
        for (int x = 0; x <= craftingContainer.method_17398() - this.width; ++x) {
            for (int y = 0; y <= craftingContainer.method_17397() - this.height; ++y) {
                if (this.mirror && this.matches(craftingContainer, x, y, true)) {
                    return true;
                }
                if (!this.matches(craftingContainer, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(class_1715 craftingContainer, int x0, int y0, boolean mirrorPattern) {
        for (int x = 0; x < craftingContainer.method_17398(); ++x) {
            for (int y = 0; y < craftingContainer.method_17397(); ++y) {
                int m = x - x0;
                int n = y - y0;
                class_1856 ingredient = class_1856.field_9017;
                if (m >= 0 && n >= 0 && m < this.width && n < this.height) {
                    ingredient = mirrorPattern ? (class_1856)this.ingredients.get(this.width - m - 1 + n * this.width) : (class_1856)this.ingredients.get(m + n * this.width);
                }
                if (ingredient.method_8093(craftingContainer.method_5438(x + y * craftingContainer.method_17398()))) continue;
                return false;
            }
        }
        return true;
    }

    public class_1799 method_17727(class_1715 craftingContainer) {
        return this.method_8110().method_7972();
    }

    public int method_8150() {
        return this.width;
    }

    public int method_8158() {
        return this.height;
    }

    public class_2371<class_1799> getRemainingItems(class_1715 container) {
        class_2371 list = class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    private static class_2371<class_1856> dissolvePattern(String[] pattern, Map<String, class_1856> key, int w, int h) {
        class_2371 nonNullList = class_2371.method_10213((int)(w * h), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(key.keySet());
        set.remove(" ");
        for (int k = 0; k < pattern.length; ++k) {
            for (int l = 0; l < pattern[k].length(); ++l) {
                String string = pattern[k].substring(l, l + 1);
                class_1856 ingredient = key.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(l + w * k, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonNullList;
    }

    private static String[] shrink(String[] strings) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < strings.length; ++m) {
            String string = strings[m];
            i = Math.min(i, ShapedKubeJSRecipe.firstNonSpace(string));
            int n = ShapedKubeJSRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (strings.length == l) {
            return new String[0];
        }
        String[] strings2 = new String[strings.length - l - k];
        for (int o = 0; o < strings2.length; ++o) {
            strings2[o] = strings[o + k].substring(i, j + 1);
        }
        return strings2;
    }

    private static int firstNonSpace(String string) {
        int i;
        for (i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArray) {
        String[] strings = new String[jsonArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)jsonArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    private static Map<String, class_1856> keyFromJson(JsonObject jsonObject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapedKubeJSRecipe> {
        public ShapedKubeJSRecipe fromJson(class_2960 id, JsonObject json) {
            ShapedKubeJSRecipe r = new ShapedKubeJSRecipe(id);
            r.mirror = !json.has("mirror") || json.get("mirror").getAsBoolean();
            r.shrink = !json.has("shrink") || json.get("shrink").getAsBoolean();
            r.group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            Map<String, class_1856> key = ShapedKubeJSRecipe.keyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] pattern = ShapedKubeJSRecipe.patternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern"));
            if (r.shrink) {
                pattern = ShapedKubeJSRecipe.shrink(pattern);
            }
            r.width = pattern[0].length();
            r.height = pattern.length;
            r.ingredients = ShapedKubeJSRecipe.dissolvePattern(pattern, key, r.width, r.height);
            r.result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            r.ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            return r;
        }

        public ShapedKubeJSRecipe fromNetwork(class_2960 id, class_2540 buf) {
            ShapedKubeJSRecipe r = new ShapedKubeJSRecipe(id);
            r.group = buf.method_10800(Short.MAX_VALUE);
            r.width = buf.method_10816();
            r.height = buf.method_10816();
            r.ingredients = class_2371.method_10213((int)(r.width * r.height), (Object)class_1856.field_9017);
            for (int i = 0; i < r.width * r.height; ++i) {
                r.ingredients.set(i, (Object)class_1856.method_8086((class_2540)buf));
            }
            r.result = buf.method_10819();
            r.mirror = buf.readBoolean();
            r.shrink = buf.readBoolean();
            r.ingredientActions = IngredientAction.readList(buf);
            return r;
        }

        public void toNetwork(class_2540 buf, ShapedKubeJSRecipe r) {
            buf.method_10814(r.group);
            buf.method_10804(r.width);
            buf.method_10804(r.height);
            for (class_1856 ingredient : r.ingredients) {
                ingredient.method_8088(buf);
            }
            buf.method_10793(r.result);
            buf.writeBoolean(r.mirror);
            buf.writeBoolean(r.shrink);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

