/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.latvian.mods.kubejs.core.RecipeManagerKJS;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.recipe.AfterLoadRecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.minecraft.CustomRecipeJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipesAfterLoadEventJS
extends EventJS {
    private final Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipeMap;
    private List<RecipeJS> originalRecipes;
    private final Set<RecipeJS> removedRecipes = new HashSet<RecipeJS>();

    private RecipesAfterLoadEventJS(Map<class_3956<?>, Map<class_2960, class_1860<?>>> r) {
        this.recipeMap = r;
    }

    private List<RecipeJS> getOriginalRecipes() {
        if (this.originalRecipes == null) {
            this.originalRecipes = new ArrayList<RecipeJS>();
            for (Map<class_2960, class_1860<?>> map : this.recipeMap.values()) {
                for (Map.Entry<class_2960, class_1860<?>> entry : map.entrySet()) {
                    CustomRecipeJS r = new CustomRecipeJS();
                    r.id = entry.getKey();
                    r.originalRecipe = entry.getValue();
                    r.type = new AfterLoadRecipeTypeJS(r.originalRecipe.method_8119());
                    this.originalRecipes.add(r);
                }
            }
        }
        return this.originalRecipes;
    }

    public void forEachRecipe(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.getOriginalRecipes().forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            this.getOriginalRecipes().stream().filter(filter).forEach(consumer);
        }
    }

    public void forEachRecipeAsync(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.getOriginalRecipes().parallelStream().forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            this.getOriginalRecipes().parallelStream().filter(filter).forEach(consumer);
        }
    }

    public int countRecipes(RecipeFilter filter) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            return this.getOriginalRecipes().size();
        }
        if (filter != RecipeFilter.ALWAYS_FALSE) {
            return (int)this.getOriginalRecipes().stream().filter(filter).count();
        }
        return 0;
    }

    public int remove(RecipeFilter filter) {
        MutableInt count = new MutableInt();
        this.forEachRecipe(filter, r -> {
            if (this.removedRecipes.add((RecipeJS)r)) {
                if (ServerSettings.instance.logRemovedRecipes) {
                    ConsoleJS.SERVER.info("- " + r + ": " + r.getFromToString());
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("- " + r + ": " + r.getFromToString());
                }
                count.increment();
            }
        });
        return count.getValue();
    }

    @HideFromJS
    public static void post(RecipeManagerKJS recipeManager) {
        RecipesAfterLoadEventJS e = new RecipesAfterLoadEventJS(recipeManager.getRecipesKJS());
        boolean b = ServerSettings.instance.useOriginalRecipeForFilters;
        ServerSettings.instance.useOriginalRecipeForFilters = true;
        e.post(ScriptType.SERVER, "recipes.after_load");
        ServerSettings.instance.useOriginalRecipeForFilters = b;
        if (e.originalRecipes != null) {
            e.originalRecipes.removeAll(e.removedRecipes);
            HashMap newMap = new HashMap();
            HashMap newByName = new HashMap();
            for (RecipeJS r : e.originalRecipes) {
                newMap.computeIfAbsent(r.originalRecipe.method_17716(), t -> new HashMap()).put(r.id, r.originalRecipe);
                newByName.put(r.id, r.originalRecipe);
            }
            recipeManager.setRecipesKJS(newMap);
            recipeManager.setByNameKJS(newByName);
        }
    }
}

