/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import com.mojang.authlib.GameProfile;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.latvian.mods.kubejs.core.PlayerKJS;
import dev.latvian.mods.kubejs.entity.LivingEntityJS;
import dev.latvian.mods.kubejs.item.InventoryJS;
import dev.latvian.mods.kubejs.item.ItemHandlerUtils;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.player.PlayerStatsJS;
import dev.latvian.mods.kubejs.stages.Stages;
import dev.latvian.mods.kubejs.util.AttachedData;
import dev.latvian.mods.kubejs.util.WithAttachedData;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerJS<E extends class_1657>
extends LivingEntityJS
implements WithAttachedData {
    public final E minecraftPlayer;
    private final PlayerDataJS playerData;
    private InventoryJS inventory;

    public PlayerJS(PlayerDataJS d, LevelJS l, E p) {
        super(l, (class_1309)p);
        this.playerData = d;
        this.minecraftPlayer = p;
    }

    @Override
    public AttachedData getData() {
        return this.playerData.getData();
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    public boolean isFake() {
        return PlayerHooks.isFake(this.minecraftPlayer);
    }

    @Override
    public String toString() {
        return this.minecraftPlayer.method_7334().getName();
    }

    @Override
    public GameProfile getProfile() {
        return this.minecraftPlayer.method_7334();
    }

    public InventoryJS getInventory() {
        if (this.inventory == null) {
            this.inventory = new InventoryJS((class_1263)this.minecraftPlayer.method_31548()){

                @Override
                public void markDirty() {
                    PlayerJS.this.sendInventoryUpdate();
                }
            };
        }
        return this.inventory;
    }

    public void sendInventoryUpdate() {
        this.minecraftPlayer.method_31548().method_5431();
        ((class_1657)this.minecraftPlayer).field_7498.method_7623();
    }

    public void give(ItemStackJS item) {
        ItemHandlerUtils.giveItemToPlayer(this.minecraftPlayer, item.getItemStack(), -1);
    }

    public void giveInHand(ItemStackJS item) {
        ItemHandlerUtils.giveItemToPlayer(this.minecraftPlayer, item.getItemStack(), this.getSelectedSlot());
    }

    public int getSelectedSlot() {
        return this.minecraftPlayer.method_31548().field_7545;
    }

    public void setSelectedSlot(int index) {
        this.minecraftPlayer.method_31548().field_7545 = class_3532.method_15340((int)index, (int)0, (int)8);
    }

    public ItemStackJS getMouseItem() {
        if (((class_1657)this.minecraftPlayer).field_7512 != null) {
            return ItemStackJS.of(((class_1657)this.minecraftPlayer).field_7512.method_34255());
        }
        return ItemStackJS.of(((class_1657)this.minecraftPlayer).field_7498.method_34255());
    }

    public void setMouseItem(ItemStackJS item) {
        if (((class_1657)this.minecraftPlayer).field_7512 != null) {
            ((class_1657)this.minecraftPlayer).field_7512.method_34254(item.getItemStack());
        } else {
            ((class_1657)this.minecraftPlayer).field_7498.method_34254(item.getItemStack());
        }
    }

    @Override
    public void setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        super.setPositionAndRotation(x, y, z, yaw, pitch);
        if (this.minecraftPlayer instanceof class_3222) {
            ((class_3222)this.minecraftPlayer).field_13987.method_14363(x, y, z, yaw, pitch);
        }
    }

    @Override
    public void setStatusMessage(class_2561 message) {
        this.minecraftPlayer.method_7353(message, true);
    }

    public boolean isCreativeMode() {
        return this.minecraftPlayer.method_7337();
    }

    public boolean isSpectator() {
        return this.minecraftPlayer.method_7325();
    }

    public abstract PlayerStatsJS getStats();

    @Override
    public void spawn() {
    }

    public void sendData(String channel, @Nullable class_2487 data) {
    }

    public void addFood(int f, float m) {
        this.minecraftPlayer.method_7344().method_7585(f, m);
    }

    public int getFoodLevel() {
        return this.minecraftPlayer.method_7344().method_7586();
    }

    public void setFoodLevel(int foodLevel) {
        this.minecraftPlayer.method_7344().method_7580(foodLevel);
    }

    public void addExhaustion(float exhaustion) {
        this.minecraftPlayer.method_7322(exhaustion);
    }

    public void addXP(int xp) {
        this.minecraftPlayer.method_7255(xp);
    }

    public void addXPLevels(int l) {
        this.minecraftPlayer.method_7316(l);
    }

    public void setXp(int xp) {
        ((class_1657)this.minecraftPlayer).field_7495 = 0;
        ((class_1657)this.minecraftPlayer).field_7510 = 0.0f;
        ((class_1657)this.minecraftPlayer).field_7520 = 0;
        this.minecraftPlayer.method_7255(xp);
    }

    public int getXp() {
        return ((class_1657)this.minecraftPlayer).field_7495;
    }

    public void setXpLevel(int l) {
        ((class_1657)this.minecraftPlayer).field_7495 = 0;
        ((class_1657)this.minecraftPlayer).field_7510 = 0.0f;
        ((class_1657)this.minecraftPlayer).field_7520 = 0;
        this.minecraftPlayer.method_7316(l);
    }

    public int getXpLevel() {
        return ((class_1657)this.minecraftPlayer).field_7520;
    }

    public abstract void paint(class_2487 var1);

    public void boostElytraFlight() {
        if (this.minecraftPlayer.method_6128()) {
            class_243 v = this.minecraftPlayer.method_5720();
            double d0 = 1.5;
            double d1 = 0.1;
            class_243 m = this.minecraftPlayer.method_18798();
            this.minecraftPlayer.method_18799(m.method_1031(v.field_1352 * 0.1 + (v.field_1352 * 1.5 - m.field_1352) * 0.5, v.field_1351 * 0.1 + (v.field_1351 * 1.5 - m.field_1351) * 0.5, v.field_1350 * 0.1 + (v.field_1350 * 1.5 - m.field_1350) * 0.5));
        }
    }

    public void closeInventory() {
        this.minecraftPlayer.method_7346();
    }

    public class_1703 getOpenInventory() {
        return ((class_1657)this.minecraftPlayer).field_7512;
    }

    public abstract boolean isMiningBlock();

    public void addItemCooldown(class_1792 item, int ticks) {
        this.minecraftPlayer.method_7357().method_7906(item, ticks);
    }

    public int getAirSupply() {
        return this.minecraftPlayer.method_5669();
    }

    public void setAirSupply(int air) {
        this.minecraftPlayer.method_5855(air);
    }

    public int getMaxAirSupply() {
        return this.minecraftPlayer.method_5748();
    }

    public Stages getStages() {
        return ((PlayerKJS)this.minecraftPlayer).getStagesKJS();
    }
}

