/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level.gen.filter.biome;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.latvian.mods.kubejs.level.gen.filter.biome.AndFilter;
import dev.latvian.mods.kubejs.level.gen.filter.biome.CategoryFilter;
import dev.latvian.mods.kubejs.level.gen.filter.biome.IDFilter;
import dev.latvian.mods.kubejs.level.gen.filter.biome.NotFilter;
import dev.latvian.mods.kubejs.level.gen.filter.biome.OrFilter;
import dev.latvian.mods.kubejs.level.gen.filter.biome.RegexIDFilter;
import dev.latvian.mods.kubejs.level.gen.filter.biome.fabric.BiomeFilterImpl;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_1959;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface BiomeFilter
extends Predicate<BiomeModifications.BiomeContext> {
    public static final BiomeFilter ALWAYS_TRUE = ctx -> true;
    public static final BiomeFilter ALWAYS_FALSE = ctx -> false;

    @Override
    public boolean test(BiomeModifications.BiomeContext var1);

    public static BiomeFilter of(@Nullable Object o) {
        if (o == null || o == ALWAYS_TRUE) {
            return ALWAYS_TRUE;
        }
        if (o == ALWAYS_FALSE) {
            return ALWAYS_FALSE;
        }
        if (o instanceof String) {
            String s = (String)o;
            return BiomeFilter.idFilter(s);
        }
        if (o instanceof NativeRegExp || o instanceof Pattern) {
            return BiomeFilter.idFilter(o.toString());
        }
        ListJS list = ListJS.orSelf(o);
        if (list.isEmpty()) {
            return ALWAYS_TRUE;
        }
        if (list.size() > 1) {
            ArrayList<BiomeFilter> filters = new ArrayList<BiomeFilter>();
            for (Object o1 : list) {
                BiomeFilter filter = BiomeFilter.of(o1);
                if (filter == ALWAYS_TRUE) {
                    return ALWAYS_TRUE;
                }
                if (filter == ALWAYS_FALSE) continue;
                filters.add(filter);
            }
            return filters.isEmpty() ? ALWAYS_FALSE : (filters.size() == 1 ? (BiomeFilter)filters.get(0) : new OrFilter(filters));
        }
        MapJS map = MapJS.of(list.get(0));
        if (map == null || map.isEmpty()) {
            return ALWAYS_TRUE;
        }
        ArrayList<BiomeFilter> filters = new ArrayList<BiomeFilter>();
        if (map.get("or") != null) {
            filters.add(BiomeFilter.of(map.get("or")));
        }
        if (map.get("not") != null) {
            filters.add(new NotFilter(BiomeFilter.of(map.get("not"))));
        }
        try {
            BiomeFilter additional;
            if (map.get("id") != null) {
                filters.add(BiomeFilter.idFilter(map.get("id").toString()));
            }
            if (map.get("type") != null) {
                filters.add(BiomeFilter.idFilter(map.get("type").toString()));
            }
            if (map.get("category") != null) {
                filters.add(new CategoryFilter(class_1959.class_1961.method_28424((String)map.get("category").toString())));
            }
            if ((additional = BiomeFilter.ofMapAdditional(map)) != null) {
                filters.add(additional);
            }
        }
        catch (Exception ex) {
            ConsoleJS.STARTUP.error("Error trying to create BiomeFilter: " + ex.getMessage());
            return ALWAYS_FALSE;
        }
        return filters.isEmpty() ? ALWAYS_TRUE : (filters.size() == 1 ? (BiomeFilter)filters.get(0) : new AndFilter(filters));
    }

    public static BiomeFilter idFilter(String s) {
        Pattern pattern = UtilsJS.parseRegex(s);
        if (pattern != null) {
            return new RegexIDFilter(pattern);
        }
        if (s.charAt(0) == '^') {
            return new CategoryFilter(class_1959.class_1961.method_28424((String)s.substring(1)));
        }
        BiomeFilter additional = BiomeFilter.ofStringAdditional(s);
        if (additional != null) {
            return additional;
        }
        return new IDFilter(UtilsJS.getMCID(s));
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static BiomeFilter ofStringAdditional(String s) {
        return BiomeFilterImpl.ofStringAdditional(s);
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static BiomeFilter ofMapAdditional(Map<String, Object> map) {
        return BiomeFilterImpl.ofMapAdditional(map);
    }
}

