/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.WorldlyCommandSender;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2303;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5268;

public class ServerLevelJS
extends LevelJS {
    private final ServerJS server;
    public final class_2487 persistentData;

    public ServerLevelJS(ServerJS s, class_3218 w) {
        super((class_1937)w);
        this.server = s;
        String t = w.method_27983().method_29177().toString();
        this.persistentData = s.persistentData.method_10562(t);
        s.persistentData.method_10566(t, (class_2520)this.persistentData);
    }

    @Override
    public ScriptType getSide() {
        return ScriptType.SERVER;
    }

    @Override
    public ServerJS getServer() {
        return this.server;
    }

    public long getSeed() {
        return this.getMinecraftLevel().method_8412();
    }

    public void setTime(long time) {
        ((class_5268)this.minecraftLevel.method_8401()).method_29034(time);
    }

    public void setLocalTime(long time) {
        ((class_5268)this.minecraftLevel.method_8401()).method_29035(time);
    }

    @Override
    public ServerPlayerDataJS getPlayerData(class_1657 player) {
        ServerPlayerDataJS data = this.server.playerMap.get(player.method_5667());
        if (data != null) {
            return data;
        }
        FakeServerPlayerDataJS fakeData = this.server.fakePlayerMap.get(player.method_5667());
        if (fakeData == null) {
            fakeData = new FakeServerPlayerDataJS(this.server, (class_3222)player);
            AttachDataEvent.forPlayer(fakeData).invoke();
        }
        fakeData.player = (class_3222)player;
        return fakeData;
    }

    public String toString() {
        return "ServerWorld:" + this.getDimension();
    }

    @Override
    public EntityArrayList getEntities() {
        return new EntityArrayList((LevelJS)this, Lists.newArrayList((Iterable)this.getMinecraftLevel().method_27909()));
    }

    public class_3218 getMinecraftLevel() {
        return (class_3218)super.getMinecraftLevel();
    }

    public EntityArrayList getEntities(String filter) {
        if (filter.equals("@e")) {
            return this.getEntities();
        }
        if (filter.equals("@a")) {
            return this.getPlayers();
        }
        try {
            return this.createEntityList(new class_2303(new StringReader(filter), true).method_9882().method_9816((class_2168)new WorldlyCommandSender(this)));
        }
        catch (CommandSyntaxException e) {
            return new EntityArrayList((LevelJS)this, 0);
        }
    }
}

