/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.entity.ItemEntityJS;
import dev.latvian.mods.kubejs.entity.ItemFrameEntityJS;
import dev.latvian.mods.kubejs.entity.LivingEntityJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.ExplosionJS;
import dev.latvian.mods.kubejs.level.FireworksJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.player.ServerPlayerJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.GameRulesJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.util.AttachedData;
import dev.latvian.mods.kubejs.util.WithAttachedData;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class LevelJS
implements WithAttachedData {
    public final class_1937 minecraftLevel;
    private AttachedData data;

    public LevelJS(class_1937 w) {
        this.minecraftLevel = w;
    }

    public abstract ScriptType getSide();

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public GameRulesJS getGameRules() {
        return new GameRulesJS(this.minecraftLevel.method_8450());
    }

    @Nullable
    public ServerJS getServer() {
        return null;
    }

    public long getTime() {
        return this.minecraftLevel.method_8510();
    }

    public long getLocalTime() {
        return this.minecraftLevel.method_8532();
    }

    public String getDimension() {
        return this.minecraftLevel.method_27983().method_29177().toString();
    }

    public boolean isOverworld() {
        return this.minecraftLevel.method_27983() == class_1937.field_25179;
    }

    public boolean isDaytime() {
        return this.minecraftLevel.method_8530();
    }

    public boolean isRaining() {
        return this.minecraftLevel.method_8419();
    }

    public boolean isThundering() {
        return this.minecraftLevel.method_8546();
    }

    public void setRainStrength(float strength) {
        this.minecraftLevel.method_8519(strength);
    }

    public BlockContainerJS getBlock(int x, int y, int z) {
        return this.getBlock(new class_2338(x, y, z));
    }

    public BlockContainerJS getBlock(class_2338 pos) {
        return new BlockContainerJS(this.minecraftLevel, pos);
    }

    public BlockContainerJS getBlock(class_2586 blockEntity) {
        return this.getBlock(blockEntity.method_11016());
    }

    public abstract PlayerDataJS getPlayerData(class_1657 var1);

    @Nullable
    public EntityJS getEntity(@Nullable class_1297 e) {
        if (e == null) {
            return null;
        }
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            return this.getPlayerData(player).getPlayer();
        }
        if (e instanceof class_1309) {
            class_1309 living = (class_1309)e;
            return new LivingEntityJS(this, living);
        }
        if (e instanceof class_1542) {
            class_1542 item = (class_1542)e;
            return new ItemEntityJS(this, item);
        }
        if (e instanceof class_1533) {
            class_1533 frame = (class_1533)e;
            return new ItemFrameEntityJS(this, frame);
        }
        return new EntityJS(this, e);
    }

    @Nullable
    public LivingEntityJS getLivingEntity(@Nullable class_1297 entity) {
        LivingEntityJS living;
        EntityJS e = this.getEntity(entity);
        return e instanceof LivingEntityJS ? (living = (LivingEntityJS)e) : null;
    }

    @Nullable
    public PlayerJS getPlayer(@Nullable class_1297 entity) {
        PlayerJS player;
        if (!(entity instanceof class_1657)) {
            return null;
        }
        EntityJS e = this.getEntity(entity);
        return e instanceof PlayerJS ? (player = (PlayerJS)e) : null;
    }

    public EntityArrayList createEntityList(Collection<? extends class_1297> entities) {
        return new EntityArrayList(this, entities);
    }

    public EntityArrayList getPlayers() {
        return this.createEntityList(this.minecraftLevel.method_18456());
    }

    public EntityArrayList getEntities() {
        return new EntityArrayList(this, 0);
    }

    public ExplosionJS createExplosion(double x, double y, double z) {
        return new ExplosionJS((class_1936)this.minecraftLevel, x, y, z);
    }

    @Nullable
    public EntityJS createEntity(class_2960 id) {
        class_1299 type = (class_1299)class_2378.field_11145.method_10223(id);
        if (type == null) {
            return null;
        }
        return this.getEntity(type.method_5883(this.minecraftLevel));
    }

    public void spawnLightning(double x, double y, double z, boolean effectOnly, @Nullable EntityJS player) {
        if (this.minecraftLevel instanceof class_3218) {
            class_3222 class_32222;
            class_1538 e = (class_1538)class_1299.field_6112.method_5883(this.minecraftLevel);
            e.method_24203(x, y, z);
            if (player instanceof ServerPlayerJS) {
                ServerPlayerJS serverPlayer = (ServerPlayerJS)player;
                class_32222 = (class_3222)serverPlayer.minecraftPlayer;
            } else {
                class_32222 = null;
            }
            e.method_6961(class_32222);
            e.method_29498(effectOnly);
            this.minecraftLevel.method_8649((class_1297)e);
        }
    }

    public void spawnLightning(double x, double y, double z, boolean effectOnly) {
        this.spawnLightning(x, y, z, effectOnly, null);
    }

    public void spawnFireworks(double x, double y, double z, FireworksJS f) {
        this.minecraftLevel.method_8649((class_1297)f.createFireworkRocket(this.minecraftLevel, x, y, z));
    }

    public EntityArrayList getEntitiesWithin(class_238 aabb) {
        return new EntityArrayList(this, this.minecraftLevel.method_8335(null, aabb));
    }

    @ApiStatus.OverrideOnly
    public class_1937 getMinecraftLevel() {
        return this.minecraftLevel;
    }
}

