/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.level.ExplosionEventJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.level.SimpleLevelEventJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class KubeJSWorldEventHandler {
    public static void init() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(KubeJSWorldEventHandler::levelLoad);
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(KubeJSWorldEventHandler::levelUnload);
        TickEvent.SERVER_LEVEL_POST.register(KubeJSWorldEventHandler::levelPostTick);
        ExplosionEvent.PRE.register(KubeJSWorldEventHandler::preExplosion);
        ExplosionEvent.DETONATE.register(KubeJSWorldEventHandler::detonateExplosion);
    }

    private static void levelLoad(class_3218 level) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && !ServerJS.instance.levelMap.containsKey(level.method_27983().method_29177().toString())) {
            ServerLevelJS l = new ServerLevelJS(ServerJS.instance, level);
            ServerJS.instance.levelMap.put(level.method_27983().method_29177().toString(), l);
            ServerJS.instance.updateWorldList();
            AttachDataEvent.forLevel(l).invoke();
            new SimpleLevelEventJS(l).post(ScriptType.SERVER, "level.load");
        }
    }

    private static void levelUnload(class_3218 level) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && ServerJS.instance.levelMap.containsKey(level.method_27983().method_29177().toString())) {
            LevelJS l = ServerJS.instance.getLevel((class_1937)level);
            new SimpleLevelEventJS(l).post(ScriptType.SERVER, "level.unload");
            ServerJS.instance.levelMap.remove(l.getDimension());
            ServerJS.instance.updateWorldList();
        }
    }

    private static void levelPostTick(class_3218 level) {
        LevelJS l = ServerJS.instance.getLevel((class_1937)level);
        new SimpleLevelEventJS(l).post(ScriptType.SERVER, "level.tick");
    }

    private static EventResult preExplosion(class_1937 level, class_1927 explosion) {
        ExplosionEventJS.Pre event = new ExplosionEventJS.Pre(level, explosion);
        if (event.post("level.explosion.pre")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void detonateExplosion(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities) {
        new ExplosionEventJS.Post(level, explosion, affectedEntities).post("level.explosion.post");
    }
}

