/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class TagIngredientJS
implements IngredientJS {
    private static final Map<String, TagIngredientJS> tagIngredientCache = new HashMap<String, TagIngredientJS>();
    private final class_2960 tag;
    private class_3494<class_1792> actualTag;

    public static TagIngredientJS createTag(String tag) {
        return tagIngredientCache.computeIfAbsent(tag, TagIngredientJS::new).validateTag();
    }

    public static void clearTagCache() {
        tagIngredientCache.clear();
    }

    private TagIngredientJS(String t) {
        this.tag = UtilsJS.getMCID(t);
    }

    public String getTag() {
        return this.tag.toString();
    }

    public class_3494<class_1792> getActualTag() {
        if (this.actualTag == null) {
            this.actualTag = Tags.items().method_30213(this.tag);
        }
        return this.actualTag;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.getActualTag().method_15141((Object)stack.getItem());
    }

    @Override
    public boolean testVanilla(class_1799 stack) {
        return !stack.method_7960() && this.getActualTag().method_15141((Object)stack.method_7909());
    }

    @Override
    public boolean testVanillaItem(class_1792 item) {
        return item != class_1802.field_8162 && this.getActualTag().method_15141((Object)item);
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        class_3494<class_1792> t = this.getActualTag();
        if (t.method_15138().size() > 0) {
            LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
            for (class_1792 item : t.method_15138()) {
                set.add(new ItemStackJS(new class_1799((class_1935)item)));
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<class_1792> getVanillaItems() {
        class_3494<class_1792> t = this.getActualTag();
        if (t.method_15138().size() > 0) {
            return new LinkedHashSet<class_1792>(t.method_15138());
        }
        return Collections.emptySet();
    }

    @Override
    public ItemStackJS getFirst() {
        this.validateTag();
        Iterator iterator = this.getActualTag().method_15138().iterator();
        if (iterator.hasNext()) {
            class_1792 item = (class_1792)iterator.next();
            return new ItemStackJS(new class_1799((class_1935)item));
        }
        return ItemStackJS.EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return this.getActualTag().method_15138().isEmpty();
    }

    public String toString() {
        return "'#" + this.tag + "'";
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.tag.toString());
        return json;
    }

    @Override
    public boolean anyStackMatches(IngredientJS ingredient) {
        if (ingredient instanceof TagIngredientJS) {
            TagIngredientJS tagIngredient = (TagIngredientJS)ingredient;
            if (this.tag.equals((Object)tagIngredient.tag)) {
                return true;
            }
        }
        return IngredientJS.super.anyStackMatches(ingredient);
    }

    private TagIngredientJS validateTag() {
        if (RecipeJS.itemErrors && this.isEmpty()) {
            throw new RecipeExceptionJS(String.format("Tag '#%s' doesn't contain any items!", this.tag)).error();
        }
        return this;
    }

    @Override
    public class_1856 createVanillaIngredient() {
        return class_1856.method_8106(this.getActualTag());
    }
}

