/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.DetectorInstance;
import dev.latvian.mods.kubejs.core.ItemKJS;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.item.BlockItemJS;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemCraftedEventJS;
import dev.latvian.mods.kubejs.item.ItemEntityInteractEventJS;
import dev.latvian.mods.kubejs.item.ItemLeftClickEventJS;
import dev.latvian.mods.kubejs.item.ItemPickupEventJS;
import dev.latvian.mods.kubejs.item.ItemRightClickEmptyEventJS;
import dev.latvian.mods.kubejs.item.ItemRightClickEventJS;
import dev.latvian.mods.kubejs.item.ItemSmeltedEventJS;
import dev.latvian.mods.kubejs.item.ItemTossEventJS;
import dev.latvian.mods.kubejs.item.fabric.KubeJSItemEventHandlerImpl;
import dev.latvian.mods.kubejs.player.InventoryChangedEventJS;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;

public class KubeJSItemEventHandler {
    public static Supplier<class_1792> DUMMY_FLUID_ITEM = () -> class_1802.field_8615;

    public static void init() {
        if (!CommonProperties.get().serverOnly) {
            KubeJSItemEventHandler.registry();
        }
        InteractionEvent.RIGHT_CLICK_ITEM.register(KubeJSItemEventHandler::rightClick);
        InteractionEvent.CLIENT_RIGHT_CLICK_AIR.register(KubeJSItemEventHandler::rightClickEmpty);
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.register(KubeJSItemEventHandler::leftClickEmpty);
        PlayerEvent.PICKUP_ITEM_PRE.register(KubeJSItemEventHandler::pickup);
        PlayerEvent.DROP_ITEM.register(KubeJSItemEventHandler::drop);
        InteractionEvent.INTERACT_ENTITY.register(KubeJSItemEventHandler::entityInteract);
        PlayerEvent.CRAFT_ITEM.register(KubeJSItemEventHandler::crafted);
        PlayerEvent.SMELT_ITEM.register(KubeJSItemEventHandler::smelted);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_1755 buildBucket(FluidBuilder builder) {
        return KubeJSItemEventHandlerImpl.buildBucket(builder);
    }

    private static void registry() {
        ItemKJS kjs;
        class_1792 class_17922;
        Iterator<Object> iterator = KubeJSObjects.ITEMS.values().iterator();
        while (iterator.hasNext()) {
            ItemBuilder itemBuilder;
            (itemBuilder = iterator.next()).item = itemBuilder.type.createItem(itemBuilder);
            class_17922 = (itemBuilder = iterator.next()).item;
            if (class_17922 instanceof ItemKJS) {
                kjs = (ItemKJS)class_17922;
                kjs.setItemBuilderKJS(itemBuilder);
            }
            KubeJSRegistries.items().register(itemBuilder.id, () -> builder.item);
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.itemBuilder == null) continue;
            blockBuilder.itemBuilder.blockItem = new BlockItemJS(blockBuilder.itemBuilder);
            class_17922 = blockBuilder.itemBuilder.blockItem;
            if (class_17922 instanceof ItemKJS) {
                kjs = (ItemKJS)class_17922;
                kjs.setItemBuilderKJS(blockBuilder.itemBuilder);
            }
            KubeJSRegistries.items().register(blockBuilder.id, () -> builder.itemBuilder.blockItem);
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.bucketItem = KubeJSItemEventHandler.buildBucket(fluidBuilder);
            KubeJSRegistries.items().register(fluidBuilder.newID("", "_bucket"), () -> builder.bucketItem);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            detectorInstance.item = KubeJSRegistries.items().register(KubeJS.id("detector_" + detectorInstance.id), () -> new class_1747(detector.block.get(), new class_1792.class_1793().method_7892(KubeJS.tab)));
        }
        if (!CommonProperties.get().serverOnly) {
            DUMMY_FLUID_ITEM = KubeJSRegistries.items().register(KubeJS.id("dummy_fluid_item"), () -> new class_1792(new class_1792.class_1793().method_7889(1).method_7892(KubeJS.tab)));
        }
    }

    private static CompoundEventResult<class_1799> rightClick(class_1657 player, class_1268 hand) {
        if (!player.method_7357().method_7904(player.method_5998(hand).method_7909()) && new ItemRightClickEventJS(player, hand).post("item.right_click")) {
            return CompoundEventResult.interruptTrue((Object)player.method_5998(hand));
        }
        return CompoundEventResult.pass();
    }

    private static void rightClickEmpty(class_1657 player, class_1268 hand) {
        if (player != null && player.field_6002 != null) {
            new ItemRightClickEmptyEventJS(player, hand).post("item.right_click_empty");
        }
    }

    private static void leftClickEmpty(class_1657 player, class_1268 hand) {
        if (player != null && player.field_6002 != null) {
            new ItemLeftClickEventJS(player, hand).post("item.left_click");
        }
    }

    private static EventResult pickup(class_1657 player, class_1542 entity, class_1799 stack) {
        if (player != null && entity != null && player.field_6002 != null && new ItemPickupEventJS(player, entity, stack).post("item.pickup")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult drop(class_1657 player, class_1542 entity) {
        if (player != null && entity != null && player.field_6002 != null && new ItemTossEventJS(player, entity).post("item.toss")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult entityInteract(class_1657 player, class_1297 entity, class_1268 hand) {
        if (player != null && entity != null && player.field_6002 != null && new ItemEntityInteractEventJS(player, entity, hand).post("item.entity_interact")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void crafted(class_1657 player, class_1799 crafted, class_1263 grid) {
        if (player instanceof class_3222 && !crafted.method_7960()) {
            new ItemCraftedEventJS(player, crafted, grid).post("item.crafted");
            new InventoryChangedEventJS((class_3222)player, crafted, -1).post("player.inventory.changed");
        }
    }

    private static void smelted(class_1657 player, class_1799 smelted) {
        if (player instanceof class_3222 && !smelted.method_7960()) {
            new ItemSmeltedEventJS(player, smelted).post("item.smelted");
            new InventoryChangedEventJS((class_3222)player, smelted, -1).post("player.inventory.changed");
        }
    }
}

