/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.core.ItemStackKJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.DummyFluidItemStackJS;
import dev.latvian.mods.kubejs.item.DummyItemStackJSIngredient;
import dev.latvian.mods.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IgnoreNBTIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.RegexIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.WeakNBTIngredientJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.ChangeListener;
import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.mod.util.TagUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ItemStackJS
implements IngredientJS,
NBTSerializable,
ChangeListener<class_2520>,
SpecialEquality {
    public static final ItemStackJS EMPTY = new ItemStackJS(class_1799.field_8037){

        @Override
        public String getId() {
            return "minecraft:air";
        }

        @Override
        public Collection<class_2960> getTags() {
            return Collections.emptySet();
        }

        @Override
        public boolean hasTag(class_2960 tag) {
            return false;
        }

        @Override
        public class_1792 getItem() {
            return class_1802.field_8162;
        }

        @Override
        public ItemStackJS copy() {
            return this;
        }

        @Override
        public void setCount(int c) {
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public ItemStackJS withCount(int c) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Nullable
        public class_2487 getNbt() {
            return null;
        }

        @Override
        public void setNbt(@Nullable class_2487 tag) {
        }

        @Override
        public boolean hasNBT() {
            return false;
        }

        @Override
        public String getNbtString() {
            return "null";
        }

        @Override
        public ItemStackJS removeNBT() {
            return this;
        }

        @Override
        public ItemStackJS withNBT(class_2487 nbt) {
            return this;
        }

        @Override
        public void setChance(double c) {
        }

        @Override
        public double getChance() {
            return Double.NaN;
        }

        @Override
        public boolean hasChance() {
            return false;
        }

        @Override
        public String toString() {
            return "Item.empty";
        }

        @Override
        public boolean test(ItemStackJS other) {
            return false;
        }

        @Override
        public boolean testVanilla(class_1799 other) {
            return false;
        }

        @Override
        public boolean testVanillaItem(class_1792 item) {
            return false;
        }

        @Override
        public Set<ItemStackJS> getStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<class_1792> getVanillaItems() {
            return Collections.emptySet();
        }

        @Override
        public ItemStackJS getFirst() {
            return this;
        }

        @Override
        public IngredientJS not() {
            return MatchAllIngredientJS.INSTANCE;
        }

        @Override
        public ItemStackJS withName(@Nullable class_2561 displayName) {
            return this;
        }

        @Override
        public MapJS getEnchantments() {
            return new MapJS(){

                @Override
                protected boolean setChangeListener(@Nullable Object v) {
                    return false;
                }
            };
        }

        @Override
        public boolean hasEnchantment(class_1887 enchantment, int level) {
            return false;
        }

        @Override
        public ItemStackJS enchant(MapJS map) {
            return this;
        }

        @Override
        public ItemStackJS enchant(class_1887 enchantment, int level) {
            return this;
        }

        @Override
        public String getMod() {
            return "minecraft";
        }

        @Override
        public boolean areItemsEqual(ItemStackJS other) {
            return other.isEmpty();
        }

        @Override
        public boolean areItemsEqual(class_1799 other) {
            return other.method_7960();
        }

        @Override
        public boolean isNBTEqual(ItemStackJS other) {
            return !other.hasNBT();
        }

        @Override
        public boolean isNBTEqual(class_1799 other) {
            return !other.method_7985();
        }

        @Override
        public boolean equals(Object o) {
            return 1.of(o).isEmpty();
        }

        @Override
        public boolean strongEquals(Object o) {
            return 1.of(o).isEmpty();
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", "minecraft:air");
            return json;
        }

        @Override
        public JsonElement toRawResultJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", "minecraft:air");
            json.addProperty("count", (Number)1);
            return json;
        }

        @Override
        public void onChanged(@Nullable class_2520 o) {
        }

        @Override
        public String getItemGroup() {
            return "";
        }
    };
    private static List<ItemStackJS> cachedItemList;
    private static ListJS cachedItemListJS;
    private static ListJS cachedItemTypeListJS;
    private final class_1799 stack;
    private double chance = Double.NaN;

    public static ItemStackJS of(@Nullable Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == class_1799.field_8037 || o == class_1802.field_8162) {
            return EMPTY;
        }
        if (o instanceof ItemStackJS) {
            ItemStackJS js = (ItemStackJS)o;
            return js;
        }
        if (o instanceof FluidStackJS) {
            FluidStackJS fluidStack = (FluidStackJS)o;
            return new DummyFluidItemStackJS(fluidStack);
        }
        if (o instanceof IngredientJS) {
            IngredientJS ingr = (IngredientJS)o;
            return ingr.getFirst();
        }
        if (o instanceof class_1799) {
            class_1799 stack = (class_1799)o;
            return stack.method_7960() ? EMPTY : new ItemStackJS(stack);
        }
        if (o instanceof class_2960) {
            class_2960 id = (class_2960)o;
            class_1792 item = (class_1792)KubeJSRegistries.items().get(id);
            if (item == class_1802.field_8162) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                }
                return EMPTY;
            }
            return new ItemStackJS(new class_1799((class_1935)item));
        }
        if (o instanceof class_1935) {
            class_1935 itemLike = (class_1935)o;
            return new ItemStackJS(new class_1799((class_1935)itemLike.method_8389()));
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return ItemStackJS.resultFromRecipeJson(json);
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return new RegexIngredientJS(reg).getFirst();
            }
            return EMPTY;
        }
        if (o instanceof CharSequence) {
            String s = o.toString().trim();
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
                return EMPTY;
            }
            if (s.startsWith("#")) {
                return TagIngredientJS.createTag(s.substring(1)).getFirst().withCount(count);
            }
            if (s.startsWith("@")) {
                return new ModIngredientJS(s.substring(1)).getFirst().withCount(count);
            }
            if (s.startsWith("%")) {
                class_1761 group = ItemStackJS.findGroup(s.substring(1));
                if (group == null) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                    }
                    return EMPTY;
                }
                return new GroupIngredientJS(group).getFirst().withCount(count);
            }
            Pattern reg = UtilsJS.parseRegex(s);
            if (reg != null) {
                return new RegexIngredientJS(reg).getFirst().withCount(count);
            }
            class_1792 item = (class_1792)KubeJSRegistries.items().get(new class_2960(s));
            if (item == class_1802.field_8162) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + s + "' not found!").error();
                }
                return EMPTY;
            }
            return new ItemStackJS(new class_1799((class_1935)item, count));
        }
        MapJS map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                String id = KubeJS.appendModId(map.get("item").toString());
                class_1792 item = (class_1792)KubeJSRegistries.items().get(new class_2960(id));
                if (item == class_1802.field_8162) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                    }
                    return EMPTY;
                }
                class_1799 stack = new class_1799((class_1935)item);
                Object v = map.get("count");
                if (v instanceof Number) {
                    Number number = (Number)v;
                    stack.method_7939(number.intValue());
                }
                if (map.containsKey("nbt")) {
                    stack.method_7980(MapJS.nbt(map.get("nbt")));
                }
                return new ItemStackJS(stack);
            }
            Object id = map.get("tag");
            if (id instanceof CharSequence) {
                CharSequence s = (CharSequence)id;
                ItemStackJS stack = TagIngredientJS.createTag(s.toString()).getFirst();
                if (map.containsKey("count")) {
                    stack.setCount(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
            if (map.get("fluid") instanceof CharSequence) {
                return new DummyFluidItemStackJS(FluidStackJS.of(map));
            }
        }
        return EMPTY;
    }

    public static class_1792 getRawItem(@Nullable Object o) {
        if (o == null) {
            return class_1802.field_8162;
        }
        if (o instanceof class_1792) {
            class_1792 item = (class_1792)o;
            return item;
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s.isEmpty()) {
                return class_1802.field_8162;
            }
            if (s.charAt(0) != '#') {
                return (class_1792)KubeJSRegistries.items().get(UtilsJS.getMCID(s));
            }
        }
        return ItemStackJS.of(o).getItem();
    }

    public static ItemStackJS resultFromRecipeJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.of(json.getAsString());
        }
        if (json.isJsonObject()) {
            ItemStackJS is;
            JsonObject o = json.getAsJsonObject();
            if (RecipeJS.currentRecipe != null && (is = RecipeJS.currentRecipe.resultFromRecipeJson(o)) != null) {
                return is;
            }
            if (o.has("item")) {
                ItemStackJS stack = ItemStackJS.of(o.get("item").getAsString());
                if (o.has("count")) {
                    stack.setCount(o.get("count").getAsInt());
                }
                if (o.has("nbt")) {
                    JsonElement element = o.get("nbt");
                    stack = element.isJsonObject() ? stack.withNBT(MapJS.nbt(element)) : stack.withNBT(MapJS.nbt(element.getAsString()));
                }
                if (o.has("chance")) {
                    boolean locked = o.has("locked") && o.get("locked").getAsBoolean();
                    double c = o.get("chance").getAsDouble();
                    stack.setChance(locked ? -c : c);
                }
                return stack;
            }
            if (o.has("tag")) {
                int c = 1;
                if (o.has("count")) {
                    c = o.get("count").getAsInt();
                } else if (o.has("amount")) {
                    c = o.get("amount").getAsInt();
                }
                return TagIngredientJS.createTag(o.get("tag").getAsString()).getFirst().withCount(c);
            }
        }
        return EMPTY;
    }

    public static List<ItemStackJS> getList() {
        if (cachedItemList != null) {
            return cachedItemList;
        }
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        class_2371 stackList = class_2371.method_10211();
        for (class_1792 item : KubeJSRegistries.items()) {
            try {
                item.method_7850(class_1761.field_7915, stackList);
            }
            catch (Throwable throwable) {}
        }
        for (class_1799 stack : stackList) {
            if (stack.method_7960()) continue;
            set.add(new ItemStackJS(stack).withCount(1));
        }
        cachedItemList = List.of(set.toArray(new ItemStackJS[0]));
        return cachedItemList;
    }

    public static ListJS getListJS() {
        if (cachedItemListJS == null) {
            cachedItemListJS = Objects.requireNonNull(ListJS.of(ItemStackJS.getList()));
        }
        return cachedItemListJS;
    }

    public static void clearListCache() {
        cachedItemList = null;
        cachedItemListJS = null;
    }

    public static ListJS getTypeList() {
        if (cachedItemTypeListJS == null) {
            cachedItemTypeListJS = new ListJS();
            for (class_2960 id : KubeJSRegistries.items().getIds()) {
                cachedItemTypeListJS.add(id.toString());
            }
        }
        return cachedItemTypeListJS;
    }

    @Nullable
    public static class_1761 findGroup(String id) {
        for (class_1761 group : class_1761.field_7921) {
            if (!id.equals(group.method_7751())) continue;
            return group;
        }
        return null;
    }

    public ItemStackJS(class_1799 s) {
        this.stack = s;
    }

    public class_1792 getItem() {
        return this.stack.method_7909();
    }

    public class_1799 getItemStack() {
        return this.stack;
    }

    public String getId() {
        return Registries.getId((Object)this.getItem(), (class_5321)class_2378.field_25108).toString();
    }

    public Collection<class_2960> getTags() {
        return Tags.byItem(this.getItem());
    }

    public boolean hasTag(class_2960 tag) {
        return Tags.items().method_30213(tag).method_15141((Object)this.getItem());
    }

    @Override
    public ItemStackJS copy() {
        ItemStackJS s = new ItemStackJS(this.stack.method_7972());
        s.chance = this.chance;
        if (!this.hasNBT()) {
            ((ItemStackKJS)s.stack).removeTagKJS();
        }
        return s;
    }

    public void setCount(int count) {
        this.stack.method_7939(count);
    }

    @Override
    public int getCount() {
        return this.stack.method_7947();
    }

    @Override
    public ItemStackJS withCount(int c) {
        if (c <= 0) {
            return EMPTY;
        }
        ItemStackJS is = this.copy();
        is.setCount(c);
        return is;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.method_7960();
    }

    @Override
    public boolean isInvalidRecipeIngredient() {
        return this.stack.method_7960();
    }

    public boolean isBlock() {
        return this.stack.method_7909() instanceof class_1747;
    }

    @Nullable
    public class_2487 getNbt() {
        return this.stack.method_7969();
    }

    public void setNbt(@Nullable class_2487 tag) {
        this.stack.method_7980(tag);
    }

    public boolean hasNBT() {
        return this.stack.method_7985();
    }

    public String getNbtString() {
        return String.valueOf(this.getNbt());
    }

    public ItemStackJS removeNBT() {
        ItemStackJS s = this.copy();
        ((ItemStackKJS)s.stack).removeTagKJS();
        return s;
    }

    public ItemStackJS withNBT(class_2487 nbt) {
        class_1799 is = this.stack.method_7972();
        if (is.method_7969() == null) {
            is.method_7980(nbt);
        } else if (nbt != null && !nbt.method_33133()) {
            for (String key : nbt.method_10541()) {
                is.method_7969().method_10566(key, nbt.method_10580(key));
            }
        }
        return new ItemStackJS(is).withChance(this.getChance());
    }

    public boolean hasChance() {
        return !Double.isNaN(this.chance);
    }

    public void removeChance() {
        this.setChance(Double.NaN);
    }

    public void setChance(double c) {
        this.chance = c;
    }

    public double getChance() {
        return this.chance;
    }

    public final ItemStackJS withChance(double c) {
        if (Double.isNaN(this.chance) && Double.isNaN(c) || this.chance == c) {
            return this;
        }
        ItemStackJS is = this.copy();
        is.setChance(c);
        return is;
    }

    public Text getName() {
        return Text.of(this.getItemStack().method_7964());
    }

    public ItemStackJS withName(@Nullable class_2561 displayName) {
        class_1799 is = this.stack.method_7972();
        if (displayName != null) {
            is.method_7977(displayName);
        } else {
            is.method_7925();
        }
        return new ItemStackJS(is);
    }

    public String toString() {
        boolean hasChanceOrNbt;
        StringBuilder builder = new StringBuilder();
        int count = this.getCount();
        boolean bl = hasChanceOrNbt = this.hasChance() || this.hasNBT();
        if (count > 1 && !hasChanceOrNbt) {
            builder.append('\'');
            builder.append(count);
            builder.append("x ");
            builder.append(this.getId());
            builder.append('\'');
        } else if (hasChanceOrNbt) {
            builder.append("Item.of('");
            builder.append(this.getId());
            builder.append('\'');
            ArrayList<Pair> enchants = null;
            if (count > 1) {
                builder.append(", ");
                builder.append(count);
            }
            if (this.hasNBT()) {
                class_2487 t = this.getNbt();
                if (t != null && !t.method_33133()) {
                    String key;
                    String string = key = this.getItem() == class_1802.field_8598 ? "StoredEnchantments" : "Enchantments";
                    if (t.method_10573(key, 9)) {
                        class_2499 l = t.method_10554(key, 10);
                        enchants = new ArrayList<Pair>(l.size());
                        for (int i = 0; i < l.size(); ++i) {
                            class_2487 t1 = l.method_10602(i);
                            enchants.add(Pair.of((Object)t1.method_10558("id"), (Object)t1.method_10550("lvl")));
                        }
                        t = t.method_10553();
                        t.method_10551(key);
                        if (t.method_33133()) {
                            t = null;
                        }
                    }
                }
                if (t != null) {
                    builder.append(", ");
                    NBTUtils.quoteAndEscapeForJS((StringBuilder)builder, (String)t.toString());
                }
            }
            builder.append(')');
            if (enchants != null) {
                for (Pair e : enchants) {
                    builder.append(".enchant('");
                    builder.append((String)e.getKey());
                    builder.append("', ");
                    builder.append(e.getValue());
                    builder.append(')');
                }
            }
            if (this.hasChance()) {
                builder.append(".withChance(");
                builder.append(this.getChance());
                builder.append(')');
            }
        } else {
            builder.append('\'');
            builder.append(this.getId());
            builder.append('\'');
        }
        return builder.toString();
    }

    @Override
    public boolean test(ItemStackJS other) {
        return this.testVanilla(other.stack);
    }

    @Override
    public boolean testVanilla(class_1799 other) {
        if (this.stack.method_7909() == other.method_7909()) {
            class_2487 nbt = this.stack.method_7969();
            class_2487 nbt2 = other.method_7969();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    @Override
    public boolean testVanillaItem(class_1792 item) {
        return item == this.getItem();
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return Collections.singleton(this);
    }

    @Override
    public Set<class_1792> getVanillaItems() {
        return Collections.singleton(this.getItem());
    }

    @Override
    public ItemStackJS getFirst() {
        return this.copy();
    }

    public int hashCode() {
        return Objects.hash(this.getItem(), this.hasNBT() ? this.getNbt() : Integer.valueOf(0));
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString()));
        }
        if (o instanceof class_1799) {
            class_1799 s = (class_1799)o;
            return !s.method_7960() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return !s.isEmpty() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public boolean strongEquals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString())) && this.getCount() == 1 && !this.hasNBT();
        }
        if (o instanceof class_1799) {
            class_1799 s = (class_1799)o;
            return this.getCount() == s.method_7947() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return this.getCount() == s.getCount() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public MapJS getEnchantments() {
        MapJS map = new MapJS();
        for (Map.Entry entry : class_1890.method_8222((class_1799)this.getItemStack()).entrySet()) {
            class_2960 id = KubeJSRegistries.enchantments().getId((Object)((class_1887)entry.getKey()));
            if (id == null) continue;
            map.put(id.toString(), entry.getValue());
        }
        return map;
    }

    public boolean hasEnchantment(class_1887 enchantment, int level) {
        return class_1890.method_8225((class_1887)enchantment, (class_1799)this.stack) >= level;
    }

    public ItemStackJS enchant(MapJS enchantments) {
        ItemStackJS is = this;
        for (Map.Entry entry : enchantments.entrySet()) {
            Object v;
            class_1887 enchantment = (class_1887)KubeJSRegistries.enchantments().get(UtilsJS.getMCID(entry.getKey()));
            if (enchantment == null || !((v = entry.getValue()) instanceof Number)) continue;
            Number number = (Number)v;
            is = is.enchant(enchantment, number.intValue());
        }
        return is;
    }

    public ItemStackJS enchant(class_1887 enchantment, int level) {
        class_1799 is = this.stack.method_7972();
        if (is.method_7909() == class_1802.field_8598) {
            class_1772.method_7807((class_1799)is, (class_1889)new class_1889(enchantment, level));
        } else {
            is.method_7978(enchantment, level);
        }
        return new ItemStackJS(is).withChance(this.getChance());
    }

    public String getMod() {
        return Registries.getId((Object)this.getItem(), (class_5321)class_2378.field_25108).method_12836();
    }

    public IngredientJS ignoreNBT() {
        return new IgnoreNBTIngredientJS(this);
    }

    public IngredientJS weakNBT() {
        return new WeakNBTIngredientJS(this);
    }

    public boolean areItemsEqual(ItemStackJS other) {
        return this.getItem() == other.getItem();
    }

    public boolean areItemsEqual(class_1799 other) {
        return this.getItem() == other.method_7909();
    }

    public boolean isNBTEqual(ItemStackJS other) {
        if (this.hasNBT() == other.hasNBT()) {
            class_2487 nbt = this.stack.method_7969();
            class_2487 nbt2 = other.getNbt();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    public boolean isNBTEqual(class_1799 other) {
        if (this.hasNBT() == other.method_7985()) {
            class_2487 nbt = this.stack.method_7969();
            class_2487 nbt2 = other.method_7969();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    public float getHarvestSpeed(@Nullable BlockContainerJS block) {
        return this.getItemStack().method_7924(block == null ? class_2246.field_10124.method_9564() : block.getBlockState());
    }

    public float getHarvestSpeed() {
        return this.getHarvestSpeed(null);
    }

    @Override
    public JsonElement toJson() {
        int c = this.getCount();
        if (c == 1) {
            return new DummyItemStackJSIngredient(this).toJson();
        }
        return new IngredientStackJS(new DummyItemStackJSIngredient(this), c).toJson();
    }

    public JsonElement toResultJson() {
        JsonElement e;
        if (RecipeJS.currentRecipe != null && (e = RecipeJS.currentRecipe.serializeItemStack(this)) != null) {
            return e;
        }
        return this.toRawResultJson();
    }

    public JsonElement toRawResultJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.getId());
        json.addProperty("count", (Number)this.getCount());
        class_2487 nbt = this.getNbt();
        if (nbt != null) {
            if (RecipeJS.currentRecipe != null && RecipeJS.currentRecipe.serializeNBTAsJson()) {
                json.add("nbt", TagUtils.toJson((class_2520)nbt));
            } else {
                json.addProperty("nbt", nbt.toString());
            }
        }
        if (this.hasChance()) {
            json.addProperty("chance", (Number)this.getChance());
        }
        return json;
    }

    public class_2487 toNBT() {
        return this.getItemStack().method_7953(new class_2487());
    }

    public void onChanged(@Nullable class_2520 o) {
        if (o == null || o instanceof class_2487) {
            this.stack.method_7980((class_2487)o);
        }
    }

    public String getItemGroup() {
        if (this.getItem().method_7859() == null) {
            return "";
        }
        return this.getItem().method_7859().method_7751();
    }

    @Override
    public Set<String> getItemIds() {
        return Collections.singleton(this.getId());
    }

    @Nullable
    public FluidStackJS getFluidStack() {
        return null;
    }
}

