/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.bindings.RarityWrapper;
import dev.latvian.mods.kubejs.item.FoodBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.type.ArmorItemType;
import dev.latvian.mods.kubejs.item.type.BasicItemType;
import dev.latvian.mods.kubejs.item.type.ItemType;
import dev.latvian.mods.kubejs.util.BuilderBase;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder
extends BuilderBase {
    public static final Map<String, class_1832> TOOL_TIERS = new HashMap<String, class_1832>();
    public static final Map<String, class_1741> ARMOR_TIERS = new HashMap<String, class_1741>();
    public transient ItemType type = BasicItemType.INSTANCE;
    public transient int maxStackSize = 64;
    public transient int maxDamage = 0;
    public transient int burnTime = 0;
    public transient String containerItem = "minecraft:air";
    public transient Function<ItemStackJS, Collection<ItemStackJS>> subtypes = null;
    public transient float miningSpeed = 1.0f;
    public transient Float attackDamage;
    public transient Float attackSpeed;
    public transient RarityWrapper rarity = RarityWrapper.COMMON;
    public transient boolean glow = false;
    public final transient List<class_2561> tooltip = new ArrayList<class_2561>();
    public transient class_1761 group = KubeJS.tab;
    public transient Int2IntOpenHashMap color = new Int2IntOpenHashMap();
    public String texture;
    public String parentModel;
    public transient FoodBuilder foodBuilder;
    public transient class_1832 toolTier;
    public transient float attackDamageBaseline;
    public transient float attackSpeedBaseline;
    public transient class_1741 armorTier;
    public transient class_1792 item;
    public JsonObject modelJson;

    public ItemBuilder(String i) {
        super(i);
        this.color.defaultReturnValue(-1);
        this.texture = "";
        this.parentModel = "";
        this.foodBuilder = null;
        this.toolTier = class_1834.field_8923;
        this.armorTier = class_1740.field_7892;
        this.displayName = "";
        this.modelJson = null;
    }

    @Override
    public String getBuilderType() {
        return "item";
    }

    public ItemBuilder type(ItemType t) {
        this.type = t;
        this.type.applyDefaults(this);
        return this;
    }

    public ItemBuilder tier(String t) {
        if (this.type == BasicItemType.INSTANCE) {
            return this;
        }
        if (this.type instanceof ArmorItemType) {
            this.armorTier = ARMOR_TIERS.getOrDefault(t, (class_1741)class_1740.field_7892);
            return this;
        }
        this.toolTier = TOOL_TIERS.getOrDefault(t, (class_1832)class_1834.field_8923);
        return this;
    }

    public ItemBuilder maxStackSize(int v) {
        this.maxStackSize = v;
        return this;
    }

    public ItemBuilder unstackable() {
        return this.maxStackSize(1);
    }

    public ItemBuilder maxDamage(int v) {
        this.maxDamage = v;
        return this;
    }

    public ItemBuilder burnTime(int v) {
        this.burnTime = v;
        return this;
    }

    public ItemBuilder containerItem(String id) {
        this.containerItem = id;
        return this;
    }

    public ItemBuilder subtypes(Function<ItemStackJS, Collection<ItemStackJS>> fn) {
        this.subtypes = fn;
        return this;
    }

    public ItemBuilder miningSpeed(float f) {
        this.miningSpeed = f;
        ConsoleJS.STARTUP.warn("You should be using a 'pickaxe' or other tool type item if you want to modify mining speed!");
        return this;
    }

    public ItemBuilder attackDamage(float f) {
        this.attackDamage = Float.valueOf(f);
        ConsoleJS.STARTUP.warn("You should be using a 'sword' type item if you want to modify attack damage!");
        return this;
    }

    public ItemBuilder attackSpeed(float f) {
        this.attackSpeed = Float.valueOf(f);
        ConsoleJS.STARTUP.warn("You should be using a 'sword' type item if you want to modify attack speed!");
        return this;
    }

    public ItemBuilder rarity(RarityWrapper v) {
        this.rarity = v;
        return this;
    }

    public ItemBuilder glow(boolean v) {
        this.glow = v;
        return this;
    }

    public ItemBuilder tooltip(class_2561 text) {
        this.tooltip.add(text);
        return this;
    }

    public ItemBuilder group(String g) {
        for (class_1761 ig : class_1761.field_7921) {
            if (!ig.method_7751().equals(g)) continue;
            this.group = ig;
            return this;
        }
        return this;
    }

    public ItemBuilder color(int index, int c) {
        this.color.put(index, 0xFF000000 | c);
        return this;
    }

    public ItemBuilder texture(String tex) {
        this.texture = tex;
        return this;
    }

    public ItemBuilder parentModel(String m) {
        this.parentModel = m;
        return this;
    }

    public ItemBuilder food(Consumer<FoodBuilder> b) {
        this.foodBuilder = new FoodBuilder();
        b.accept(this.foodBuilder);
        return this;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    @Nullable
    public Float getAttackDamage() {
        return this.attackDamage;
    }

    @Nullable
    public Float getAttackSpeed() {
        return this.attackSpeed;
    }

    public class_1792.class_1793 createItemProperties() {
        class_1792.class_1793 properties = new class_1792.class_1793();
        properties.method_7892(this.group);
        if (this.maxDamage > 0) {
            properties.method_7895(this.maxDamage);
        } else {
            properties.method_7889(this.maxStackSize);
        }
        properties.method_7894(this.rarity.rarity);
        class_1792 item = (class_1792)KubeJSRegistries.items().get(new class_2960(this.containerItem));
        if (item != class_1802.field_8162) {
            properties.method_7896(item);
        }
        if (this.foodBuilder != null) {
            properties.method_19265(this.foodBuilder.build());
        }
        return properties;
    }

    static {
        for (class_1834 class_18342 : class_1834.values()) {
            TOOL_TIERS.put(class_18342.toString().toLowerCase(), (class_1832)class_18342);
        }
        for (class_1834 class_18343 : class_1740.values()) {
            ARMOR_TIERS.put(class_18343.toString().toLowerCase(), (class_1741)class_18343);
        }
    }
}

