/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.architectury.event.EventResult;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.integration.rei.AddREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.HideREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.InformationREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.RemoveREICategoryEventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;

public class KubeJSREIPlugin
implements REIClientPlugin {
    private final Set<CategoryIdentifier<?>> categoriesRemoved = new HashSet();

    public double getPriority() {
        return 1.0E7;
    }

    public void registerEntries(EntryRegistry registry) {
        Function<Object, Collection<EntryStack<?>>> itemSerializer = o -> EntryIngredients.ofItemStacks((Collection)CollectionUtils.map(IngredientJS.of(o).getStacks(), ItemStackJS::getItemStack));
        Function<Object, Collection<EntryStack<?>>> fluidSerializer = o -> EntryIngredients.of((FluidStack)FluidStackJS.of(o).getFluidStack());
        new HideREIEventJS(registry, VanillaEntryTypes.ITEM, itemSerializer).post(ScriptType.CLIENT, "rei.hide.items");
        new HideREIEventJS(registry, VanillaEntryTypes.FLUID, fluidSerializer).post(ScriptType.CLIENT, "rei.hide.fluids");
        new AddREIEventJS(registry, itemSerializer).post(ScriptType.CLIENT, "rei.add.items");
        new AddREIEventJS(registry, fluidSerializer).post(ScriptType.CLIENT, "rei.add.fluids");
    }

    public void registerDisplays(DisplayRegistry registry) {
        new InformationREIEventJS().post(ScriptType.CLIENT, "rei.information");
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.registerVisibilityPredicate(category -> this.categoriesRemoved.contains(category.getCategoryIdentifier()) ? EventResult.interruptFalse() : EventResult.pass());
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage == ReloadStage.END) {
            this.categoriesRemoved.clear();
            new RemoveREICategoryEventJS(this.categoriesRemoved).post(ScriptType.CLIENT, "rei.remove.categories");
        }
    }
}

