/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.fabric.techreborn;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import net.minecraft.class_2960;

public class TRRecipeJS
extends RecipeJS {
    @Override
    public void create(ListJS args) {
        this.outputItems.addAll(this.parseResultItemList(args.get(0)));
        this.inputItems.addAll(this.parseIngredientItemList(args.get(1)));
        this.json.addProperty("power", (Number)2);
        this.json.addProperty("time", (Number)200);
        if (this.type.toString().equals("techreborn:blast_furnace")) {
            this.json.addProperty("heat", (Number)1500);
        }
    }

    @Override
    public void deserialize() {
        this.outputItems.addAll(this.parseResultItemList(this.json.get("results")));
        this.inputItems.addAll(this.parseIngredientItemList(this.json.get("ingredients")));
    }

    public TRRecipeJS power(int i) {
        this.json.addProperty("power", (Number)i);
        this.save();
        return this;
    }

    public TRRecipeJS time(int i) {
        this.json.addProperty("time", (Number)i);
        this.save();
        return this;
    }

    public TRRecipeJS heat(int i) {
        this.json.addProperty("heat", (Number)i);
        this.save();
        return this;
    }

    @Override
    public void serialize() {
        JsonArray array;
        if (this.serializeOutputs) {
            array = new JsonArray();
            for (ItemStackJS out : this.outputItems) {
                array.add(out.toResultJson());
            }
            this.json.add("results", (JsonElement)array);
        }
        if (this.serializeInputs) {
            array = new JsonArray();
            for (IngredientJS in : this.inputItems) {
                array.add(in.toJson());
            }
            this.json.add("ingredients", (JsonElement)array);
        }
    }

    @Override
    public IngredientJS parseIngredientItem(Object o, String key) {
        if (o instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)o;
            class_2960 type = DummyRebornIngredient.STACK_RECIPE_TYPE;
            if (jsonObj.has("fluid")) {
                type = DummyRebornIngredient.FLUID_RECIPE_TYPE;
            } else if (jsonObj.has("tag")) {
                type = DummyRebornIngredient.TAG_RECIPE_TYPE;
            } else if (jsonObj.has("wrapped")) {
                type = DummyRebornIngredient.WRAPPED_RECIPE_TYPE;
            }
            if (jsonObj.has("type")) {
                type = new class_2960(jsonObj.get("type").getAsString());
            }
            if (!type.equals((Object)DummyRebornIngredient.STACK_RECIPE_TYPE) && !type.equals((Object)DummyRebornIngredient.TAG_RECIPE_TYPE)) {
                return new DummyRebornIngredient(type, jsonObj);
            }
        }
        return super.parseIngredientItem(o, key);
    }

    @Override
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        JsonObject o = in.ingredient.toJson().getAsJsonObject();
        o.addProperty("count", (Number)in.getCount());
        return o;
    }

    private static class DummyRebornIngredient
    implements IngredientJS {
        public static final class_2960 STACK_RECIPE_TYPE = new class_2960("reborncore", "stack");
        public static final class_2960 FLUID_RECIPE_TYPE = new class_2960("reborncore", "fluid");
        public static final class_2960 TAG_RECIPE_TYPE = new class_2960("reborncore", "tag");
        public static final class_2960 WRAPPED_RECIPE_TYPE = new class_2960("reborncore", "wrapped");
        public final class_2960 type;
        public final JsonObject json;

        public DummyRebornIngredient(class_2960 t, JsonObject o) {
            this.type = t;
            this.json = o;
        }

        @Override
        public boolean test(ItemStackJS stack) {
            return false;
        }

        @Override
        public JsonElement toJson() {
            return this.json;
        }
    }
}

