/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.core.MinecraftServerKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.mods.kubejs.net.PaintMessage;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.CustomCommandEventJS;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.stages.Stages;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3097;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3494;
import net.minecraft.class_5219;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5414;
import net.minecraft.server.MinecraftServer;

public class KubeJSCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kubejs").then(class_2170.method_9247((String)"custom_command").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.customCommand((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id")))))).then(class_2170.method_9247((String)"hand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5808)))).then(class_2170.method_9247((String)"offhand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5810)))).then(class_2170.method_9247((String)"inventory").executes(context -> KubeJSCommands.inventory(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"hotbar").executes(context -> KubeJSCommands.hotbar(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"errors").executes(context -> KubeJSCommands.errors((class_2168)context.getSource())))).then(class_2170.method_9247((String)"warnings").executes(context -> KubeJSCommands.warnings((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"startup_scripts").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.reloadStartup((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server_scripts").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.reloadServer((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"client_scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.export((class_2168)context.getSource())))).then(class_2170.method_9247((String)"list_tag").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"tag", (ArgumentType)class_2232.method_9441()).executes(context -> KubeJSCommands.tagObjects(((class_2168)context.getSource()).method_9207(), Tags.items(), class_2378.field_25108, class_2232.method_9443((CommandContext)context, (String)"tag")))).then(class_2170.method_9247((String)"item").executes(context -> KubeJSCommands.tagObjects(((class_2168)context.getSource()).method_9207(), Tags.items(), class_2378.field_25108, class_2232.method_9443((CommandContext)context, (String)"tag"))))).then(class_2170.method_9247((String)"block").executes(context -> KubeJSCommands.tagObjects(((class_2168)context.getSource()).method_9207(), Tags.blocks(), class_2378.field_25105, class_2232.method_9443((CommandContext)context, (String)"tag"))))).then(class_2170.method_9247((String)"fluid").executes(context -> KubeJSCommands.tagObjects(((class_2168)context.getSource()).method_9207(), Tags.fluids(), class_2378.field_25103, class_2232.method_9443((CommandContext)context, (String)"tag"))))).then(class_2170.method_9247((String)"entity_type").executes(context -> KubeJSCommands.tagObjects(((class_2168)context.getSource()).method_9207(), Tags.entityTypes(), class_2378.field_25107, class_2232.method_9443((CommandContext)context, (String)"tag"))))))).then(class_2170.method_9247((String)"wiki").executes(context -> KubeJSCommands.wiki((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stages").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.addStage((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.removeStage((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> KubeJSCommands.clearStages((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> KubeJSCommands.listStages((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))))).then(class_2170.method_9247((String)"painter").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"object", (ArgumentType)class_2179.method_9284()).executes(context -> KubeJSCommands.painter((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), class_2179.method_9285((CommandContext)context, (String)"object")))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"kjs_hand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5808)));
    }

    private static class_2561 copy(String s, class_124 col, String info) {
        class_2585 component = new class_2585("- ");
        component.method_10862(component.method_10866().method_27703(class_5251.method_27718((class_124)class_124.field_1080)));
        component.method_10862(component.method_10866().method_10958(new class_2558(class_2558.class_2559.field_21462, s)));
        component.method_10862(component.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(info + " (Click to copy)"))));
        component.method_10852((class_2561)new class_2585(s).method_27692(col));
        return component;
    }

    private static int customCommand(class_2168 source, String id) {
        new CustomCommandEventJS((class_1937)source.method_9225(), source.method_9228(), new class_2338(source.method_9222()), id).post(ScriptType.SERVER, "server.custom_command", id);
        return 1;
    }

    private static int hand(class_3222 player, class_1268 hand) {
        player.method_9203((class_2561)new class_2585("Item in hand:"), class_156.field_25140);
        ItemStackJS stack = ItemStackJS.of(player.method_5998(hand));
        player.method_9203(KubeJSCommands.copy(stack.toString(), class_124.field_1060, "Item ID"), class_156.field_25140);
        ArrayList<class_2960> tags = new ArrayList<class_2960>(Tags.byItem(stack.getItem()));
        tags.sort(null);
        for (class_2960 id : tags) {
            player.method_9203(KubeJSCommands.copy("'#" + id + "'", class_124.field_1054, "Item Tag [" + TagIngredientJS.createTag(id.toString()).getStacks().size() + " items]"), class_156.field_25140);
        }
        player.method_9203(KubeJSCommands.copy("'@" + stack.getMod() + "'", class_124.field_1075, "Mod [" + new ModIngredientJS(stack.getMod()).getStacks().size() + " items]"), class_156.field_25140);
        if (stack.getItem().method_7859() != null) {
            player.method_9203(KubeJSCommands.copy("'%" + stack.getItemGroup() + "'", class_124.field_1076, "Item Group [" + new GroupIngredientJS(stack.getItem().method_7859()).getStacks().size() + " items]"), class_156.field_25140);
        }
        return 1;
    }

    private static int inventory(class_3222 player) {
        return KubeJSCommands.dump((List<class_1799>)player.method_31548().field_7547, player, "Inventory");
    }

    private static int hotbar(class_3222 player) {
        return KubeJSCommands.dump(player.method_31548().field_7547.subList(0, 9), player, "Hotbar");
    }

    private static int dump(List<class_1799> stacks, class_3222 player, String name) {
        ArrayList<ItemStackJS> stackList = new ArrayList<ItemStackJS>(stacks.size());
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            stackList.add(ItemStackJS.of(stack));
        }
        String dump = ((Object)stackList).toString();
        player.method_9203(KubeJSCommands.copy(dump, class_124.field_1068, name + " Item List"), class_156.field_25140);
        return 1;
    }

    private static int errors(class_2168 source) {
        if (ScriptType.SERVER.errors.isEmpty()) {
            source.method_9226((class_2561)new class_2585("No errors found!").method_27692(class_124.field_1060), false);
            if (!ScriptType.SERVER.warnings.isEmpty()) {
                source.method_9226((class_2561)new class_2585(ScriptType.SERVER.warnings.size() + " warnings found. Run /kubejs warnings to see them").method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920))), false);
            }
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.errors.size(); ++i) {
            source.method_9226((class_2561)new class_2585("[" + (i + 1) + "] " + ScriptType.SERVER.errors.get(i)).method_27692(class_124.field_1061), false);
        }
        source.method_9226((class_2561)new class_2585("More info in 'logs/kubejs/server.txt'").method_27692(class_124.field_1079), false);
        if (!ScriptType.SERVER.warnings.isEmpty()) {
            source.method_9226((class_2561)new class_2585(ScriptType.SERVER.warnings.size() + " warnings found. Run '/kubejs warnings' to see them").method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920))), false);
        }
        return 1;
    }

    private static int warnings(class_2168 source) {
        if (ScriptType.SERVER.warnings.isEmpty()) {
            source.method_9226((class_2561)new class_2585("No warnings found!").method_27692(class_124.field_1060), false);
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.warnings.size(); ++i) {
            source.method_9226((class_2561)new class_2585("[" + (i + 1) + "] " + ScriptType.SERVER.warnings.get(i)).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920))), false);
        }
        return 1;
    }

    private static int reloadStartup(class_2168 source) {
        KubeJS.startupScriptManager.unload();
        KubeJS.startupScriptManager.loadFromDirectory();
        KubeJS.startupScriptManager.load();
        UtilsJS.postModificationEvents();
        source.method_9226((class_2561)new class_2585("Done!"), false);
        return 1;
    }

    private static int reloadServer(class_2168 source) {
        ServerScriptManager.instance.reloadScriptManager(((MinecraftServerKJS)source.method_9211()).getServerResourcesKJS().method_29474());
        UtilsJS.postModificationEvents();
        source.method_9226((class_2561)new class_2585("Done! To reload recipes, tags, loot tables and other datapack things, run /reload"), false);
        return 1;
    }

    private static int reloadClient(class_2168 source) {
        KubeJS.PROXY.reloadClientInternal();
        source.method_9226((class_2561)new class_2585("Done! To reload textures, models and other assets, press F3 + T"), false);
        return 1;
    }

    private static int reloadTextures(class_2168 source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(class_2168 source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(class_2168 source) {
        if (ServerSettings.dataExport != null) {
            return 0;
        }
        ServerSettings.source = source;
        ServerSettings.dataExport = new JsonObject();
        source.method_9226((class_2561)new class_2585("Reloading server and exporting data..."), false);
        MinecraftServer minecraftServer = source.method_9211();
        class_3283 packRepository = minecraftServer.method_3836();
        class_5219 worldData = minecraftServer.method_27728();
        Collection collection = packRepository.method_29210();
        packRepository.method_14445();
        ArrayList collection2 = Lists.newArrayList((Iterable)collection);
        List collection3 = worldData.method_29589().method_29550();
        for (String string : packRepository.method_29206()) {
            if (collection3.contains(string) || collection2.contains(string)) continue;
            collection2.add(string);
        }
        class_3097.method_29480((Collection)collection2, (class_2168)source);
        return 1;
    }

    private static int outputRecipes(class_3222 player) {
        player.method_9203((class_2561)new class_2585("WIP!"), class_156.field_25140);
        return 1;
    }

    private static int inputRecipes(class_3222 player) {
        player.method_9203((class_2561)new class_2585("WIP!"), class_156.field_25140);
        return 1;
    }

    private static int checkRecipeConflicts(class_3222 player) {
        player.method_9203((class_2561)new class_2585("WIP!"), class_156.field_25140);
        return 1;
    }

    private static <T> int tagObjects(class_3222 player, class_5414<T> collection, class_5321<class_2378<T>> reg, class_2960 t) {
        class_3494 tag = collection.method_30210(t);
        if (tag == null || tag.method_15138().isEmpty()) {
            player.method_9203((class_2561)new class_2585("Tag not found!"), class_156.field_25140);
            return 0;
        }
        player.method_9203((class_2561)new class_2585(t + ":"), class_156.field_25140);
        for (Object item : tag.method_15138()) {
            class_2960 id = Registries.getId(item, reg);
            if (id == null) {
                player.method_9203((class_2561)new class_2585("- " + item), class_156.field_25140);
                continue;
            }
            player.method_9203((class_2561)new class_2585("- " + id), class_156.field_25140);
        }
        player.method_9203((class_2561)new class_2585(tag.method_15138().size() + " elements"), class_156.field_25140);
        return 1;
    }

    private static int wiki(class_2168 source) {
        source.method_9226((class_2561)new class_2585("Click here to open the Wiki").method_27692(class_124.field_1078).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://kubejs.com/"))), false);
        return 1;
    }

    private static int addStage(class_2168 source, Collection<class_3222> players, String stage) {
        for (class_3222 p : players) {
            if (!Stages.get((class_1657)p).add(stage)) continue;
            source.method_9226((class_2561)new class_2585("Added '" + stage + "' stage for " + p.method_5820()), false);
        }
        return 1;
    }

    private static int removeStage(class_2168 source, Collection<class_3222> players, String stage) {
        for (class_3222 p : players) {
            if (!Stages.get((class_1657)p).remove(stage)) continue;
            source.method_9226((class_2561)new class_2585("Removed '" + stage + "' stage for " + p.method_5820()), false);
        }
        return 1;
    }

    private static int clearStages(class_2168 source, Collection<class_3222> players) {
        for (class_3222 p : players) {
            if (!Stages.get((class_1657)p).clear()) continue;
            source.method_9226((class_2561)new class_2585("Cleared stages for " + p.method_5820()), false);
        }
        return 1;
    }

    private static int listStages(class_2168 source, Collection<class_3222> players) {
        for (class_3222 p : players) {
            source.method_9226((class_2561)new class_2585(p.method_5820() + " stages:"), false);
            Stages.get((class_1657)p).getAll().stream().sorted().forEach(s -> source.method_9226((class_2561)new class_2585("- " + s), false));
        }
        return 1;
    }

    private static int painter(class_2168 source, Collection<class_3222> players, class_2487 object) {
        new PaintMessage(object).sendTo(players);
        return 1;
    }
}

