/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter;

import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.PainterObject;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.kubejs.client.painter.world.WorldPainterObject;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class PainterObjectStorage {
    private static final ScreenPainterObject[] NO_SCREEN_OBJECTS = new ScreenPainterObject[0];
    private static final WorldPainterObject[] NO_WORLD_OBJECTS = new WorldPainterObject[0];
    private final Map<String, PainterObject> objects = new LinkedHashMap<String, PainterObject>();

    @Nullable
    public PainterObject getObject(String key) {
        return this.objects.get(key);
    }

    public Collection<PainterObject> getObjects() {
        return this.objects.isEmpty() ? Collections.emptyList() : this.objects.values();
    }

    public void handle(class_2487 root) {
        for (String key : root.method_10541()) {
            class_2487 tag = root.method_10562(key);
            if (key.equals("*")) {
                if (tag.method_10577("remove")) {
                    this.objects.clear();
                    continue;
                }
                for (PainterObject o : this.objects.values()) {
                    o.update(tag);
                }
                continue;
            }
            if (key.equals("$")) {
                for (String k : tag.method_10541()) {
                    if (tag.method_10573(k, 99)) {
                        Painter.INSTANCE.setVariable(k, (Unit)FixedUnit.of((float)tag.method_10583(k)));
                        continue;
                    }
                    Painter.INSTANCE.setVariable(k, Painter.INSTANCE.unitStorage.parse(tag.method_10558(k)));
                }
                continue;
            }
            PainterObject o = this.objects.get(key);
            if (o != null) {
                o.update(tag);
                continue;
            }
            if (key.indexOf(32) != -1) {
                ConsoleJS.CLIENT.error("Painter id can't contain spaces!");
                continue;
            }
            String type = tag.method_10558("type");
            PainterObject o1 = Painter.INSTANCE.make(type);
            if (o1 != null) {
                o1.id = key;
                o1.parent = this;
                o1.update(tag);
                this.objects.put(key, o1);
                continue;
            }
            ConsoleJS.CLIENT.error("Unknown Painter type: " + type);
        }
    }

    public void clear() {
        this.objects.clear();
    }

    public ScreenPainterObject[] createScreenObjects() {
        return this.objects.isEmpty() ? NO_SCREEN_OBJECTS : (ScreenPainterObject[])this.objects.values().stream().filter(o -> o instanceof ScreenPainterObject).map(o -> (ScreenPainterObject)o).toArray(ScreenPainterObject[]::new);
    }

    public WorldPainterObject[] createWorldObjects() {
        return this.objects.isEmpty() ? NO_WORLD_OBJECTS : (WorldPainterObject[])this.objects.values().stream().filter(o -> o instanceof WorldPainterObject).map(o -> (WorldPainterObject)o).toArray(WorldPainterObject[]::new);
    }

    public void remove(String id) {
        this.objects.remove(id);
    }
}

