/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.architectury.hooks.PackRepositoryHooks;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSCommon;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.client.ClientEventJS;
import dev.latvian.mods.kubejs.client.ClientWrapper;
import dev.latvian.mods.kubejs.client.KubeJSClientEventHandler;
import dev.latvian.mods.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.level.ClientLevelJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.net.NetworkEventJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3302;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class KubeJSClient
extends KubeJSCommon {
    @Override
    public void init() {
        if (class_310.method_1551() == null) {
            return;
        }
        KubeJSClient.reloadClientScripts();
        new KubeJSClientEventHandler().init();
        class_3283 list = class_310.method_1551().method_1520();
        PackRepositoryHooks.addSource((class_3283)list, (class_3285)new KubeJSResourcePackFinder());
        this.setup();
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::clientInit);
    }

    @Override
    public void reloadClientInternal() {
        KubeJSClient.reloadClientScripts();
    }

    public static void reloadClientScripts() {
        KubeJSClientEventHandler.staticItemTooltips = null;
        KubeJS.clientScriptManager.unload();
        KubeJS.clientScriptManager.loadFromDirectory();
        KubeJS.clientScriptManager.load();
    }

    public static void copyDefaultOptionsFile(File optionsFile) {
        Path defOptions;
        if (!optionsFile.exists() && Files.exists(defOptions = KubeJSPaths.CONFIG.resolve("defaultoptions.txt"), new LinkOption[0])) {
            try {
                KubeJS.LOGGER.info("Loaded default options from kubejs/config/defaultoptions.txt");
                Files.copy(defOptions, optionsFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void clientBindings(BindingsEvent event) {
        event.add("Client", new ClientWrapper());
        event.add("Painter", Painter.INSTANCE);
    }

    @Override
    public void clientTypeWrappers(TypeWrappers typeWrappers) {
        typeWrappers.register(Unit.class, o -> {
            if (o instanceof Unit) {
                Unit unit = (Unit)o;
                return unit;
            }
            if (o instanceof Number) {
                Number number = (Number)o;
                return FixedUnit.of((float)number.floatValue());
            }
            if (o instanceof String) {
                return Painter.INSTANCE.unitStorage.parse(o.toString());
            }
            return FixedUnit.ZERO;
        });
    }

    private void setup() {
        new ClientEventJS().post("client.init");
    }

    @Override
    public void handleDataToClientPacket(String channel, @Nullable class_2487 data) {
        new NetworkEventJS((class_1657)class_310.method_1551().field_1724, channel, data).post("player.data_from_server", channel);
    }

    @Override
    @Nullable
    public class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Override
    public void paint(class_2487 tag) {
        Painter.INSTANCE.paint(tag);
    }

    @Override
    public LevelJS getClientLevel() {
        return ClientLevelJS.getInstance();
    }

    private void reload(class_3302 listener) {
        long start = System.currentTimeMillis();
        class_310 mc = class_310.method_1551();
        listener.method_25931(CompletableFuture::completedFuture, mc.method_1478(), (class_3695)class_3694.field_16280, (class_3695)class_3694.field_16280, (Executor)class_156.method_18349(), (Executor)mc).thenAccept(unused -> mc.field_1724.method_9203((class_2561)new class_2585("Done! You still may have to reload all assets with F3 + T"), class_156.field_25140));
    }

    @Override
    public void reloadTextures() {
        this.reload((class_3302)class_310.method_1551().method_1531());
    }

    @Override
    public void reloadLang() {
        this.reload((class_3302)class_310.method_1551().method_1526());
    }

    @Override
    public boolean isClientButNotSelf(class_1657 player) {
        return player instanceof class_742 && !(player instanceof class_746);
    }
}

