/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.custom.BlockType;
import dev.latvian.mods.kubejs.block.custom.CustomBlockJS;
import dev.latvian.mods.kubejs.block.custom.FenceBlockJS;
import dev.latvian.mods.kubejs.block.custom.FenceGateBlockJS;
import dev.latvian.mods.kubejs.block.custom.SlabBlockJS;
import dev.latvian.mods.kubejs.block.custom.StairBlockJS;
import dev.latvian.mods.kubejs.block.custom.StoneButtonBlockJS;
import dev.latvian.mods.kubejs.block.custom.StonePressurePlateBlockJS;
import dev.latvian.mods.kubejs.block.custom.WallBlockJS;
import dev.latvian.mods.kubejs.block.custom.WoodenButtonBlockJS;
import dev.latvian.mods.kubejs.block.custom.WoodenPressurePlateBlockJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4970;

public class ShapedBlockType
extends BlockType {
    public static final ShapedBlockType SLAB = new ShapedBlockType("slab", SlabBlockJS::new, "_slab");
    public static final ShapedBlockType STAIRS = new ShapedBlockType("stairs", StairBlockJS::new, "_stairs");
    public static final ShapedBlockType FENCE = new ShapedBlockType("fence", FenceBlockJS::new, "_fence");
    public static final ShapedBlockType FENCE_GATE = new ShapedBlockType("fence_gate", FenceGateBlockJS::new, "_fence_gate");
    public static final ShapedBlockType WALL = new ShapedBlockType("wall", WallBlockJS::new, "_wall");
    public static final ShapedBlockType WOODEN_PRESSURE_PLATE = new ShapedBlockType("wooden_pressure_plate", WoodenPressurePlateBlockJS::new, "_wooden_pressure_plate", "_pressure_plate");
    public static final ShapedBlockType STONE_PRESSURE_PLATE = new ShapedBlockType("stone_pressure_plate", StonePressurePlateBlockJS::new, "_stone_pressure_plate", "_pressure_plate");
    public static final ShapedBlockType WOODEN_BUTTON = new ShapedBlockType("wooden_button", WoodenButtonBlockJS::new, "_wooden_button", "_button");
    public static final ShapedBlockType STONE_BUTTON = new ShapedBlockType("stone_button", StoneButtonBlockJS::new, "_stone_button", "_button");
    private final Function<class_4970.class_2251, class_2248> factory;
    private final String[] suffixes;

    public ShapedBlockType(String s, Function<class_4970.class_2251, class_2248> f, String ... su) {
        super(s);
        this.factory = f;
        this.suffixes = su;
    }

    @Override
    public class_2248 createBlock(BlockBuilder builder) {
        return this.factory.apply(builder.createProperties());
    }

    @Override
    public void applyDefaults(BlockBuilder builder) {
        builder.notSolid();
        builder.waterlogged();
        builder.texture("texture", "kubejs:block/detector");
        for (String s : this.suffixes) {
            if (!builder.id.method_12832().endsWith(s)) continue;
            builder.texture("texture", builder.id.method_12836() + ":block/" + builder.id.method_12832().substring(0, builder.id.method_12832().length() - s.length()));
            break;
        }
        if (this == SLAB) {
            builder.tagBoth(class_3481.field_15469.method_26791());
        } else if (this == STAIRS) {
            builder.tagBoth(class_3481.field_15459.method_26791());
        } else if (this == FENCE) {
            builder.tagBoth(class_3481.field_16584.method_26791());
            if (Platform.isForge()) {
                builder.tagBoth(new class_2960("forge:fences"));
            }
        } else if (this == FENCE_GATE) {
            builder.tagBoth(class_3481.field_25147.method_26791());
            if (Platform.isForge()) {
                builder.tagBoth(new class_2960("forge:fence_gates"));
            }
        } else if (this == WALL) {
            builder.tagBoth(class_3481.field_15504.method_26791());
        } else if (this == WOODEN_PRESSURE_PLATE) {
            builder.noCollission();
            builder.tagBoth(class_3481.field_24076.method_26791());
            builder.tagBoth(class_3481.field_15477.method_26791());
        } else if (this == STONE_PRESSURE_PLATE) {
            builder.noCollission();
            builder.tagBoth(class_3481.field_24076.method_26791());
            builder.tagBoth(class_3481.field_24077.method_26791());
        } else if (this == WOODEN_BUTTON) {
            builder.noCollission();
            builder.tagBoth(class_3481.field_15493.method_26791());
            builder.tagBoth(class_3481.field_15499.method_26791());
        } else if (this == STONE_BUTTON) {
            builder.noCollission();
            builder.tagBoth(class_3481.field_15493.method_26791());
        }
    }

    @Override
    public void generateAssets(BlockBuilder builder, AssetJsonGenerator generator) {
        class_2248 class_22482 = builder.block;
        if (class_22482 instanceof CustomBlockJS) {
            CustomBlockJS custom = (CustomBlockJS)class_22482;
            custom.generateAssets(builder, generator);
        } else {
            super.generateAssets(builder, generator);
        }
    }
}

