/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2960;

public abstract class BlockType {
    public final String name;

    public BlockType(String n) {
        this.name = n;
    }

    public abstract class_2248 createBlock(BlockBuilder var1);

    public void applyDefaults(BlockBuilder builder) {
    }

    public void generateAssets(BlockBuilder b, AssetJsonGenerator generator) {
        if (b.blockstateJson != null) {
            generator.json(b.newID("blockstates/", ""), (JsonElement)b.blockstateJson);
        } else {
            generator.blockState(b.id, bs -> bs.variant("", (String)(b.model.isEmpty() ? b.id.method_12836() + ":block/" + b.id.method_12832() : b.model)));
        }
        if (b.modelJson != null) {
            generator.json(b.newID("models/block/", ""), (JsonElement)b.modelJson);
        } else {
            generator.blockModel(b.id, m -> {
                String particle = b.textures.get("particle").getAsString();
                if (this.areAllTexturesEqual(b.textures, particle)) {
                    m.parent("minecraft:block/cube_all");
                    m.texture("all", particle);
                } else {
                    m.parent("block/cube");
                    m.textures(b.textures);
                }
                if (!b.color.isEmpty() || !b.customShape.isEmpty()) {
                    ArrayList<class_238> boxes = new ArrayList<class_238>(b.customShape);
                    if (boxes.isEmpty()) {
                        boxes.add(new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
                    }
                    for (class_238 box : boxes) {
                        m.element(e -> {
                            e.box(box);
                            for (class_2350 direction : class_2350.values()) {
                                e.face(direction, face -> {
                                    face.tex("#" + direction.method_15434());
                                    face.cull();
                                    if (!b.color.isEmpty()) {
                                        face.tintindex(0);
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
        if (b.itemBuilder != null) {
            generator.itemModel(b.itemBuilder.id, m -> {
                if (!b.model.isEmpty()) {
                    m.parent(b.model);
                } else {
                    m.parent(b.newID("block/", "").toString());
                }
            });
        }
    }

    public Map<class_2960, JsonObject> generateBlockModels(BlockBuilder builder) {
        HashMap<class_2960, JsonObject> map = new HashMap<class_2960, JsonObject>();
        if (builder.modelJson != null) {
            map.put(builder.newID("models/block/", ""), builder.modelJson);
        } else {
            JsonObject modelJson = new JsonObject();
            String particle = builder.textures.get("particle").getAsString();
            if (this.areAllTexturesEqual(builder.textures, particle)) {
                modelJson.addProperty("parent", "block/cube_all");
                JsonObject textures = new JsonObject();
                textures.addProperty("all", particle);
                modelJson.add("textures", (JsonElement)textures);
            } else {
                modelJson.addProperty("parent", "block/cube");
                modelJson.add("textures", (JsonElement)builder.textures);
            }
            if (!builder.color.isEmpty()) {
                JsonObject cube = new JsonObject();
                JsonArray from = new JsonArray();
                from.add((Number)0);
                from.add((Number)0);
                from.add((Number)0);
                cube.add("from", (JsonElement)from);
                JsonArray to = new JsonArray();
                to.add((Number)16);
                to.add((Number)16);
                to.add((Number)16);
                cube.add("to", (JsonElement)to);
                JsonObject faces = new JsonObject();
                for (class_2350 direction : class_2350.values()) {
                    JsonObject f = new JsonObject();
                    f.addProperty("texture", "#" + direction.method_15434());
                    f.addProperty("cullface", direction.method_15434());
                    f.addProperty("tintindex", (Number)0);
                    faces.add(direction.method_15434(), (JsonElement)f);
                }
                cube.add("faces", (JsonElement)faces);
                JsonArray elements = new JsonArray();
                elements.add((JsonElement)cube);
                modelJson.add("elements", (JsonElement)elements);
            }
            map.put(builder.newID("models/block/", ""), modelJson);
        }
        return map;
    }

    private boolean areAllTexturesEqual(JsonObject tex, String t) {
        for (class_2350 direction : class_2350.values()) {
            if (tex.get(direction.method_15434()).getAsString().equals(t)) continue;
            return false;
        }
        return true;
    }

    public void generateData(BlockBuilder builder, DataJsonGenerator generator) {
    }
}

