/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.utils.value.IntValue;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.block.BlockBreakEventJS;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockLeftClickEventJS;
import dev.latvian.mods.kubejs.block.BlockPlaceEventJS;
import dev.latvian.mods.kubejs.block.BlockRightClickEventJS;
import dev.latvian.mods.kubejs.block.DetectorBlock;
import dev.latvian.mods.kubejs.block.DetectorInstance;
import dev.latvian.mods.kubejs.block.fabric.KubeJSBlockEventHandlerImpl;
import dev.latvian.mods.kubejs.core.BlockKJS;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import java.util.Iterator;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class KubeJSBlockEventHandler {
    public static void init() {
        if (!CommonProperties.get().serverOnly) {
            KubeJSBlockEventHandler.registry();
        }
        InteractionEvent.RIGHT_CLICK_BLOCK.register(KubeJSBlockEventHandler::rightClick);
        InteractionEvent.LEFT_CLICK_BLOCK.register(KubeJSBlockEventHandler::leftClick);
        BlockEvent.BREAK.register(KubeJSBlockEventHandler::blockBreak);
        BlockEvent.PLACE.register(KubeJSBlockEventHandler::blockPlace);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_2404 buildFluidBlock(FluidBuilder builder, class_4970.class_2251 properties) {
        void var1_1;
        return KubeJSBlockEventHandlerImpl.buildFluidBlock(builder, (class_4970.class_2251)var1_1);
    }

    private static void registry() {
        Iterator<Object> iterator = KubeJSObjects.BLOCKS.values().iterator();
        while (iterator.hasNext()) {
            BlockBuilder blockBuilder;
            BlockBuilder.current = blockBuilder = iterator.next();
            blockBuilder.block = blockBuilder.type.createBlock(blockBuilder);
            class_2248 class_22482 = blockBuilder.block;
            if (class_22482 instanceof BlockKJS) {
                BlockKJS blockKJS = (BlockKJS)class_22482;
                blockKJS.setBlockBuilderKJS(blockBuilder);
            }
            KubeJSRegistries.blocks().register(blockBuilder.id, () -> builder.block);
        }
        BlockBuilder.current = null;
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.block = KubeJSBlockEventHandler.buildFluidBlock(fluidBuilder, class_4970.class_2251.method_9637((class_3614)class_3614.field_15920).method_9634().method_9632(100.0f).method_16229());
            KubeJSRegistries.blocks().register(fluidBuilder.id, () -> builder.block);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            detectorInstance.block = KubeJSRegistries.blocks().register(new class_2960("kubejs", "detector_" + detectorInstance.id), () -> new DetectorBlock(detector.id));
        }
    }

    private static EventResult rightClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (player != null && player.field_6002 != null && !player.method_7357().method_7904(player.method_5998(hand).method_7909()) && new BlockRightClickEventJS(player, hand, pos, direction).post("block.right_click")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult leftClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (player != null && player.field_6002 != null && new BlockLeftClickEventJS(player, hand, pos, direction).post("block.left_click")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult blockBreak(class_1937 level, class_2338 pos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        if (player != null && player.field_6002 != null && new BlockBreakEventJS(player, level, pos, state, xp).post("block.break")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult blockPlace(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1297 placer) {
        if (level != null && (placer == null || placer.field_6002 != null) && new BlockPlaceEventJS(placer, level, pos, state).post("block.place")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

