/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import com.google.gson.JsonObject;
import dev.architectury.registry.block.BlockProperties;
import dev.latvian.mods.kubejs.block.BlockItemBuilder;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.block.custom.BasicBlockType;
import dev.latvian.mods.kubejs.block.custom.BlockType;
import dev.latvian.mods.kubejs.loot.LootBuilder;
import dev.latvian.mods.kubejs.util.BuilderBase;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class BlockBuilder
extends BuilderBase {
    public static BlockBuilder current;
    public transient BlockType type = BasicBlockType.INSTANCE;
    public transient MaterialJS material;
    public transient float hardness;
    public transient float resistance;
    public transient float lightLevel;
    public transient boolean opaque;
    public transient boolean fullBlock;
    public transient boolean requiresTool;
    public transient String renderType;
    public transient Int2IntOpenHashMap color;
    public final transient JsonObject textures;
    public transient String model;
    public transient BlockItemBuilder itemBuilder;
    public transient List<class_238> customShape;
    public transient boolean noCollission;
    public transient boolean notSolid;
    public transient boolean waterlogged;
    public transient float slipperiness = 0.6f;
    public transient float speedFactor = 1.0f;
    public transient float jumpFactor = 1.0f;
    public Consumer<RandomTickCallbackJS> randomTickCallback;
    public Consumer<LootBuilder> lootTable;
    public JsonObject blockstateJson;
    public JsonObject modelJson;
    public transient boolean noValidSpawns;
    public transient boolean suffocating;
    public transient boolean viewBlocking;
    public transient boolean redstoneConductor;
    public transient boolean transparent;
    public transient class_2248 block;

    public BlockBuilder(String i) {
        super(i);
        this.material = MaterialListJS.INSTANCE.map.get("wood");
        this.hardness = 0.5f;
        this.resistance = -1.0f;
        this.lightLevel = 0.0f;
        this.opaque = true;
        this.fullBlock = false;
        this.requiresTool = false;
        this.renderType = "solid";
        this.color = new Int2IntOpenHashMap();
        this.color.defaultReturnValue(-1);
        this.textures = new JsonObject();
        this.textureAll(this.id.method_12836() + ":block/" + this.id.method_12832());
        this.model = "";
        this.itemBuilder = new BlockItemBuilder(i);
        this.itemBuilder.blockBuilder = this;
        this.customShape = new ArrayList<class_238>();
        this.noCollission = false;
        this.notSolid = false;
        this.waterlogged = false;
        this.randomTickCallback = null;
        this.lootTable = loot -> loot.addPool(pool -> {
            pool.survivesExplosion();
            pool.addItem(new class_1799((class_1935)this.block));
        });
        this.blockstateJson = null;
        this.modelJson = null;
        this.noValidSpawns = false;
        this.suffocating = true;
        this.viewBlocking = true;
        this.redstoneConductor = true;
        this.transparent = false;
    }

    @Override
    public String getBuilderType() {
        return "block";
    }

    public BlockBuilder type(BlockType t) {
        this.type = t;
        this.type.applyDefaults(this);
        return this;
    }

    public BlockBuilder material(MaterialJS m) {
        this.material = m;
        return this;
    }

    public BlockBuilder hardness(float h) {
        this.hardness = h;
        return this;
    }

    public BlockBuilder resistance(float r) {
        this.resistance = r;
        return this;
    }

    public BlockBuilder unbreakable() {
        this.hardness = -1.0f;
        this.resistance = Float.MAX_VALUE;
        return this;
    }

    public BlockBuilder lightLevel(float light) {
        this.lightLevel = light;
        return this;
    }

    public BlockBuilder opaque(boolean o) {
        this.opaque = o;
        return this;
    }

    public BlockBuilder fullBlock(boolean f) {
        this.fullBlock = f;
        return this;
    }

    public BlockBuilder requiresTool(boolean f) {
        this.requiresTool = f;
        return this;
    }

    public BlockBuilder renderType(String l) {
        this.renderType = l;
        return this;
    }

    public BlockBuilder color(int index, int c) {
        this.color.put(index, 0xFF000000 | c);
        return this;
    }

    public BlockBuilder textureAll(String tex) {
        for (class_2350 direction : class_2350.values()) {
            this.textureSide(direction, tex);
        }
        this.textures.addProperty("particle", tex);
        return this;
    }

    public BlockBuilder textureSide(class_2350 direction, String tex) {
        return this.texture(direction.method_15434(), tex);
    }

    public BlockBuilder texture(String id, String tex) {
        this.textures.addProperty(id, tex);
        return this;
    }

    public BlockBuilder model(String m) {
        this.itemBuilder.parentModel = this.model = m;
        return this;
    }

    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        if (i == null) {
            this.itemBuilder = null;
            this.lootTable = null;
        } else {
            i.accept(this.itemBuilder);
        }
        return this;
    }

    public BlockBuilder noItem() {
        return this.item(null);
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1, boolean scale16) {
        if (scale16) {
            this.customShape.add(new class_238(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0));
        } else {
            this.customShape.add(new class_238(x0, y0, z0, x1, y1, z1));
        }
        return this;
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.box(x0, y0, z0, x1, y1, z1, true);
    }

    public class_265 createShape() {
        if (this.customShape.isEmpty()) {
            return class_259.method_1077();
        }
        class_265 shape = class_259.method_1078((class_238)this.customShape.get(0));
        for (int i = 1; i < this.customShape.size(); ++i) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1078((class_238)this.customShape.get(i)));
        }
        return shape;
    }

    public BlockBuilder noCollission() {
        this.noCollission = true;
        return this;
    }

    public BlockBuilder notSolid() {
        this.notSolid = true;
        return this;
    }

    public BlockBuilder waterlogged() {
        this.waterlogged = true;
        return this;
    }

    public BlockBuilder noDrops() {
        this.lootTable = null;
        return this;
    }

    public BlockBuilder slipperiness(float f) {
        this.slipperiness = f;
        return this;
    }

    public BlockBuilder speedFactor(float f) {
        this.speedFactor = f;
        return this;
    }

    public BlockBuilder jumpFactor(float f) {
        this.jumpFactor = f;
        return this;
    }

    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        this.randomTickCallback = randomTickCallback;
        return this;
    }

    public BlockBuilder noValidSpawns(boolean b) {
        this.noValidSpawns = b;
        return this;
    }

    public BlockBuilder suffocating(boolean b) {
        this.suffocating = b;
        return this;
    }

    public BlockBuilder viewBlocking(boolean b) {
        this.viewBlocking = b;
        return this;
    }

    public BlockBuilder redstoneConductor(boolean b) {
        this.redstoneConductor = b;
        return this;
    }

    public BlockBuilder transparent(boolean b) {
        this.transparent = b;
        return this;
    }

    public BlockBuilder defaultCutout() {
        return this.renderType("cutout").notSolid().noValidSpawns(true).suffocating(false).viewBlocking(false).redstoneConductor(false).transparent(true);
    }

    public BlockBuilder defaultTranslucent() {
        return this.defaultCutout().renderType("translucent");
    }

    @Override
    public BlockBuilder tag(class_2960 tag) {
        ConsoleJS.STARTUP.warn("BlockBuilder.tag's behaviour is going to change in a future version to tag both the block and the item!");
        ConsoleJS.STARTUP.warn("If you do not want this, use tagBlock and tagItem instead!");
        return this.tagBlock(tag);
    }

    public BlockBuilder tagBoth(class_2960 tag) {
        this.tagBlock(tag);
        this.tagItem(tag);
        return this;
    }

    public BlockBuilder tagBlock(class_2960 tag) {
        this.defaultTags.add(tag);
        return this;
    }

    public BlockBuilder tagItem(class_2960 tag) {
        this.itemBuilder.defaultTags.add(tag);
        return this;
    }

    public class_4970.class_2251 createProperties() {
        BlockProperties properties = BlockProperties.of((class_3614)this.material.getMinecraftMaterial());
        properties.method_9626(this.material.getSound());
        if (this.resistance >= 0.0f) {
            properties.method_9629(this.hardness, this.resistance);
        } else {
            properties.method_9632(this.hardness);
        }
        properties.method_9631(state -> (int)(this.lightLevel * 15.0f));
        if (this.noCollission) {
            properties.method_9634();
        }
        if (this.notSolid) {
            properties.method_22488();
        }
        if (this.requiresTool) {
            properties.method_29292();
        }
        if (this.lootTable == null) {
            properties.method_16229();
        }
        properties.method_9628(this.slipperiness);
        properties.method_23351(this.speedFactor);
        properties.method_23352(this.jumpFactor);
        if (this.noValidSpawns) {
            properties.method_26235((blockState, blockGetter, blockPos, object) -> false);
        }
        if (!this.suffocating) {
            properties.method_26243((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.viewBlocking) {
            properties.method_26245((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.redstoneConductor) {
            properties.method_26236((blockState, blockGetter, blockPos) -> false);
        }
        if (this.randomTickCallback != null) {
            properties.method_9640();
        }
        return properties;
    }
}

