/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSObjects;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.bindings.BlockWrapper;
import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.bindings.ItemWrapper;
import dev.latvian.mods.kubejs.bindings.RarityWrapper;
import dev.latvian.mods.kubejs.bindings.TextWrapper;
import dev.latvian.mods.kubejs.bindings.UtilsWrapper;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRegistryEventJS;
import dev.latvian.mods.kubejs.block.DetectorInstance;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.block.custom.BasicBlockType;
import dev.latvian.mods.kubejs.block.custom.BlockType;
import dev.latvian.mods.kubejs.block.custom.BlockTypes;
import dev.latvian.mods.kubejs.block.custom.ShapedBlockType;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.screen.AtlasTextureObject;
import dev.latvian.mods.kubejs.client.painter.screen.GradientObject;
import dev.latvian.mods.kubejs.client.painter.screen.RectangleObject;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenGroup;
import dev.latvian.mods.kubejs.client.painter.screen.TextObject;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.event.DataEvent;
import dev.latvian.mods.kubejs.event.EventsJS;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.fluid.FluidRegistryEventJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemRegistryEventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.custom.ItemArmorTierEventJS;
import dev.latvian.mods.kubejs.item.custom.ItemToolTierEventJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.item.type.ArmorItemType;
import dev.latvian.mods.kubejs.item.type.BasicItemType;
import dev.latvian.mods.kubejs.item.type.ItemType;
import dev.latvian.mods.kubejs.item.type.ItemTypes;
import dev.latvian.mods.kubejs.item.type.ToolItemType;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter;
import dev.latvian.mods.kubejs.level.gen.filter.mob.MobFilter;
import dev.latvian.mods.kubejs.loot.LootBuilder;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.mods.kubejs.recipe.minecraft.CookingRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.SmithingRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.StonecuttingRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauEnchantingApparatusRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauEnchantmentRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauGlyphPressRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.BotaniaRunicAltarRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.BotanyPotsCropRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.IDSqueezerRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.MATagRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.MalumSpiritFocusingRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ShapedArtisanRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ShapelessArtisanRecipeJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.text.Text;
import dev.latvian.mods.kubejs.util.BuilderBase;
import dev.latvian.mods.kubejs.util.ClassFilter;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.NBTIOWrapper;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.NBTWrapper;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.wrapper.AABBWrapper;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.mod.wrapper.DirectionWrapper;
import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_101;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3825;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5658;
import net.minecraft.class_6017;

public class BuiltinKubeJSPlugin
extends KubeJSPlugin {
    public static final HashMap<String, Object> GLOBAL = new HashMap();

    @Override
    public void init() {
        BlockTypes.register(BasicBlockType.INSTANCE);
        BlockTypes.register(ShapedBlockType.SLAB);
        BlockTypes.register(ShapedBlockType.STAIRS);
        BlockTypes.register(ShapedBlockType.FENCE);
        BlockTypes.register(ShapedBlockType.FENCE_GATE);
        BlockTypes.register(ShapedBlockType.WALL);
        BlockTypes.register(ShapedBlockType.WOODEN_PRESSURE_PLATE);
        BlockTypes.register(ShapedBlockType.STONE_PRESSURE_PLATE);
        BlockTypes.register(ShapedBlockType.WOODEN_BUTTON);
        BlockTypes.register(ShapedBlockType.STONE_BUTTON);
        ItemTypes.register(BasicItemType.INSTANCE);
        ItemTypes.register(ToolItemType.SWORD);
        ItemTypes.register(ToolItemType.PICKAXE);
        ItemTypes.register(ToolItemType.AXE);
        ItemTypes.register(ToolItemType.SHOVEL);
        ItemTypes.register(ToolItemType.HOE);
        ItemTypes.register(ArmorItemType.HELMET);
        ItemTypes.register(ArmorItemType.CHESTPLATE);
        ItemTypes.register(ArmorItemType.LEGGINGS);
        ItemTypes.register(ArmorItemType.BOOTS);
    }

    @Override
    public void initStartup() {
        new ItemToolTierEventJS().post("item.registry.tool_tiers");
        new ItemArmorTierEventJS().post("item.registry.armor_tiers");
        new BlockRegistryEventJS().post("block.registry");
        new ItemRegistryEventJS().post("item.registry");
        new FluidRegistryEventJS().post("fluid.registry");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientInit() {
        Painter.INSTANCE.registerObject("screen_group", ScreenGroup::new);
        Painter.INSTANCE.registerObject("rectangle", RectangleObject::new);
        Painter.INSTANCE.registerObject("text", TextObject::new);
        Painter.INSTANCE.registerObject("atlas_texture", AtlasTextureObject::new);
        Painter.INSTANCE.registerObject("gradient", GradientObject::new);
    }

    @Override
    public void addClasses(ScriptType type, ClassFilter filter) {
        filter.allow("java.lang.Number");
        filter.allow("java.lang.String");
        filter.allow("java.lang.Character");
        filter.allow("java.lang.Byte");
        filter.allow("java.lang.Short");
        filter.allow("java.lang.Integer");
        filter.allow("java.lang.Long");
        filter.allow("java.lang.Float");
        filter.allow("java.lang.Double");
        filter.allow("java.lang.Boolean");
        filter.allow("java.lang.Runnable");
        filter.allow("java.lang.Iterable");
        filter.allow("java.lang.Comparable");
        filter.allow("java.lang.CharSequence");
        filter.allow("java.math.BigInteger");
        filter.allow("java.math.BigDecimal");
        filter.deny("java.io");
        filter.allow("java.io.Closeable");
        filter.allow("java.io.Serializable");
        filter.deny("java.nio");
        filter.allow("java.nio.ByteOrder");
        filter.allow("java.util");
        filter.deny("java.util.jar");
        filter.deny("java.util.zip");
        filter.allow("it.unimi.dsi.fastutil");
        filter.allow("dev.latvian.mods.kubejs");
        filter.deny("dev.latvian.mods.kubejs.script");
        filter.deny("dev.latvian.mods.kubejs.mixin");
        filter.deny(KubeJSPlugin.class);
        filter.deny(KubeJSPlugins.class);
        filter.allow("net.minecraft");
        filter.allow("com.mojang.authlib.GameProfile");
        filter.allow("com.mojang.util.UUIDTypeAdapter");
        filter.allow("com.mojang.brigadier");
        filter.allow("dev.architectury");
        filter.deny("java.net");
        filter.deny("sun");
        filter.deny("com.sun");
        filter.deny("io.netty");
        filter.deny("org.objectweb.asm");
        filter.deny("org.spongepowered.asm");
        filter.deny("org.openjdk.nashorn");
        filter.deny("jdk.nashorn");
        filter.allow("mezz.jei");
    }

    @Override
    public void addBindings(BindingsEvent event) {
        event.add("global", GLOBAL);
        if (event.type == ScriptType.SERVER) {
            ServerSettings.instance = new ServerSettings();
            event.add("settings", ServerSettings.instance);
        }
        event.add("Platform", PlatformWrapper.class);
        event.add("console", event.type.console);
        event.addFunction("onEvent", args -> BuiltinKubeJSPlugin.onEvent(event, args), null, IEventHandler.class);
        event.addFunction("postEvent", args -> BuiltinKubeJSPlugin.postEvent(event, args), String.class, Object.class, Boolean.class);
        event.addFunction("java", args -> event.manager.loadJavaClass(event.scope, args), new Class[]{null});
        event.add("JavaMath", Math.class);
        event.add("ResourceLocation", class_2960.class);
        event.add("Utils", UtilsWrapper.class);
        event.add("Text", TextWrapper.class);
        event.add("UUID", UUIDWrapper.class);
        event.add("JsonIO", JsonIO.class);
        event.add("Block", BlockWrapper.class);
        event.add("Item", ItemWrapper.class);
        event.add("Ingredient", IngredientWrapper.class);
        event.add("NBT", NBTWrapper.class);
        event.add("NBTIO", NBTIOWrapper.class);
        event.add("Direction", DirectionWrapper.class);
        event.add("Facing", DirectionWrapper.class);
        event.add("AABB", AABBWrapper.class);
        event.add("Fluid", FluidWrapper.class);
        event.add("SECOND", 1000L);
        event.add("MINUTE", 60000L);
        event.add("HOUR", 3600000L);
        event.add("Color", ColorWrapper.class);
        event.add("BlockStatePredicate", BlockStatePredicate.class);
        event.add("EquipmentSlot", class_1304.class);
        event.add("SLOT_MAINHAND", class_1304.field_6173);
        event.add("SLOT_OFFHAND", class_1304.field_6171);
        event.add("SLOT_FEET", class_1304.field_6166);
        event.add("SLOT_LEGS", class_1304.field_6172);
        event.add("SLOT_CHEST", class_1304.field_6174);
        event.add("SLOT_HEAD", class_1304.field_6169);
        event.add("Rarity", RarityWrapper.class);
        event.add("RARITY_COMMON", RarityWrapper.COMMON);
        event.add("RARITY_UNCOMMON", RarityWrapper.UNCOMMON);
        event.add("RARITY_RARE", RarityWrapper.RARE);
        event.add("RARITY_EPIC", RarityWrapper.EPIC);
        event.add("AIR_ITEM", class_1802.field_8162);
        event.add("AIR_BLOCK", class_2246.field_10124);
        event.add("Hand", class_1268.class);
        event.add("MAIN_HAND", class_1268.field_5808);
        event.add("OFF_HAND", class_1268.field_5810);
        event.add("DecorationGenerationStep", class_2893.class_2895.class);
        event.add("CarvingGenerationStep", class_2893.class_2894.class);
        event.add("Vec3", class_243.class);
        event.add("Vec3d", class_243.class);
        event.add("Vec3i", class_2382.class);
        event.add("BlockPos", class_2338.class);
        KubeJS.PROXY.clientBindings(event);
    }

    private static Object onEvent(BindingsEvent event, Object[] args) {
        for (Object o : ListJS.orSelf(args[0])) {
            event.type.manager.get().events.listen(String.valueOf(o), (IEventHandler)args[1]);
        }
        return null;
    }

    private static Object postEvent(BindingsEvent event, Object[] args) {
        String id = String.valueOf(args[0]);
        Object data = args.length >= 2 ? args[1] : null;
        boolean cancellable = args.length >= 3 && Boolean.TRUE.equals(args[2]);
        EventsJS events = event.type.manager.get().events;
        return events.postToHandlers(id, events.handlers(id), new DataEvent(cancellable, data));
    }

    @Override
    public void addTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.register(String.class, String::valueOf);
        typeWrappers.register(CharSequence.class, String::valueOf);
        typeWrappers.register(UUID.class, UUIDWrapper::fromString);
        typeWrappers.register(Pattern.class, UtilsJS::parseRegex);
        typeWrappers.register(JsonObject.class, MapJS::json);
        typeWrappers.register(JsonArray.class, ListJS::json);
        typeWrappers.register(JsonElement.class, JsonIO::of);
        typeWrappers.register(JsonPrimitive.class, JsonIO::primitiveOf);
        typeWrappers.register(Path.class, UtilsJS::getPath);
        typeWrappers.register(File.class, UtilsJS::getFileFromPath);
        typeWrappers.register(class_2960.class, UtilsJS::getMCID);
        typeWrappers.register(class_1799.class, o -> ItemStackJS.of(o).getItemStack());
        typeWrappers.register(class_2487.class, MapJS::isNbt, MapJS::nbt);
        typeWrappers.register(class_2483.class, ListJS::nbt);
        typeWrappers.register(class_2499.class, o -> (class_2499)ListJS.nbt(o));
        typeWrappers.register(class_2561.class, Text::componentOf);
        typeWrappers.register(class_5250.class, o -> new class_2585("").method_10852(Text.componentOf(o)));
        typeWrappers.register(class_2338.class, o -> {
            List list;
            if (o instanceof class_2338) {
                class_2338 pos = (class_2338)o;
                return pos;
            }
            if (o instanceof List && (list = (List)o).size() >= 3) {
                return new class_2338(UtilsJS.parseInt(list.get(0), 0), UtilsJS.parseInt(list.get(1), 0), UtilsJS.parseInt(list.get(2), 0));
            }
            if (o instanceof BlockContainerJS) {
                BlockContainerJS block = (BlockContainerJS)o;
                return block.getPos();
            }
            return class_2338.field_10980;
        });
        typeWrappers.register(class_243.class, o -> {
            List list;
            if (o instanceof class_243) {
                class_243 vec = (class_243)o;
                return vec;
            }
            if (o instanceof EntityJS) {
                EntityJS entity = (EntityJS)o;
                return entity.minecraftEntity.method_19538();
            }
            if (o instanceof List && (list = (List)o).size() >= 3) {
                return new class_243(UtilsJS.parseDouble(list.get(0), 0.0), UtilsJS.parseDouble(list.get(1), 0.0), UtilsJS.parseDouble(list.get(2), 0.0));
            }
            if (o instanceof class_2338) {
                class_2338 pos = (class_2338)o;
                return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            }
            if (o instanceof BlockContainerJS) {
                BlockContainerJS block = (BlockContainerJS)o;
                return new class_243((double)block.getPos().method_10263() + 0.5, (double)block.getPos().method_10264() + 0.5, (double)block.getPos().method_10260() + 0.5);
            }
            return class_243.field_1353;
        });
        typeWrappers.register(class_1792.class, ItemStackJS::getRawItem);
        typeWrappers.register(class_2893.class_2895.class, o -> {
            try {
                return class_2893.class_2895.valueOf((String)o.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        });
        typeWrappers.register(class_1311.class, o -> o == null ? null : class_1311.method_28307((String)o.toString()));
        typeWrappers.register(class_5251.class, o -> {
            if (o instanceof Number) {
                Number number = (Number)o;
                return class_5251.method_27717((int)(number.intValue() & 0xFFFFFF));
            }
            if (o instanceof class_124) {
                class_124 legacyColor = (class_124)o;
                return class_5251.method_27718((class_124)legacyColor);
            }
            return class_5251.method_27719((String)o.toString());
        });
        typeWrappers.register(class_238.class, AABBWrapper::wrap);
        typeWrappers.register(class_2350.class, o -> {
            class_2350 dir;
            return o instanceof class_2350 ? (dir = (class_2350)o) : (class_2350)DirectionWrapper.ALL.get(o.toString().toLowerCase());
        });
        typeWrappers.register(class_6017.class, UtilsJS::intProviderOf);
        typeWrappers.register(class_5658.class, UtilsJS::numberProviderOf);
        typeWrappers.register(class_47.class_50.class, o -> o == null ? null : class_47.class_50.method_314((String)o.toString().toLowerCase()));
        typeWrappers.register(class_101.class_102.class, o -> o == null ? null : class_101.class_102.method_475((String)o.toString().toLowerCase()));
        typeWrappers.register(MapJS.class, MapJS::of);
        typeWrappers.register(ListJS.class, ListJS::of);
        typeWrappers.register(ItemStackJS.class, ItemStackJS::of);
        typeWrappers.register(IngredientJS.class, IngredientJS::of);
        typeWrappers.register(IngredientStackJS.class, o -> IngredientJS.of(o).asIngredientStack());
        typeWrappers.register(Text.class, Text::of);
        typeWrappers.register(BlockStatePredicate.class, BlockStatePredicate::of);
        typeWrappers.register(class_3825.class, BlockStatePredicate::ruleTestOf);
        typeWrappers.register(BiomeFilter.class, BiomeFilter::of);
        typeWrappers.register(MobFilter.class, MobFilter::of);
        typeWrappers.register(FluidStackJS.class, FluidStackJS::of);
        typeWrappers.register(RecipeFilter.class, RecipeFilter::of);
        typeWrappers.register(MaterialJS.class, MaterialListJS.INSTANCE::of);
        typeWrappers.register(ItemType.class, ItemTypes::get);
        typeWrappers.register(BlockType.class, BlockTypes::get);
        typeWrappers.register(Color.class, ColorWrapper::of);
        typeWrappers.register(IngredientActionFilter.class, IngredientActionFilter::filterOf);
        KubeJS.PROXY.clientTypeWrappers(typeWrappers);
    }

    @Override
    public void addRecipes(RegisterRecipeHandlersEvent event) {
        event.registerShaped(new class_2960("kubejs:shaped"));
        event.registerShapeless(new class_2960("kubejs:shapeless"));
        event.registerShaped(new class_2960("minecraft:crafting_shaped"));
        event.registerShapeless(new class_2960("minecraft:crafting_shapeless"));
        event.register(new class_2960("minecraft:stonecutting"), StonecuttingRecipeJS::new);
        event.register(new class_2960("minecraft:smelting"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:blasting"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:smoking"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:campfire_cooking"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:smithing"), SmithingRecipeJS::new);
        if (Platform.isModLoaded((String)"cucumber")) {
            event.registerShaped(new class_2960("cucumber:shaped_no_mirror"));
        }
        if (Platform.isModLoaded((String)"mysticalagriculture")) {
            event.register(new class_2960("mysticalagriculture:tag"), MATagRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"botanypots")) {
            event.register(new class_2960("botanypots:crop"), BotanyPotsCropRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"extendedcrafting")) {
            event.registerShaped(new class_2960("extendedcrafting:shaped_table"));
            event.registerShapeless(new class_2960("extendedcrafting:shapeless_table"));
        }
        if (Platform.isModLoaded((String)"dankstorage")) {
            event.registerShaped(new class_2960("dankstorage:upgrade"));
        }
        if (Platform.isModLoaded((String)"artisanworktables")) {
            String[] types;
            for (String t : types = new String[]{"basic", "blacksmith", "carpenter", "chef", "chemist", "designer", "engineer", "farmer", "jeweler", "mage", "mason", "potter", "scribe", "tailor", "tanner"}) {
                event.register(new class_2960("artisanworktables:" + t + "_shaped"), ShapedArtisanRecipeJS::new);
                event.register(new class_2960("artisanworktables:" + t + "_shapeless"), ShapelessArtisanRecipeJS::new);
            }
        }
        if (Platform.isModLoaded((String)"botania")) {
            event.register(new class_2960("botania:runic_altar"), BotaniaRunicAltarRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"integrateddynamics") && !Platform.isModLoaded((String)"kubejs_integrated_dynamics")) {
            event.register(new class_2960("integrateddynamics:squeezer"), IDSqueezerRecipeJS::new);
            event.register(new class_2960("integrateddynamics:mechanical_squeezer"), IDSqueezerRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"ars_nouveau")) {
            event.register(new class_2960("ars_nouveau:enchanting_apparatus"), ArsNouveauEnchantingApparatusRecipeJS::new);
            event.register(new class_2960("ars_nouveau:enchantment"), ArsNouveauEnchantmentRecipeJS::new);
            event.register(new class_2960("ars_nouveau:glyph_recipe"), ArsNouveauGlyphPressRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"malum")) {
            event.register(new class_2960("malum:spirit_focusing"), MalumSpiritFocusingRecipeJS::new);
        }
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.lootTable != null) {
                LootBuilder lootBuilder = new LootBuilder(null);
                lootBuilder.type = "minecraft:block";
                blockBuilder.lootTable.accept(lootBuilder);
                generator.json(blockBuilder.newID("loot_tables/blocks/", ""), (JsonElement)lootBuilder.toJson());
            }
            blockBuilder.type.generateData(blockBuilder, generator);
        }
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.type.generateData(itemBuilder, generator);
        }
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            generator.blockState(new class_2960("kubejs", "detector_" + detectorInstance.id), bs -> {
                bs.variant("powered=false", "kubejs:block/detector");
                bs.variant("powered=true", "kubejs:block/detector_on");
            });
            generator.itemModel(new class_2960("kubejs", "detector_" + detectorInstance.id), m -> m.parent("kubejs:block/detector"));
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            blockBuilder.type.generateAssets(blockBuilder, generator);
        }
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.type.generateAssets(itemBuilder, generator);
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            generator.json(fluidBuilder.newID("blockstates/", ""), (JsonElement)fluidBuilder.getBlockstateJson());
            generator.json(fluidBuilder.newID("models/block/", ""), (JsonElement)fluidBuilder.getBlockModelJson());
            JsonObject bucketModel = new JsonObject();
            bucketModel.addProperty("parent", "kubejs:item/generated_bucket");
            generator.json(fluidBuilder.newID("models/item/", "_bucket"), (JsonElement)bucketModel);
        }
    }

    @Override
    public void generateLang(Map<String, String> lang) {
        lang.put("itemGroup.kubejs.kubejs", "KubeJS");
        lang.put("item.kubejs.dummy_fluid_item", "Dummy Fluid Item");
        for (BuilderBase builderBase : KubeJSObjects.ALL) {
            if (builderBase.displayName.isEmpty()) continue;
            lang.put(builderBase.translationKey, builderBase.displayName);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            lang.put("block.kubejs.detector_" + detectorInstance.id, "KubeJS Detector [" + detectorInstance.id + "]");
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            if (fluidBuilder.displayName.isEmpty()) continue;
            lang.put(fluidBuilder.bucketItem.method_7876(), fluidBuilder.displayName + " Bucket");
        }
    }
}

