/*
 * Decompiled with CFR 0.152.
 */
package net.jptrzy.infusion.table.blocks;

import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.jptrzy.infusion.table.Main;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class InfusionTableEntity
extends class_2586 {
    private class_1799 item = new class_1799((class_1935)class_1802.field_8162);
    private class_1799 book = new class_1799((class_1935)class_1802.field_8162);
    public float bookOpenAngle = 0.0f;
    public float bookLastOpenAngle = 0.0f;
    public float bookRot = 0.0f;
    public float bookLastRot = 0.0f;
    public float bookRotDir = 0.0f;
    public float bookRotForce = 0.0f;
    private int state = 0;
    private int time = 0;
    public float bookAngleForce = 0.0f;

    public InfusionTableEntity(class_2338 pos, class_2680 state) {
        super(Main.INFUSION_TABLE_ENTITY, pos, state);
    }

    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.method_8608()) {
            class_1799 item = player.method_5998(hand);
            if (this.state == 0 && item.method_31574(class_1802.field_8529) && !item.method_7942()) {
                world.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 0.8f, 0.8f);
                class_1799 copy = item.method_7972();
                copy.method_7939(1);
                this.book = copy;
                item.method_7934(1);
                this.bookOpenAngle = 0.0f;
                this.state = 1;
                this.notifyListeners();
            } else if (this.state == 1 && item.method_7942() && !item.method_31574(class_1802.field_8529) && !item.method_31574(class_1802.field_8598)) {
                world.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 0.8f, 0.8f);
                class_1799 copy = item.method_7972();
                copy.method_7939(1);
                this.item = copy;
                item.method_7934(1);
                this.state = 2;
                this.notifyListeners();
            } else if (this.state == 3 && item.method_31574(class_1802.field_8884)) {
                world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 0.8f, 0.8f);
                world.method_8396(null, pos, class_3417.field_14880, class_3419.field_15245, 0.9f, 0.6f);
                this.state = 4;
                this.notifyListeners();
            }
        }
        return class_1269.field_5812;
    }

    public void onExplosion(class_1937 world, class_2338 pos, class_1927 explosion) {
        this.onBreak(null, world, pos, null);
    }

    public void onBreak(@Nullable class_2680 state, class_1937 world, class_2338 pos, @Nullable class_1657 player) {
        if (!world.method_8608()) {
            if (player == null) {
                if (!this.book.method_7960()) {
                    InfusionTableEntity.dropStack(world, pos, this.book);
                    this.book = new class_1799((class_1935)class_1802.field_8162);
                    if (!this.item.method_7960() && this.state != 5) {
                        InfusionTableEntity.dropStack(world, pos, this.item);
                        this.item = new class_1799((class_1935)class_1802.field_8162);
                    }
                    this.cleanUp(world);
                }
                this.notifyListeners();
            } else if (this.state == 3) {
                world.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 0.8f, 0.8f);
                InfusionTableEntity.dropStack(world, pos, this.item);
                this.item = new class_1799((class_1935)class_1802.field_8162);
                this.state = 2;
                this.notifyListeners();
            } else if (this.state == 1 || this.state == 5) {
                world.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 0.8f, 0.8f);
                InfusionTableEntity.dropStack(world, pos, this.book);
                this.book = new class_1799((class_1935)class_1802.field_8162);
                this.state = 0;
                if (this.state == 5) {
                    this.cleanUp(world);
                }
                this.notifyListeners();
            }
        }
    }

    public static void dropStack(class_1937 world, class_2338 pos, class_1799 stack) {
        float f = class_1299.field_6052.method_17686() / 2.0f;
        double d = (float)pos.method_10263() + 0.5f;
        double e = (double)((float)pos.method_10264() + 1.0f) - (double)f;
        double g = (float)pos.method_10260() + 0.5f;
        InfusionTableEntity.dropStack(world, () -> new class_1542(world, d, e, g, stack), stack);
    }

    private static void dropStack(class_1937 world, Supplier<class_1542> itemEntitySupplier, class_1799 stack) {
        if (!world.field_9236 && !stack.method_7960() && world.method_8450().method_8355(class_1928.field_19392)) {
            class_1542 itemEntity = itemEntitySupplier.get();
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, InfusionTableEntity entity) {
        if (world.method_8608() && entity.state != 0) {
            entity.bookLastRot = entity.bookRot;
            class_1657 playerEntity = world.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3.0, false);
            if (playerEntity != null) {
                double d = playerEntity.method_23317() - ((double)pos.method_10263() + 0.5);
                double e = playerEntity.method_23321() - ((double)pos.method_10260() + 0.5);
                entity.bookRotDir = (float)class_3532.method_15349((double)e, (double)d);
            } else {
                entity.bookRotDir += 0.02f;
            }
            entity.bookRot = Main.aroundRadial(entity.bookRot);
            entity.bookRotDir = Main.aroundRadial(entity.bookRotDir);
            entity.bookRotForce = entity.bookRotDir - entity.bookRot;
            entity.bookRotForce = Main.aroundRadial(entity.bookRotForce);
            entity.bookRot += entity.bookRotForce * 0.4f;
            entity.bookLastOpenAngle = entity.bookOpenAngle;
        }
        switch (entity.state) {
            case 2: {
                if (entity.item.method_7960()) {
                    if (entity.bookOpenAngle > 0.0f) {
                        entity.bookOpenAngle -= 0.1f;
                        break;
                    }
                    if (world.method_8608()) break;
                    entity.bookOpenAngle = 0.0f;
                    entity.state = 1;
                    entity.notifyListeners();
                    break;
                }
                if (entity.bookOpenAngle < 1.0f) {
                    entity.bookOpenAngle += 0.1f;
                    break;
                }
                if (world.method_8608()) break;
                entity.bookOpenAngle = 1.0f;
                entity.state = 3;
                entity.notifyListeners();
                break;
            }
            case 4: {
                if (entity.time > 60) {
                    if (entity.bookOpenAngle > 0.0f) {
                        entity.bookOpenAngle -= 0.1f;
                    } else if (!world.method_8608()) {
                        world.method_8396(null, pos, class_3417.field_15193, class_3419.field_15245, 0.8f, 0.8f);
                        entity.state = 5;
                        entity.time = 0;
                        entity.bookOpenAngle = 0.0f;
                        entity.book = new class_1799((class_1935)class_1802.field_8598);
                        Map list = class_1890.method_22445((class_2499)entity.item.method_7921());
                        for (Map.Entry entry : list.entrySet()) {
                            class_1772.method_7807((class_1799)entity.book, (class_1889)new class_1889((class_1887)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                        }
                        entity.notifyListeners();
                    }
                } else if (entity.time < 36) {
                    Random r = new Random();
                    world.method_8406((class_2394)class_2398.field_11215, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, (double)((float)(r.nextBoolean() ? -1 : 1) * r.nextFloat()), 1.0, (double)((float)(r.nextBoolean() ? -1 : 1) * r.nextFloat()));
                }
                ++entity.time;
            }
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("Item", (class_2520)this.item.method_7953(new class_2487()));
        tag.method_10566("Book", (class_2520)this.book.method_7953(new class_2487()));
        tag.method_10569("State", this.state);
        tag.method_10569("Time", this.time);
        tag.method_10548("BookOpenAngle", this.bookOpenAngle);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.item = class_1799.method_7915((class_2487)tag.method_10562("Item"));
        this.book = class_1799.method_7915((class_2487)tag.method_10562("Book"));
        this.state = tag.method_10550("State");
        this.time = tag.method_10550("Time");
        this.bookOpenAngle = tag.method_10583("BookOpenAngle");
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void notifyListeners() {
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void cleanUp(class_1937 world) {
        if (!world.method_8608()) {
            this.state = 0;
            this.bookOpenAngle = 0.0f;
            this.time = 0;
            this.item = new class_1799((class_1935)class_1802.field_8162);
            this.book = new class_1799((class_1935)class_1802.field_8162);
            this.notifyListeners();
        }
    }

    public class_1799 getItem() {
        return this.item;
    }

    public class_1799 getBook() {
        return this.book;
    }

    public float getBookOpenAngle() {
        return this.bookOpenAngle;
    }
}

