/*
 * Decompiled with CFR 0.152.
 */
package io.github.shaksternano.wmitaf.client.util;

import io.github.shaksternano.wmitaf.client.accessor.ModNameHolder;
import io.github.shaksternano.wmitaf.client.accessor.TextHolder;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ModNameUtil {
    private static final String EXTRA_ALCHEMY_BREAKABLE_POTION_ID = "extraalchemy:breakable_potion";
    private static final String PATCHOULI_BOOK_ID = "patchouli:guide_book";
    private static final String PATCHOULI_BOOK_TAG = "patchouli:book";

    private ModNameUtil() {
    }

    @Nullable
    public static String getActualModName(class_1799 stack) {
        ModNameHolder modNameHolder = (ModNameHolder)stack;
        String modName = modNameHolder.wmitaf$getModName();
        if (modName == null && ModNameUtil.modNameNeedsToBeChanged(stack)) {
            String modId = ModNameUtil.getActualModId(stack);
            modName = ModNameUtil.getModNameFromId(modId);
            modNameHolder.wmitaf$setModName(modName);
        }
        return modName;
    }

    @Nullable
    public static String getActualModId(class_1799 stack) {
        class_2960 identifier;
        ModNameHolder modNameHolder = (ModNameHolder)stack;
        String modId = modNameHolder.wmitaf$getModId();
        if (modId == null && ModNameUtil.modNameNeedsToBeChanged(stack) && (identifier = ModNameUtil.getIdentifierFromStackData(stack)) != null) {
            modId = identifier.method_12836();
            modNameHolder.wmitaf$setModId(modId);
        }
        return modId;
    }

    public static void setWailaTooltip(ITooltip tooltip, class_1297 entity, String toDisplay, boolean modName, boolean needsToBeChanged) {
        Consumer<class_2561> setText;
        Function<String, String> stringFormat;
        class_2960 wailaId;
        TextHolder textHolder = (TextHolder)entity;
        class_2561 textName = modName ? textHolder.wmitaf$getTextModName() : textHolder.wmitaf$getTextName();
        class_2960 class_29602 = wailaId = modName ? WailaConstants.MOD_NAME_TAG : WailaConstants.OBJECT_NAME_TAG;
        Function<String, String> function = modName ? arg_0 -> ((IWailaConfig.Formatting)IWailaConfig.get().getFormatting()).formatModName(arg_0) : (stringFormat = arg_0 -> ((IWailaConfig.Formatting)IWailaConfig.get().getFormatting()).formatEntityName(arg_0));
        Consumer<class_2561> consumer = modName ? textHolder::wmitaf$setTextModName : (setText = textHolder::wmitaf$setTextName);
        if (textName == null && needsToBeChanged) {
            textName = class_2561.method_30163((String)stringFormat.apply(toDisplay));
            setText.accept(textName);
        }
        tooltip.set(wailaId, textName);
    }

    public static boolean modNameNeedsToBeChanged(class_1799 stack) {
        return stack.method_31574(class_1802.field_8598) || ModNameUtil.hasStatusEffects(stack) || ModNameUtil.hasId(stack.method_7909(), PATCHOULI_BOOK_ID);
    }

    @Nullable
    private static class_2960 getIdentifierFromStackData(class_1799 stack) {
        class_2960 identifier = null;
        if (stack.method_31574(class_1802.field_8598)) {
            identifier = ModNameUtil.getFirstEnchantmentId(stack);
        } else if (ModNameUtil.hasStatusEffects(stack)) {
            identifier = ModNameUtil.getFirstEffectId(stack);
        } else if (ModNameUtil.hasId(stack.method_7909(), PATCHOULI_BOOK_ID)) {
            identifier = ModNameUtil.getPatchouliBookId(stack);
        }
        return identifier;
    }

    @Nullable
    private static String getModNameFromId(@Nullable String namespace) {
        if (namespace != null) {
            Optional modContainer = FabricLoader.getInstance().getModContainer(namespace);
            if (modContainer.isPresent()) {
                return ((ModContainer)modContainer.get()).getMetadata().getName();
            }
            return namespace;
        }
        return null;
    }

    @Nullable
    private static class_2960 getFirstEnchantmentId(class_1799 stack) {
        Set enchantments = class_1890.method_8222((class_1799)stack).keySet();
        Iterator enchantmentsIterator = enchantments.iterator();
        if (enchantmentsIterator.hasNext()) {
            class_1887 enchantment = (class_1887)enchantmentsIterator.next();
            return class_1890.method_37423((class_1887)enchantment);
        }
        return null;
    }

    @Nullable
    private static class_2960 getFirstEffectId(class_1799 stack) {
        class_1291 effect;
        class_2960 effectId;
        List effectInstances = class_1844.method_8067((class_1799)stack);
        Iterator effectInstancesIterator = effectInstances.iterator();
        if (effectInstancesIterator.hasNext() && (effectId = class_2378.field_11159.method_10221((Object)(effect = ((class_1293)effectInstancesIterator.next()).method_5579()))) != null) {
            if (effectId.method_12836().equals("minecraft")) {
                return class_2378.field_11142.method_10221((Object)stack.method_7909());
            }
            return effectId;
        }
        return null;
    }

    @Nullable
    private static class_2960 getPatchouliBookId(class_1799 stack) {
        String bookId;
        if (stack.method_7985() && !(bookId = stack.method_7969().method_10558(PATCHOULI_BOOK_TAG)).equals("")) {
            return new class_2960(bookId);
        }
        return null;
    }

    private static boolean hasStatusEffects(class_1799 stack) {
        return stack.method_31574(class_1802.field_8574) || stack.method_31574(class_1802.field_8436) || stack.method_31574(class_1802.field_8150) || stack.method_31574(class_1802.field_8087) || ModNameUtil.hasId(stack.method_7909(), EXTRA_ALCHEMY_BREAKABLE_POTION_ID);
    }

    private static boolean hasId(class_1792 item, String id) {
        return class_2378.field_11142.method_10221((Object)item).toString().equals(id);
    }
}

