/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.item;

import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.item.Colored;
import com.blakebr0.ironjetpacks.item.Enableable;
import com.blakebr0.ironjetpacks.item.storage.StackBaseStorage;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.mixins.ServerPlayNetworkHandlerAccessor;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.blakebr0.ironjetpacks.util.UnitUtils;
import dev.architectury.extensions.ItemExtension;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_4057;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;
import team.reborn.energy.api.EnergyStorage;

public class JetpackItem
extends class_4057
implements Colored,
class_1768,
Enableable,
ItemExtension {
    private final Jetpack jetpack;

    public JetpackItem(Jetpack jetpack, class_1792.class_1793 settings) {
        super(JetpackUtils.makeArmorMaterial(jetpack), class_1304.field_6174, settings.method_7895(0).method_7894(jetpack.rarity));
        this.jetpack = jetpack;
    }

    public class_2561 method_7864(class_1799 stack) {
        String name = StringUtils.capitalize((String)this.jetpack.name.replace(" ", "_"));
        return new class_2588("item.iron-jetpacks.jetpack", new Object[]{name});
    }

    public void tickArmor(class_1799 stack, class_1657 player) {
        JetpackItem jetpack;
        class_1799 chest = player.method_6118(class_1304.field_6174);
        class_1792 item = chest.method_7909();
        if (!chest.method_7960() && item instanceof JetpackItem && (jetpack = (JetpackItem)item).isEngineOn(chest)) {
            boolean hover = jetpack.isHovering(chest);
            if (InputHandler.isHoldingUp(player) || hover && !player.method_24828()) {
                Jetpack info = jetpack.getJetpack();
                double hoverSpeed = InputHandler.isHoldingDown(player) ? info.speedHover : info.speedHoverSlow;
                double currentAccel = info.accelVert * (player.method_18798().method_10214() < 0.3 ? 2.5 : 1.0);
                double currentSpeedVertical = info.speedVert * (player.method_5869() ? 0.4 : 1.0);
                double usage = player.method_5624() ? info.usage * info.sprintFuel : info.usage;
                boolean creative = info.creative;
                StackBaseStorage storage = new StackBaseStorage(stack.method_7972());
                EnergyStorage energy = (EnergyStorage)EnergyStorage.ITEM.find(stack.method_7972(), (Object)ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)storage));
                try (Transaction transaction = Transaction.openOuter();){
                    if (creative || (double)energy.extract((long)usage, (TransactionContext)transaction) >= usage) {
                        if (!creative) {
                            transaction.commit();
                            class_1799 newStack = storage.getResource().toStack();
                            stack.method_7980(newStack.method_7969());
                            stack.method_7939(newStack.method_7947());
                        }
                        double motionY = player.method_18798().method_10214();
                        if (InputHandler.isHoldingUp(player)) {
                            if (!hover) {
                                this.fly(player, Math.min(motionY + currentAccel, currentSpeedVertical));
                            } else if (InputHandler.isHoldingDown(player)) {
                                this.fly(player, Math.min(motionY + currentAccel, -info.speedHoverSlow));
                            } else {
                                this.fly(player, Math.min(motionY + currentAccel, info.speedHover));
                            }
                        } else {
                            this.fly(player, Math.min(motionY + currentAccel, -hoverSpeed));
                        }
                        float speedSideways = (float)(player.method_5715() ? info.speedSide * 0.5 : info.speedSide);
                        float speedForward = (float)(player.method_5624() ? (double)speedSideways * info.sprintSpeed : (double)speedSideways);
                        if (InputHandler.isHoldingForwards(player)) {
                            player.method_5724(1.0f, new class_243(0.0, 0.0, (double)speedForward));
                        }
                        if (InputHandler.isHoldingBackwards(player)) {
                            player.method_5724(1.0f, new class_243(0.0, 0.0, (double)(-speedSideways * 0.8f)));
                        }
                        if (InputHandler.isHoldingLeft(player)) {
                            player.method_5724(1.0f, new class_243((double)speedSideways, 0.0, 0.0));
                        }
                        if (InputHandler.isHoldingRight(player)) {
                            player.method_5724(1.0f, new class_243((double)(-speedSideways), 0.0, 0.0));
                        }
                        if (!player.field_6002.method_8608()) {
                            player.field_6017 = 0.0f;
                            if (player instanceof class_3222) {
                                ((ServerPlayNetworkHandlerAccessor)((class_3222)player).field_13987).setFloatingTicks(0);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean method_7870(class_1799 stack) {
        return ModConfigs.get().general.enchantableJetpacks && this.jetpack.enchantablilty > 0;
    }

    public int method_31569(class_1799 stack) {
        EnergyStorage energy = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack));
        double stored = energy.getCapacity() - energy.getAmount();
        return (int)Math.round(13.0 - stored / (double)energy.getCapacity() * 13.0);
    }

    public boolean method_31567(class_1799 stack) {
        return !this.jetpack.creative;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 advanced) {
        if (!this.jetpack.creative) {
            EnergyStorage energy = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack));
            tooltip.add((class_2561)new class_2585(UnitUtils.formatEnergy(energy.getAmount(), null)).method_27692(class_124.field_1080).method_27693(" / ").method_10852((class_2561)new class_2585(UnitUtils.formatEnergy(this.jetpack.capacity, null))));
        } else {
            tooltip.add((class_2561)new class_2585("-1 E / ").method_27692(class_124.field_1080).method_10852((class_2561)ModTooltips.INFINITE.color(class_124.field_1080)).method_27693(" E"));
        }
        class_5250 tier = ModTooltips.TIER.args(this.jetpack.creative ? "Creative" : Integer.valueOf(this.jetpack.tier)).method_27692(this.jetpack.rarity.field_8908);
        class_5250 engine = ModTooltips.ENGINE.color(this.isEngineOn(stack) ? class_124.field_1060 : class_124.field_1061);
        class_5250 hover = ModTooltips.HOVER.color(this.isHovering(stack) ? class_124.field_1060 : class_124.field_1061);
        tooltip.add((class_2561)ModTooltips.STATE_TOOLTIP_LAYOUT.args(tier, engine, hover));
        if (ModConfigs.getClient().general.enableAdvancedInfoTooltips) {
            tooltip.add((class_2561)new class_2585(""));
            if (!class_437.method_25442()) {
                tooltip.add((class_2561)new class_2588("tooltip.iron-jetpacks.hold_shift_for_info"));
            } else {
                tooltip.add((class_2561)ModTooltips.FUEL_USAGE.args(this.jetpack.usage + " E/t"));
                tooltip.add((class_2561)ModTooltips.VERTICAL_SPEED.args(this.jetpack.speedVert));
                tooltip.add((class_2561)ModTooltips.VERTICAL_ACCELERATION.args(this.jetpack.accelVert));
                tooltip.add((class_2561)ModTooltips.HORIZONTAL_SPEED.args(this.jetpack.speedSide));
                tooltip.add((class_2561)ModTooltips.HOVER_SPEED.args(this.jetpack.speedHoverSlow));
                tooltip.add((class_2561)ModTooltips.DESCEND_SPEED.args(this.jetpack.speedHover));
                tooltip.add((class_2561)ModTooltips.SPRINT_MODIFIER.args(this.jetpack.sprintSpeed));
                tooltip.add((class_2561)ModTooltips.SPRINT_FUEL_MODIFIER.args(this.jetpack.sprintFuel));
            }
        }
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        if (this.method_7877(group)) {
            stacks.add((Object)new class_1799((class_1935)this));
            if (!this.jetpack.creative) {
                class_1799 stack = new class_1799((class_1935)this);
                stack.method_7948().method_10549("energy", this.jetpack.capacity);
                stacks.add((Object)stack);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int getColorTint(int i) {
        return i == 1 ? this.jetpack.color : -1;
    }

    public boolean method_7801(class_1799 stack) {
        return true;
    }

    public int method_7800(class_1799 stack) {
        return this.jetpack.color;
    }

    public void method_7798(class_1799 stack) {
    }

    public void method_7799(class_1799 stack, int color) {
    }

    @Override
    public boolean isEnabled() {
        return !this.jetpack.disabled;
    }

    public Jetpack getJetpack() {
        return this.jetpack;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return this.jetpack.capacity / 20.0;
    }

    public boolean isEngineOn(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("Engine") && tag.method_10577("Engine");
    }

    public boolean toggleEngine(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        boolean current = tag.method_10545("Engine") && tag.method_10577("Engine");
        tag.method_10556("Engine", !current);
        return !current;
    }

    public boolean isHovering(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("Hover") && tag.method_10577("Hover");
    }

    public boolean toggleHover(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        boolean current = tag.method_10545("Hover") && tag.method_10577("Hover");
        tag.method_10556("Hover", !current);
        return !current;
    }

    private void fly(class_1657 player, double y) {
        class_243 motion = player.method_18798();
        player.method_18800(motion.method_10216(), y, motion.method_10215());
    }
}

