/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting;

import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.crafting.ModRecipeSerializers;
import com.blakebr0.ironjetpacks.crafting.recipe.JetpackUpgradeRecipe;
import com.blakebr0.ironjetpacks.item.ModItems;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import java.util.function.BiConsumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

public class JetpackDynamicRecipeManager {
    public static void appendRecipes(BiConsumer<class_2960, class_1860<?>> appender) {
        JetpackRegistry.getInstance().getAllJetpacks().forEach(jetpack -> {
            class_1869 cell = JetpackDynamicRecipeManager.makeCellRecipe(jetpack);
            class_1869 thruster = JetpackDynamicRecipeManager.makeThrusterRecipe(jetpack);
            class_1869 capacitor = JetpackDynamicRecipeManager.makeCapacitorRecipe(jetpack);
            class_1869 jetpackSelf = JetpackDynamicRecipeManager.makeJetpackRecipe(jetpack);
            JetpackUpgradeRecipe jetpackUpgrade = JetpackDynamicRecipeManager.makeJetpackUpgradeRecipe(jetpack);
            if (cell != null) {
                appender.accept(cell.method_8114(), (class_1860<?>)cell);
            }
            if (thruster != null) {
                appender.accept(thruster.method_8114(), (class_1860<?>)thruster);
            }
            if (capacitor != null) {
                appender.accept(capacitor.method_8114(), (class_1860<?>)capacitor);
            }
            if (jetpackSelf != null) {
                appender.accept(jetpackSelf.method_8114(), (class_1860<?>)jetpackSelf);
            }
            if (jetpackUpgrade != null) {
                appender.accept(jetpackUpgrade.method_8114(), (class_1860<?>)jetpackUpgrade);
            }
        });
    }

    private static class_1869 makeCellRecipe(Jetpack jetpack) {
        if (!ModConfigs.get().recipe.enableCellRecipes) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        class_1856 material = jetpack.getCraftingMaterial();
        class_1792 coilItem = jetpacks.getCoilForTier(jetpack.tier);
        if (material == class_1856.field_9017 || coilItem == null) {
            return null;
        }
        class_1856 coil = class_1856.method_8091((class_1935[])new class_1935[]{coilItem});
        class_1856 redstone = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8725});
        class_2371 inputs = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{class_1856.field_9017, redstone, class_1856.field_9017, material, coil, material, class_1856.field_9017, redstone, class_1856.field_9017});
        class_2960 name = new class_2960("iron-jetpacks", jetpack.name + "_cell");
        class_1799 output = new class_1799((class_1935)jetpack.cell);
        return new class_1869(name, "iron-jetpacks:cells", 3, 3, inputs, output);
    }

    private static class_1869 makeThrusterRecipe(Jetpack jetpack) {
        if (!ModConfigs.get().recipe.enableThrusterRecipes) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        class_1856 material = jetpack.getCraftingMaterial();
        class_1792 coilItem = jetpacks.getCoilForTier(jetpack.tier);
        if (material == class_1856.field_9017 || coilItem == null) {
            return null;
        }
        class_1856 coil = class_1856.method_8091((class_1935[])new class_1935[]{coilItem});
        class_1856 cell = class_1856.method_8091((class_1935[])new class_1935[]{jetpack.cell});
        class_1856 furnace = class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_10181});
        class_2371 inputs = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{material, coil, material, coil, cell, coil, material, furnace, material});
        class_2960 name = new class_2960("iron-jetpacks", jetpack.name + "_thruster");
        class_1799 output = new class_1799((class_1935)jetpack.thruster);
        return new class_1869(name, "iron-jetpacks:thrusters", 3, 3, inputs, output);
    }

    private static class_1869 makeCapacitorRecipe(Jetpack jetpack) {
        if (!ModConfigs.get().recipe.enableCapacitorRecipes) {
            return null;
        }
        class_1856 material = jetpack.getCraftingMaterial();
        if (material == class_1856.field_9017) {
            return null;
        }
        class_1856 cell = class_1856.method_8091((class_1935[])new class_1935[]{jetpack.cell});
        class_2371 inputs = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{material, cell, material, material, cell, material, material, cell, material});
        class_2960 name = new class_2960("iron-jetpacks", jetpack.name + "_capacitor");
        class_1799 output = new class_1799((class_1935)jetpack.capacitor);
        return new class_1869(name, "iron-jetpacks:capacitors", 3, 3, inputs, output);
    }

    private static class_1869 makeJetpackRecipe(Jetpack jetpack) {
        if (!ModConfigs.get().recipe.enableJetpackRecipes) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        if (jetpack.tier != jetpacks.getLowestTier()) {
            return null;
        }
        class_1856 material = jetpack.getCraftingMaterial();
        if (material == class_1856.field_9017) {
            return null;
        }
        class_1856 capacitor = class_1856.method_8091((class_1935[])new class_1935[]{jetpack.capacitor});
        class_1856 thruster = class_1856.method_8091((class_1935[])new class_1935[]{jetpack.thruster});
        class_1856 strap = class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ModItems.STRAP.get()});
        class_2371 inputs = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{material, capacitor, material, material, strap, material, thruster, class_1856.field_9017, thruster});
        class_2960 name = new class_2960("iron-jetpacks", jetpack.name + "_jetpack");
        class_1799 output = new class_1799((class_1935)jetpack.item);
        return new class_1869(name, "iron-jetpacks:jetpacks", 3, 3, inputs, output);
    }

    private static JetpackUpgradeRecipe makeJetpackUpgradeRecipe(Jetpack jetpack) {
        if (!ModConfigs.get().recipe.enableJetpackRecipes) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        if (jetpack.tier == jetpacks.getLowestTier()) {
            return null;
        }
        class_1856 material = jetpack.getCraftingMaterial();
        if (material == class_1856.field_9017) {
            return null;
        }
        class_1856 capacitor = class_1856.method_8091((class_1935[])new class_1935[]{jetpack.capacitor});
        class_1856 thruster = class_1856.method_8091((class_1935[])new class_1935[]{jetpack.thruster});
        class_1856 jetpackTier = class_1856.method_8091((class_1935[])((class_1935[])ModRecipeSerializers.ALL_JETPACKS.stream().filter(item -> item.getJetpack().tier == jetpack.tier - 1).toArray(class_1935[]::new)));
        class_2371 inputs = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{material, capacitor, material, material, jetpackTier, material, thruster, class_1856.field_9017, thruster});
        class_2960 name = new class_2960("iron-jetpacks", jetpack.name + "_jetpack");
        class_1799 output = new class_1799((class_1935)jetpack.item);
        return new JetpackUpgradeRecipe(name, "iron-jetpacks:jetpacks", 3, 3, (class_2371<class_1856>)inputs, output);
    }
}

