/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.util;

import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.util.UnitUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import team.reborn.energy.api.EnergyStorage;

@Environment(value=EnvType.CLIENT)
public class HudHelper {
    public static HudPos getHudPos() {
        class_1041 window = class_310.method_1551().method_22683();
        int xOffset = ModConfigs.getClient().hud.hudOffsetX;
        int yOffset = ModConfigs.getClient().hud.hudOffsetY;
        switch (ModConfigs.getClient().hud.hudPosition) {
            case 0: {
                return new HudPos(10 + xOffset, 30 + yOffset, 0);
            }
            case 1: {
                return new HudPos(10 + xOffset, window.method_4502() / 2 + yOffset, 0);
            }
            case 2: {
                return new HudPos(10 + xOffset, window.method_4502() - 30 + yOffset, 0);
            }
            case 3: {
                return new HudPos(window.method_4486() - 8 - xOffset, 30 + yOffset, 1);
            }
            case 4: {
                return new HudPos(window.method_4486() - 8 - xOffset, window.method_4502() / 2 + yOffset, 1);
            }
            case 5: {
                return new HudPos(window.method_4486() - 8 - xOffset, window.method_4502() - 30 + yOffset, 1);
            }
        }
        return null;
    }

    public static int getEnergyBarScaled(JetpackItem jetpack, class_1799 stack) {
        if (jetpack.getJetpack().creative) {
            return 156;
        }
        EnergyStorage energy = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack));
        double i = energy.getAmount();
        double j = energy.getCapacity();
        return (int)(j != 0.0 && i != 0.0 ? (double)((long)i * 156L) / j : 0.0);
    }

    public static String getFuel(JetpackItem jetpack, class_1799 stack) {
        if (jetpack.getJetpack().creative) {
            return ModTooltips.INFINITE.asFormattedString() + class_124.field_1080 + " E";
        }
        double number = ((EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack))).getAmount();
        return UnitUtils.formatEnergy(number, class_124.field_1080);
    }

    public static String getOn(boolean on) {
        return on ? ModTooltips.ON.color(class_124.field_1060).getString() : ModTooltips.OFF.color(class_124.field_1061).getString();
    }

    public static class HudPos {
        public int x;
        public int y;
        public int side;

        public HudPos(int x, int y, int side) {
            this.x = x;
            this.y = y;
            this.side = side;
        }
    }
}

