/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.darkenchanting.util;

import io.github.frqnny.darkenchanting.DarkEnchanting;
import io.github.frqnny.darkenchanting.config.ConfigEnchantment;
import io.github.frqnny.darkenchanting.config.DarkEnchantingConfig;
import io.github.frqnny.darkenchanting.util.BookcaseUtils;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class EnchHelp {
    public static int getXpCost(Object2IntMap<class_1887> map, Object2IntMap<class_1887> stackEnchantments) {
        int cost = EnchHelp.getLevelCost(map, stackEnchantments);
        return cost *= 17;
    }

    public static int getLevelCost(Object2IntMap<class_1887> enchantmentsToApply, Object2IntMap<class_1887> stackEnchantments) {
        float level = 0.0f;
        for (Object2IntMap.Entry entry : enchantmentsToApply.object2IntEntrySet()) {
            class_1887 enchantment = (class_1887)entry.getKey();
            int power = entry.getIntValue();
            float cost = 0.0f;
            boolean takingOff = false;
            if (stackEnchantments.containsKey((Object)enchantment)) {
                int powerOnStack = stackEnchantments.getInt((Object)enchantment);
                int powerToApply = power - powerOnStack;
                if (powerToApply > 0) {
                    cost = EnchHelp.getEnchantmentCost(enchantment, powerToApply, takingOff);
                } else if (powerToApply < 0) {
                    takingOff = true;
                    cost = EnchHelp.getEnchantmentCost(enchantment, Math.absExact(powerToApply), takingOff);
                }
            } else {
                cost = EnchHelp.getEnchantmentCost(enchantment, power, takingOff);
            }
            if (cost == -1000.0f) continue;
            cost += cost * cost / 10.0f;
            if (takingOff) {
                level -= (cost *= DarkEnchanting.CONFIG.receiveFactor);
                continue;
            }
            level += cost;
        }
        return Math.round(level);
    }

    public static float getEnchantmentCost(class_1887 enchantment, int power, boolean takingOff) {
        DarkEnchantingConfig config = DarkEnchanting.CONFIG;
        float cost = config.baseCost;
        cost *= Math.max((11.0f - (float)enchantment.method_8186().method_8197()) / config.weightDivisor, 1.0f);
        cost *= (float)power;
        cost *= config.costFactor;
        if (enchantment.method_8195()) {
            cost *= config.curseFactor;
        } else if (enchantment.method_8193()) {
            cost *= config.treasureFactor;
        }
        Optional<ConfigEnchantment> configEnchantmentOptional = ConfigEnchantment.getConfigEnchantmentFor(enchantment);
        if (configEnchantmentOptional.isPresent()) {
            ConfigEnchantment configEnchantment = configEnchantmentOptional.get();
            if (!configEnchantment.activated) {
                return -1000.0f;
            }
            cost *= configEnchantment.personalFactor;
            if (takingOff) {
                cost *= configEnchantment.personalReceiveFactor;
            }
        }
        return cost;
    }

    public static int getRepairCost(class_1799 stack) {
        float cost = 0.0f;
        if (stack.method_7986()) {
            cost += (float)stack.method_7919();
            if (stack.method_7909() instanceof class_1831) {
                cost *= 0.7f;
            }
            return (int)Math.ceil(Math.max(1.0, (double)(cost *= DarkEnchanting.CONFIG.repairFactor)));
        }
        return 0;
    }

    public static boolean applyEnchantXP(class_1657 player, Object2IntLinkedOpenHashMap<class_1887> enchantmentsToApply, Object2IntLinkedOpenHashMap<class_1887> enchantmentsOnStack, double discount) {
        boolean canApplyXp;
        int totalExperience = player.field_7495;
        int xp = BookcaseUtils.applyDiscount(EnchHelp.getXpCost(enchantmentsToApply, enchantmentsOnStack), discount);
        boolean bl = canApplyXp = totalExperience >= xp || player.method_7337();
        if (canApplyXp) {
            player.method_7255(-xp);
        }
        return canApplyXp;
    }

    public static boolean applyRepairXP(class_1657 player, class_1799 stack, double discount) {
        boolean canApplyXp;
        int totalExperience = player.field_7495;
        int xpCost = BookcaseUtils.applyDiscount(EnchHelp.getRepairCost(stack), discount);
        boolean bl = canApplyXp = totalExperience >= xpCost || player.method_7337();
        if (canApplyXp) {
            player.method_7255(-xpCost);
        }
        return canApplyXp;
    }

    public static void set(Map<class_1887, Integer> enchantments, class_1799 stack) {
        class_2499 nbtList = new class_2499();
        for (Map.Entry<class_1887, Integer> entry : enchantments.entrySet()) {
            int i;
            class_1887 enchantment = entry.getKey();
            if (enchantment == null || (i = entry.getValue().intValue()) <= 0 || i > enchantment.method_8183()) continue;
            nbtList.add((Object)class_1890.method_37426((class_2960)class_1890.method_37423((class_1887)enchantment), (int)i));
        }
        if (nbtList.isEmpty()) {
            stack.method_7983("Enchantments");
        } else if (!stack.method_31574(class_1802.field_8598)) {
            stack.method_7959("Enchantments", (class_2520)nbtList);
        }
    }
}

