/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.toolstats;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.toolstats.Constants;
import net.darkhax.toolstats.config.ConfigSchema;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3494;
import net.minecraft.class_471;
import net.minecraft.class_486;

public class ToolStatsCommon {
    private final class_3494<class_1792> TAG_IGNORE = ToolStatsCommon.itemTag("ignored");
    private final class_3494<class_1792> TAG_IGNORE_HARVEST_LEVEL = ToolStatsCommon.itemTag("ignore_harvest_level");
    private final class_3494<class_1792> TAG_IGNORE_DIG_SPEED = ToolStatsCommon.itemTag("ignore_dig_speed");
    private final class_3494<class_1792> TAG_IGNORE_ENCHANTABILITY = ToolStatsCommon.itemTag("ignore_enchantability");
    private final class_3494<class_1792> TAG_IGNORE_REPAIR_COST = ToolStatsCommon.itemTag("ignore_repair_cost");
    private final class_3494<class_1792> TAG_IGNORE_DURABILITY = ToolStatsCommon.itemTag("ignore_durability");
    private final ConfigSchema config;
    private final Function<class_1799, Integer> enchantabilityResolver;
    private final Function<class_1832, Integer> harvestLevelResolver;
    private final Map<class_1832, class_2561> digSpeedCache = new HashMap<class_1832, class_2561>();
    private final Int2ObjectMap<class_2561> enchantabilityCache = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<class_2561> repairCostCache = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<class_2561> harvestLevelCache = new Int2ObjectOpenHashMap();

    public ToolStatsCommon(Path configDir, Function<class_1799, Integer> enchantabilityResolver, Function<class_1832, Integer> harvestLevelResolver) {
        this.config = ConfigSchema.load(configDir.resolve("toolstats.json").toFile());
        this.enchantabilityResolver = enchantabilityResolver;
        this.harvestLevelResolver = harvestLevelResolver;
        Services.EVENTS.addItemTooltipListener(this::displayTooltipInfo);
    }

    private void displayTooltipInfo(class_1799 stack, List<class_2561> tooltip, class_1836 context) {
        class_1792 item = stack.method_7909();
        if (!this.TAG_IGNORE.method_15141((Object)item)) {
            int repairCost;
            int enchantability;
            ArrayList<Object> additions = new ArrayList<Object>();
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1831) {
                class_1831 tieredItem = (class_1831)class_17922;
                if (!this.TAG_IGNORE_HARVEST_LEVEL.method_15141((Object)item) && this.config.showHarvestLevel) {
                    additions.add((class_2561)this.harvestLevelCache.computeIfAbsent((Object)this.harvestLevelResolver.apply(tieredItem.method_8022()), lvl -> new class_2588("tooltip.toolstats.harvestlevel", new Object[]{lvl}).method_27692(class_124.field_1077)));
                }
                if (!this.TAG_IGNORE_DIG_SPEED.method_15141((Object)item) && this.config.showEfficiency) {
                    additions.add(this.digSpeedCache.computeIfAbsent(tieredItem.method_8022(), tier -> new class_2588("tooltip.toolstats.efficiency", new Object[]{Constants.DECIMAL_FORMAT.format(tier.method_8027())}).method_27692(class_124.field_1077)));
                }
            }
            if (!this.TAG_IGNORE_ENCHANTABILITY.method_15141((Object)item) && this.config.showEnchantability && (this.config.alwaysShowEnchantability || class_310.method_1551().field_1755 instanceof class_486) && (enchantability = this.enchantabilityResolver.apply(stack).intValue()) > 0) {
                additions.add((class_2561)this.enchantabilityCache.computeIfAbsent(enchantability, enchLvl -> new class_2588("tooltip.toolstats.enchantability", new Object[]{enchLvl}).method_27692(class_124.field_1077)));
            }
            if (!this.TAG_IGNORE_REPAIR_COST.method_15141((Object)item) && this.config.showRepairCost && (this.config.alwaysShowRepairCost || class_310.method_1551().field_1755 instanceof class_471) && (repairCost = stack.method_7928()) > 0) {
                additions.add((class_2561)this.repairCostCache.computeIfAbsent(repairCost, cost -> new class_2588("tooltip.toolstats.repaircost", new Object[]{cost}).method_27692(class_124.field_1077)));
            }
            if (!context.method_8035() && !this.TAG_IGNORE_DURABILITY.method_15141((Object)item) && this.config.showDurability && stack.method_7963() && (this.config.alwaysShowDurability || stack.method_7986())) {
                additions.add(new class_2588("item.durability", new Object[]{stack.method_7936() - stack.method_7919(), stack.method_7936()}));
            }
            if (!additions.isEmpty()) {
                tooltip.addAll(ToolStatsCommon.getInsertOffset(context.method_8035(), tooltip.size(), stack), additions);
            }
        }
    }

    private static int getInsertOffset(boolean advanced, int tooltipSize, class_1799 stack) {
        int offset = 0;
        if (advanced) {
            ++offset;
            if (stack.method_7985()) {
                ++offset;
            }
            if (stack.method_7986()) {
                ++offset;
            }
        }
        return Math.max(0, tooltipSize - offset);
    }

    private static class_3494<class_1792> itemTag(String key) {
        return Services.TAGS.itemTag(new class_2960("toolstats", key));
    }
}

