/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.registry;

import com.google.common.collect.Maps;
import dev.architectury.registry.block.BlockProperties;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2440;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.BMBlock;
import party.lemons.biomemakeover.block.BMButtonBlock;
import party.lemons.biomemakeover.block.BMDoorBlock;
import party.lemons.biomemakeover.block.BMFenceBlock;
import party.lemons.biomemakeover.block.BMFenceGateBlock;
import party.lemons.biomemakeover.block.BMPillarBlock;
import party.lemons.biomemakeover.block.BMPressurePlateBlock;
import party.lemons.biomemakeover.block.BMSlabBlock;
import party.lemons.biomemakeover.block.BMStairBlock;
import party.lemons.biomemakeover.block.BMTrapdoorBlock;
import party.lemons.biomemakeover.block.modifier.FlammableModifier;
import party.lemons.biomemakeover.block.modifier.RTypeModifier;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.item.BMBoatItem;
import party.lemons.biomemakeover.util.StripUtil;
import party.lemons.biomemakeover.util.access.BlockEntityTypeAccess;
import party.lemons.biomemakeover.util.registry.BlockWithItem;
import party.lemons.biomemakeover.util.registry.DecorationBlockInfo;
import party.lemons.biomemakeover.util.registry.RType;
import party.lemons.biomemakeover.util.registry.boat.BoatType;
import party.lemons.biomemakeover.util.registry.sign.WoodTypeHelper;

public class WoodTypeInfo {
    private final Map<Type, class_2248> blocks = Maps.newHashMap();
    private final Map<Type, class_1792> items = Maps.newHashMap();
    private final class_4719 woodType;
    private final String name;
    private final class_4970.class_2251 settings;
    private final DecorationBlockInfo.Callback callback;
    private final class_2680 defaultState;
    private final String modid;
    private final class_1761 group;

    public WoodTypeInfo(String modid, class_1761 group, String name, class_4970.class_2251 settings) {
        this(modid, group, name, settings, null);
    }

    public WoodTypeInfo(String modid, class_1761 group, String name, class_4970.class_2251 settings, DecorationBlockInfo.Callback callback) {
        this.modid = modid;
        this.name = name;
        this.settings = settings;
        this.callback = callback;
        this.group = group;
        this.woodType = WoodTypeHelper.register(name);
        this.set(Type.LOG, (class_2248)new BMPillarBlock(settings).modifiers(FlammableModifier.WOOD));
        this.set(Type.STRIPPED_LOG, (class_2248)new BMPillarBlock(settings).modifiers(FlammableModifier.WOOD));
        this.set(Type.PLANK, new BMBlock(settings).modifiers(FlammableModifier.WOOD));
        StripUtil.addStrippedLog(this.getBlock(Type.LOG), this.getBlock(Type.STRIPPED_LOG));
        this.defaultState = this.getBlock(Type.PLANK).method_9564();
    }

    public WoodTypeInfo slab() {
        this.set(Type.SLAB, (class_2248)new BMSlabBlock(this.settings).modifiers(FlammableModifier.WOOD));
        return this;
    }

    public WoodTypeInfo stair() {
        this.set(Type.STAIR, (class_2248)new BMStairBlock(this.defaultState, this.settings).modifiers(FlammableModifier.WOOD));
        return this;
    }

    public WoodTypeInfo fence() {
        this.set(Type.FENCE, (class_2248)new BMFenceBlock(this.settings).modifiers(FlammableModifier.WOOD));
        this.set(Type.FENCE_GATE, (class_2248)new BMFenceGateBlock(this.settings).modifiers(FlammableModifier.WOOD));
        return this;
    }

    public WoodTypeInfo wood() {
        this.set(Type.WOOD, (class_2248)new BMPillarBlock(this.settings).modifiers(FlammableModifier.WOOD));
        this.set(Type.STRIPPED_WOOD, (class_2248)new BMPillarBlock(this.settings).modifiers(FlammableModifier.WOOD));
        StripUtil.addStrippedLog(this.getBlock(Type.WOOD), this.getBlock(Type.STRIPPED_WOOD));
        return this;
    }

    public WoodTypeInfo pressure_plate() {
        this.set(Type.PRESSURE_PLATE, (class_2248)new BMPressurePlateBlock(class_2440.class_2441.field_11361, BlockProperties.copy((class_4970.class_2251)this.settings).method_9634()));
        return this;
    }

    public WoodTypeInfo button() {
        this.set(Type.BUTTON, (class_2248)new BMButtonBlock(BlockProperties.copy((class_4970.class_2251)this.settings).method_9634()));
        return this;
    }

    public WoodTypeInfo trapdoor() {
        this.set(Type.TRAP_DOOR, (class_2248)new BMTrapdoorBlock(BlockProperties.copy((class_4970.class_2251)this.settings).method_22488()).modifiers(RTypeModifier.create(RType.CUTOUT)));
        return this;
    }

    public WoodTypeInfo door() {
        this.set(Type.DOOR, (class_2248)new BMDoorBlock(BlockProperties.copy((class_4970.class_2251)this.settings).method_22488()).modifiers(RTypeModifier.create(RType.CUTOUT)));
        return this;
    }

    public WoodTypeInfo sign() {
        class_2508 standing = new class_2508(BMBlocks.properties(class_3614.field_15932, 1.0f).method_9626(class_2498.field_11547).method_9634(), this.woodType);
        class_2551 wall = new class_2551(BMBlocks.properties(class_3614.field_15932, 1.0f).method_9626(class_2498.field_11547).method_9634(), this.woodType);
        this.set(Type.SIGN, (class_2248)standing);
        this.set(Type.SIGN_WALL, (class_2248)wall);
        this.set(Type.SIGN, (class_1792)new class_1822(WoodTypeInfo.properties(), (class_2248)standing, (class_2248)wall));
        ((BlockEntityTypeAccess)class_2591.field_11911).bm_addBlockTypes(new class_2248[]{standing, wall});
        return this;
    }

    public static class_1792.class_1793 properties() {
        return new class_1792.class_1793().method_7892(BiomeMakeover.TAB);
    }

    public WoodTypeInfo boat(Supplier<BoatType> boatType) {
        this.set(Type.BOAT, new BMBoatItem(boatType, WoodTypeInfo.properties().method_7889(1)));
        return this;
    }

    public WoodTypeInfo all() {
        return this.slab().stair().fence().wood().pressure_plate().button().trapdoor().door().sign();
    }

    private void set(Type type, class_2248 block) {
        this.blocks.put(type, block);
    }

    private void set(Type type, class_1792 item) {
        this.items.put(type, item);
    }

    public class_2248 getBlock(Type type) {
        return this.blocks.get((Object)type);
    }

    public class_1792 getItem(Type type) {
        return this.items.get((Object)type);
    }

    public WoodTypeInfo register() {
        DeferredRegister bR = DeferredRegister.create((String)"biomemakeover", (class_5321)class_2378.field_25105);
        DeferredRegister iR = DeferredRegister.create((String)"biomemakeover", (class_5321)class_2378.field_25108);
        for (Type key : this.blocks.keySet()) {
            class_2248 bl = this.blocks.get((Object)key);
            bR.register(key.make(this.modid, this.name), () -> bl);
            if (key.hasBlockItem) {
                if (bl instanceof BlockWithItem) {
                    BlockWithItem bwi = (BlockWithItem)bl;
                    iR.register(key.make(this.modid, this.name), bwi::makeItem);
                } else {
                    iR.register(key.make(this.modid, this.name), () -> new class_1747(bl, WoodTypeInfo.properties()));
                }
            }
            if (this.callback == null) continue;
            this.callback.onCreateBlock(bl);
        }
        for (Type key : this.items.keySet()) {
            iR.register(key.make(this.modid, this.name), () -> this.items.get((Object)key));
        }
        bR.register();
        iR.register();
        return this;
    }

    public static enum Type {
        LOG("", "log", true),
        WOOD("", "wood", true),
        PLANK("", "planks", true),
        STRIPPED_LOG("stripped", "log", true),
        STRIPPED_WOOD("stripped", "wood", true),
        SLAB("", "slab", true),
        STAIR("", "stairs", true),
        FENCE("", "fence", true),
        FENCE_GATE("", "fence_gate", true),
        PRESSURE_PLATE("", "pressure_plate", true),
        BUTTON("", "button", true),
        TRAP_DOOR("", "trapdoor", true),
        DOOR("", "door", true),
        SIGN("", "sign", false),
        SIGN_WALL("", "wall_sign", false),
        BOAT("", "boat", true);

        private final String postfix;
        private final String prefix;
        private final boolean isItem;
        private final boolean hasBlockItem;

        private Type(String prefix, String postfix, boolean hasBlockItem) {
            this(prefix, postfix, hasBlockItem, false);
        }

        private Type(String prefix, String postfix, boolean hasBlockItem, boolean isItem) {
            this.postfix = postfix;
            this.prefix = prefix;
            this.isItem = isItem;
            this.hasBlockItem = hasBlockItem;
        }

        public class_2960 make(String modid, String name) {
            Object s = "";
            if (!this.prefix.isEmpty()) {
                s = (String)s + this.prefix + "_";
            }
            s = (String)s + name;
            if (!this.postfix.isEmpty()) {
                s = (String)s + "_" + this.postfix;
            }
            return new class_2960(modid, (String)s);
        }
    }

    public static interface Callback {
        public void onCreateBlock(class_2248 var1);
    }
}

