/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.registry;

import com.google.common.collect.Maps;
import dev.architectury.registry.registries.DeferredRegister;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Pair;
import party.lemons.biomemakeover.util.registry.BlockWithItem;

public final class RegistryHelper {
    private static HashMap<class_2378, DeferredRegister> DEFERRED_REGISTRIES = Maps.newHashMap();

    @SafeVarargs
    public static <T> void register(String modid, class_2378<T> registry, Class typeClass, Class from, RegistryCallback<T> ... callbacks) {
        class_5321 key = registry.method_30517();
        DeferredRegister register = DeferredRegister.create((String)modid, (class_5321)key);
        try {
            Field[] fields;
            for (Field field : fields = from.getDeclaredFields()) {
                if (!typeClass.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                Object value = field.get(from);
                String regName = field.getName().toLowerCase(Locale.ENGLISH);
                class_2960 id = new class_2960(modid, regName);
                register.register(id, () -> value);
                for (RegistryCallback<Object> registryCallback : callbacks) {
                    registryCallback.callback(registry, value, id);
                }
            }
            register.register();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void registerObject(class_2378<T> registry, class_2960 id, T object) {
        DeferredRegister r = DeferredRegister.create((String)id.method_12836(), (class_5321)registry.method_30517());
        r.register(id, () -> object);
        r.register();
    }

    public static <T> void gatherFields(String modid, Class<T> typeClass, Class<?> from, List<Pair<class_2960, T>> list) {
        try {
            Field[] fields;
            for (Field field : fields = from.getDeclaredFields()) {
                if (!typeClass.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                Object value = field.get(from);
                String regName = field.getName().toLowerCase(Locale.ENGLISH);
                class_2960 id = new class_2960(modid, regName);
                list.add(Pair.of((Object)id, (Object)value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RegistryHelper() {
    }

    public static interface RegistryCallback<T> {
        public void callback(class_2378<T> var1, T var2, class_2960 var3);
    }

    public static class BlockWithItemCallback
    implements RegistryCallback<class_2248> {
        private final class_1761 group;

        public BlockWithItemCallback(class_1761 group) {
            this.group = group;
        }

        @Override
        public void callback(class_2378<class_2248> registry, class_2248 bl, class_2960 id) {
            if (!(bl instanceof BlockWithItem)) {
                return;
            }
            BlockWithItem info = (BlockWithItem)bl;
            if (!info.hasItem()) {
                return;
            }
            info.registerItem(id, this.group);
        }
    }
}

