/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.registry;

import com.google.common.collect.Maps;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2482;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import party.lemons.biomemakeover.block.BMStairBlock;
import party.lemons.biomemakeover.init.BMItems;

public class DecorationBlockInfo {
    private final Map<Type, class_2248> blocks = Maps.newHashMap();
    private final String name;
    private final class_4970.class_2251 settings;
    private final class_2248 base;
    private final Callback callback;
    private final String modid;

    public DecorationBlockInfo(String modid, String name, class_2248 baseBlock, class_4970.class_2251 settings) {
        this(modid, name, baseBlock, settings, null);
    }

    public DecorationBlockInfo(String modid, String name, class_2248 baseBlock, class_4970.class_2251 settings, Callback callback) {
        this.modid = modid;
        this.name = name;
        this.settings = settings;
        this.base = baseBlock;
        this.callback = callback;
    }

    public DecorationBlockInfo slab() {
        this.set(Type.SLAB, (class_2248)new class_2482(this.settings));
        return this;
    }

    public DecorationBlockInfo stair() {
        this.set(Type.STAIR, (class_2248)new BMStairBlock(this.base.method_9564(), this.settings));
        return this;
    }

    public DecorationBlockInfo wall() {
        this.set(Type.WALL, (class_2248)new class_2544(this.settings));
        return this;
    }

    public DecorationBlockInfo all() {
        return this.slab().stair().wall();
    }

    private void set(Type type, class_2248 block) {
        this.blocks.put(type, block);
    }

    public class_2248 get(Type type) {
        return this.blocks.get((Object)type);
    }

    public DecorationBlockInfo register() {
        DeferredRegister bR = DeferredRegister.create((String)"biomemakeover", (class_5321)class_2378.field_25105);
        DeferredRegister iR = DeferredRegister.create((String)"biomemakeover", (class_5321)class_2378.field_25108);
        for (Type key : this.blocks.keySet()) {
            class_2248 bl = this.blocks.get((Object)key);
            bR.register(key.make(this.modid, this.name), () -> bl);
            iR.register(key.make(this.modid, this.name), () -> new class_1747(bl, BMItems.properties()));
            if (this.callback == null) continue;
            this.callback.onCreateBlock(bl);
        }
        bR.register();
        iR.register();
        return this;
    }

    public static interface Callback {
        public void onCreateBlock(class_2248 var1);
    }

    public static enum Type {
        SLAB("slab"),
        STAIR("stairs"),
        WALL("wall");

        private final String postfix;

        private Type(String postfix) {
            this.postfix = postfix;
        }

        public class_2960 make(String modid, String name) {
            return new class_2960(modid, name + "_" + this.postfix);
        }
    }
}

