/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.data.wiki;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1293;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1813;
import net.minecraft.class_1827;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4174;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.modifier.CompostModifier;
import party.lemons.biomemakeover.block.modifier.FlammableModifier;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.util.data.wiki.BlockModifiersWiki;
import party.lemons.biomemakeover.util.data.wiki.BlockPage;
import party.lemons.biomemakeover.util.data.wiki.BlockSettingsWiki;
import party.lemons.biomemakeover.util.data.wiki.BlockTagsWiki;
import party.lemons.biomemakeover.util.data.wiki.EffectWiki;
import party.lemons.biomemakeover.util.data.wiki.FoodWiki;
import party.lemons.biomemakeover.util.data.wiki.ItemPage;

public final class WikiGenerator {
    private static final List<ItemPage> ITEMS = Lists.newArrayList();
    private static final List<BlockPage> BLOCKS = Lists.newArrayList();
    private static String ITEM_TEMPLATE;
    private static String BLOCK_TEMPLATE;

    public static void generate() {
        for (class_1792 item : class_2378.field_11142) {
            if (!WikiGenerator.isValidItem(item)) continue;
            WikiGenerator.generateItem(item);
        }
        for (class_2248 block : class_2378.field_11146) {
            if (!WikiGenerator.isValidBlock(block)) continue;
            WikiGenerator.generateBlock(block);
        }
        WikiGenerator.doOutput();
    }

    private static void doOutput() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.createDirectories(Paths.get("wiki/template/", new String[0]), new FileAttribute[0]);
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(Paths.get("wiki/template/item_template.md", new String[0])).forEach(s -> builder.append((String)s).append("\n"));
            ITEM_TEMPLATE = builder.toString();
            Files.createDirectories(Paths.get("wiki/items/pages/", new String[0]), new FileAttribute[0]);
            StringBuilder blockBuilder = new StringBuilder();
            Files.readAllLines(Paths.get("wiki/template/block_template.md", new String[0])).forEach(s -> blockBuilder.append((String)s).append("\n"));
            BLOCK_TEMPLATE = blockBuilder.toString();
            Files.createDirectories(Paths.get("wiki/blocks/pages/", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ITEMS.forEach(i -> {
            try {
                FileWriter writer = new FileWriter("wiki/items/" + WikiGenerator.idToFileName(i.id()) + ".json");
                gson.toJson(i, (Appendable)writer);
                writer.flush();
                writer.close();
                FileWriter fileWriter = new FileWriter("wiki/items/pages/" + WikiGenerator.idToFileName(i.id()) + ".md");
                PrintWriter printWriter = new PrintWriter(fileWriter);
                String pageString = ITEM_TEMPLATE.replace("[ITEM_NAME]", i.name()).replace("[ITEM_FILE]", WikiGenerator.idToFileName(i.id()));
                printWriter.println(pageString);
                fileWriter.flush();
                printWriter.close();
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        BLOCKS.forEach(i -> {
            try {
                FileWriter writer = new FileWriter("wiki/blocks/" + WikiGenerator.idToFileName(i.id()) + ".json");
                gson.toJson(i, (Appendable)writer);
                writer.flush();
                writer.close();
                FileWriter fileWriter = new FileWriter("wiki/blocks/pages/" + WikiGenerator.idToFileName(i.id()) + ".md");
                PrintWriter printWriter = new PrintWriter(fileWriter);
                String pageString = BLOCK_TEMPLATE.replace("[BLOCK_NAME]", i.name()).replace("[BLOCK_FILE]", WikiGenerator.idToFileName(i.id()));
                printWriter.println(pageString);
                fileWriter.flush();
                printWriter.close();
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static String getItemDescription() {
        return "This item does not have a description yet!";
    }

    private static String getBlockDescription() {
        return "This block does not have a description yet!";
    }

    private static void generateItem(class_1792 item) {
        if (item instanceof class_1813) {
            class_1813 record = (class_1813)item;
            ITEMS.add(new RecordItemPageImpl(record));
        } else {
            ITEMS.add(new ItemPageImpl(item));
        }
    }

    private static void generateBlock(class_2248 block) {
        BLOCKS.add(new BlockPageImpl(block));
    }

    private static boolean isValidItem(class_1792 item) {
        return class_2378.field_11142.method_10221((Object)item).method_12836().equals("biomemakeover") && item.getClass() != class_1747.class && !(item instanceof class_1827);
    }

    private static boolean isValidBlock(class_2248 block) {
        return class_2378.field_11146.method_10221((Object)block).method_12836().equals("biomemakeover") && !BMBlocks.TAPESTRY_WALL_BLOCKS.contains(block);
    }

    private static String idToFileName(String id) {
        return id.split(":")[1];
    }

    private WikiGenerator() {
    }

    private static class RecordItemPageImpl
    extends ItemPageImpl {
        public RecordItemPageImpl(class_1813 record) {
            super((class_1792)record);
            this.name = this.name() + " (" + class_1074.method_4662((String)(record.method_7876() + ".desc"), (Object[])new Object[0]) + ")";
        }
    }

    public static class ItemPageImpl
    implements ItemPage {
        protected String name;
        protected String id;
        protected String description;
        @Nullable
        protected FoodWiki food;
        @Nullable
        protected ArmorWikiImpl armor;
        protected List<String> tags = Lists.newArrayList();

        public ItemPageImpl(class_1792 item) {
            this.name = class_1074.method_4662((String)item.method_7876(), (Object[])new Object[0]);
            this.id = class_2378.field_11142.method_10221((Object)item).toString();
            this.description = WikiGenerator.getItemDescription();
            if (item.method_19264() != null) {
                this.food = new FoodWikiImpl(item.method_19264());
                this.tags.add("food");
            }
            if (item instanceof class_1738) {
                class_1738 armor = (class_1738)item;
                this.armor = new ArmorWikiImpl(armor);
                this.tags.add("armor");
                this.tags.add(armor.method_7686().method_7694());
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        @Nullable
        public FoodWiki food() {
            return this.food;
        }

        @Override
        public List<String> getTags() {
            return this.tags;
        }
    }

    private static class BlockPageImpl
    implements BlockPage {
        protected String name;
        protected String id;
        protected String description;
        protected BlockSettingsWiki settings;
        protected BlockTagsWiki blockTags;
        protected BlockModifiersWiki modifiers;
        protected List<String> tags = Lists.newArrayList();

        public BlockPageImpl(class_2248 block) {
            this.name = class_1074.method_4662((String)block.method_9539(), (Object[])new Object[0]);
            this.id = class_2378.field_11146.method_10221((Object)block).toString();
            this.description = WikiGenerator.getBlockDescription();
            this.settings = new BlockSettingsWikiImpl(block);
            this.blockTags = new BlockTagsWikiImpl(block);
            this.modifiers = new BlockModifiersWikiImpl(block);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public BlockSettingsWiki settings() {
            return this.settings;
        }

        @Override
        public BlockTagsWiki tags() {
            return this.blockTags;
        }

        @Override
        public BlockModifiersWiki modifiers() {
            return this.modifiers;
        }

        @Override
        public List<String> getTags() {
            return this.tags;
        }
    }

    private static class BlockModifiersWikiImpl
    implements BlockModifiersWiki {
        private float compostChance = 0.0f;
        private int flameCatchChance = 0;
        private int flameBurnChance = 0;

        public BlockModifiersWikiImpl(class_2248 block) {
            for (CompostModifier.CompostValue compostValue : BMBlocks.COMPOSTABLES) {
                if (compostValue.block() != block) continue;
                this.compostChance = compostValue.chance();
            }
            if (FlammableModifier.CATCH_ODDS.containsKey(block)) {
                this.flameCatchChance = FlammableModifier.CATCH_ODDS.get(block);
                this.flameBurnChance = FlammableModifier.BURN_ODDS.get(block);
            }
        }

        @Override
        public float compostChance() {
            return this.compostChance;
        }

        @Override
        public int flameCatchChance() {
            return this.flameCatchChance;
        }

        @Override
        public int flameBurnChance() {
            return this.flameBurnChance;
        }
    }

    private static class BlockTagsWikiImpl
    implements BlockTagsWiki {
        List<String> tags = Lists.newArrayList();

        public BlockTagsWikiImpl(class_2248 block) {
            this.tags.addAll(class_3481.method_15073().method_30206((Object)block).stream().map(class_2960::toString).toList());
        }

        @Override
        public List<String> blocktags() {
            return this.tags;
        }
    }

    private static class BlockSettingsWikiImpl
    implements BlockSettingsWiki {
        private float explosionResistance;
        private float destroyTime;
        private boolean requiresTool;

        public BlockSettingsWikiImpl(class_2248 block) {
            this.explosionResistance = block.method_9520();
            this.destroyTime = block.method_36555();
            this.requiresTool = block.method_9564().method_29291();
        }

        @Override
        public float explosionResistance() {
            return this.explosionResistance;
        }

        @Override
        public float destroyTime() {
            return this.destroyTime;
        }

        @Override
        public boolean requiresTool() {
            return this.requiresTool;
        }
    }

    private static class ArmorWikiImpl {
        protected String armorName;
        protected float defence;
        protected float toughness;
        protected float enchantment;
        protected float knockbackResistance;
        protected String slot;
        protected String[] repairItems;

        public ArmorWikiImpl(class_1738 armor) {
            class_1741 material = armor.method_7686();
            this.armorName = WordUtils.capitalize((String)material.method_7694());
            this.defence = armor.method_7687();
            this.toughness = armor.method_7837();
            this.knockbackResistance = material.method_24355();
            this.slot = WordUtils.capitalize((String)armor.method_7685().method_5923());
            int repairLength = material.method_7695().method_8105().length;
            if (repairLength != 0) {
                this.repairItems = new String[repairLength];
                for (int i = 0; i < repairLength; ++i) {
                    this.repairItems[i] = class_1074.method_4662((String)material.method_7695().method_8105()[i].method_7922(), (Object[])new Object[0]);
                }
            }
        }
    }

    private static class EffectWikiImpl
    implements EffectWiki {
        protected String name;
        protected float length;
        protected int level;
        protected float chance;

        public EffectWikiImpl(class_1293 first, Float chance) {
            this.name = class_1074.method_4662((String)first.method_5586(), (Object[])new Object[0]);
            this.length = first.method_5584();
            this.level = first.method_5578();
            this.chance = chance.floatValue();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public float length() {
            return this.length;
        }

        @Override
        public int level() {
            return this.level;
        }

        @Override
        public float chance() {
            return this.chance;
        }
    }

    private static class FoodWikiImpl
    implements FoodWiki {
        protected float saturation;
        protected float nutrition;
        protected EffectWiki[] effects;
        protected boolean alwaysEat;

        public FoodWikiImpl(class_4174 food) {
            this.alwaysEat = food.method_19233();
            this.saturation = food.method_19231();
            this.nutrition = food.method_19230();
            if (!food.method_19235().isEmpty()) {
                this.effects = new EffectWiki[food.method_19235().size()];
                for (int i = 0; i < food.method_19235().size(); ++i) {
                    Pair effect = (Pair)food.method_19235().get(i);
                    this.effects[i] = new EffectWikiImpl((class_1293)effect.getFirst(), (Float)effect.getSecond());
                }
            }
        }

        @Override
        public float saturation() {
            return this.saturation;
        }

        @Override
        public float nutrition() {
            return this.nutrition;
        }

        @Override
        public boolean alwaysEat() {
            return this.alwaysEat;
        }
    }
}

