/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.color;

import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.util.MathUtils;
import party.lemons.biomemakeover.util.color.FoliageBlockColorProvider;

public class FoliageShiftBlockColorProvider
extends FoliageBlockColorProvider {
    protected final int rShift;
    protected final int gShift;
    protected final int bShift;

    public FoliageShiftBlockColorProvider(int rShift, int gShift, int bShift) {
        this.rShift = rShift;
        this.gShift = gShift;
        this.bShift = bShift;
    }

    @Override
    public int getColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
        if (tintIndex == 0) {
            int color = super.getColor(state, world, pos, tintIndex);
            int[] boosts = this.getColorBoosts(world, state, pos, tintIndex);
            return MathUtils.colourBoost(color, boosts[0], boosts[1], boosts[2]);
        }
        return 0xFFFFFF;
    }

    protected int[] getColorBoosts(class_1920 world, class_2680 state, class_2338 pos, int tintIndex) {
        return new int[]{this.rShift, this.gShift, this.bShift};
    }

    public static class Willow
    extends FoliageShiftBlockColorProvider {
        public Willow() {
            super(0, 0, 0);
        }

        @Override
        protected int[] getColorBoosts(class_1920 world, class_2680 state, class_2338 pos, int tintIndex) {
            if (world instanceof class_638 && ((class_638)world).method_23753(pos).method_8688() == class_1959.class_1961.field_9364) {
                return new int[]{-10, 15, -10};
            }
            return super.getColorBoosts(world, state, pos, tintIndex);
        }
    }

    public static class Lillies
    extends FoliageShiftBlockColorProvider {
        public Lillies() {
            super(-10, 10, -10);
        }

        @Override
        protected int[] getColorBoosts(class_1920 world, class_2680 state, class_2338 pos, int tintIndex) {
            if (world instanceof class_638 && pos != null && ((class_638)world).method_23753(pos).method_8688() == class_1959.class_1961.field_9364) {
                return new int[]{-20, 40, -20};
            }
            return super.getColorBoosts(world, state, pos, tintIndex);
        }
    }
}

